/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.rest.custom;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.std.SerializerBase;

public class AnnotationJsonSerializer
extends SerializerBase<Annotation> {
    private String typeFieldName = "@class";

    public AnnotationJsonSerializer(Class<Annotation> type) {
        super(type);
    }

    public String getTypeFieldName() {
        return this.typeFieldName;
    }

    public void setTypeFieldName(String typeFieldName) {
        this.typeFieldName = typeFieldName;
    }

    public void serialize(Annotation value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        block6: {
            int i$ = 0;
            Class<?>[] arr$ = value.getClass().getInterfaces();
            int len$ = arr$.length;
            if (i$ >= len$) break block6;
            Class<?> iface = arr$[i$];
            if (iface.isAnnotation()) {
                jgen.writeStartObject();
                jgen.writeStringField(this.getTypeFieldName(), iface.getName());
                for (Method method : iface.getDeclaredMethods()) {
                    if (!this.isValidAnnotationMethod(method)) continue;
                    try {
                        this.serializeAnnotationAttribute(method, value, jgen);
                    }
                    catch (IllegalArgumentException iarge) {
                        throw new JsonGenerationException(iarge.fillInStackTrace());
                    }
                    catch (IllegalAccessException iacce) {
                        throw new JsonGenerationException(iacce.fillInStackTrace());
                    }
                    catch (InvocationTargetException ite) {
                        throw new JsonGenerationException(ite.fillInStackTrace());
                    }
                }
            }
            jgen.writeEndObject();
        }
    }

    protected boolean isValidAnnotationMethod(Method method) {
        return method.getParameterTypes().length <= 0;
    }

    protected void serializeAnnotationAttribute(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IllegalArgumentException, IOException, IllegalAccessException, InvocationTargetException {
        if (method.getReturnType() == Byte.TYPE || method.getReturnType() == Byte.class) {
            jgen.writeNumberField(method.getName(), (int)((Byte)method.invoke((Object)value, new Object[0])).byteValue());
        } else if (method.getReturnType() == Short.TYPE || method.getReturnType() == Short.class) {
            jgen.writeNumberField(method.getName(), (int)((Short)method.invoke((Object)value, new Object[0])).shortValue());
        } else if (method.getReturnType() == Integer.TYPE || method.getReturnType() == Integer.class) {
            jgen.writeNumberField(method.getName(), ((Integer)method.invoke((Object)value, new Object[0])).intValue());
        } else if (method.getReturnType() == Long.TYPE || method.getReturnType() == Long.class) {
            jgen.writeNumberField(method.getName(), ((Long)method.invoke((Object)value, new Object[0])).longValue());
        } else if (method.getReturnType() == Float.TYPE || method.getReturnType() == Float.class) {
            jgen.writeNumberField(method.getName(), ((Float)method.invoke((Object)value, new Object[0])).floatValue());
        } else if (method.getReturnType() == Double.TYPE || method.getReturnType() == Double.class) {
            jgen.writeNumberField(method.getName(), ((Double)method.invoke((Object)value, new Object[0])).doubleValue());
        } else if (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class) {
            jgen.writeBooleanField(method.getName(), ((Boolean)method.invoke((Object)value, new Object[0])).booleanValue());
        } else if (method.getReturnType() == Character.TYPE || method.getReturnType() == Character.class) {
            jgen.writeStringField(method.getName(), String.valueOf((Character)method.invoke((Object)value, new Object[0])));
        } else if (method.getReturnType() == String.class) {
            jgen.writeStringField(method.getName(), (String)method.invoke((Object)value, new Object[0]));
        } else if (method.getReturnType() == byte[].class) {
            this.serializeBytePrimitiveArray(method, value, jgen);
        } else if (method.getReturnType() == Byte[].class) {
            this.serializeByteArray(method, value, jgen);
        } else if (method.getReturnType() == short[].class) {
            this.serializeShortPrimitiveArray(method, value, jgen);
        } else if (method.getReturnType() == Short[].class) {
            this.serializeShortArray(method, value, jgen);
        } else if (method.getReturnType() == int[].class) {
            this.serializeIntegerPrimitiveArray(method, value, jgen);
        } else if (method.getReturnType() == Integer[].class) {
            this.serializeIntegerArray(method, value, jgen);
        } else if (method.getReturnType() == long[].class) {
            this.serializeLongPrimitiveArray(method, value, jgen);
        } else if (method.getReturnType() == Long[].class) {
            this.serializeLongArray(method, value, jgen);
        } else if (method.getReturnType() == float[].class) {
            this.serializeFloatPrimitiveArray(method, value, jgen);
        } else if (method.getReturnType() == Float[].class) {
            this.serializeFloatArray(method, value, jgen);
        } else if (method.getReturnType() == double[].class) {
            this.serializeDoublePrimitiveArray(method, value, jgen);
        } else if (method.getReturnType() == Double[].class) {
            this.serializeDoubleArray(method, value, jgen);
        } else if (method.getReturnType() == boolean[].class) {
            this.serializeBooleanPrimitiveArray(method, value, jgen);
        } else if (method.getReturnType() == Boolean[].class) {
            this.serializeBooleanArray(method, value, jgen);
        } else if (method.getReturnType() == char[].class) {
            this.serializeCharPrimitiveArray(method, value, jgen);
        } else if (method.getReturnType() == Character[].class) {
            this.serializeCharArray(method, value, jgen);
        } else if (method.getReturnType() == String[].class) {
            this.serializeStringArray(method, value, jgen);
        } else {
            throw new IllegalArgumentException("Unrecognized attribute value type " + method.getReturnType().getName() + " for annotation " + value.annotationType().getName());
        }
    }

    protected void serializeBytePrimitiveArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        byte[] bytes = (byte[])method.invoke((Object)value, new Object[0]);
        if (bytes != null) {
            for (byte aByte : bytes) {
                jgen.writeNumber((int)aByte);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeByteArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        Byte[] bytes = (Byte[])method.invoke((Object)value, new Object[0]);
        if (bytes != null) {
            Byte[] arr$ = bytes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte aByte = arr$[i$];
                jgen.writeNumber((int)aByte);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeShortPrimitiveArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        short[] shorts = (short[])method.invoke((Object)value, new Object[0]);
        if (shorts != null) {
            for (short aShort : shorts) {
                jgen.writeNumber((int)aShort);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeShortArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        Short[] shorts = (Short[])method.invoke((Object)value, new Object[0]);
        if (shorts != null) {
            Short[] arr$ = shorts;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                short aShort = arr$[i$];
                jgen.writeNumber((int)aShort);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeIntegerPrimitiveArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        int[] integers = (int[])method.invoke((Object)value, new Object[0]);
        if (integers != null) {
            for (int anInteger : integers) {
                jgen.writeNumber(anInteger);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeIntegerArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        Integer[] integers = (Integer[])method.invoke((Object)value, new Object[0]);
        if (integers != null) {
            Integer[] arr$ = integers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int anInteger = arr$[i$];
                jgen.writeNumber(anInteger);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeLongPrimitiveArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        long[] longs = (long[])method.invoke((Object)value, new Object[0]);
        if (longs != null) {
            for (long aLong : longs) {
                jgen.writeNumber(aLong);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeLongArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        Long[] longs = (Long[])method.invoke((Object)value, new Object[0]);
        if (longs != null) {
            Long[] arr$ = longs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long aLong = arr$[i$];
                jgen.writeNumber(aLong);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeFloatPrimitiveArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        float[] floats = (float[])method.invoke((Object)value, new Object[0]);
        if (floats != null) {
            for (float aFloat : floats) {
                jgen.writeNumber(aFloat);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeFloatArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        Float[] floats = (Float[])method.invoke((Object)value, new Object[0]);
        if (floats != null) {
            Float[] arr$ = floats;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                float aFloat = arr$[i$].floatValue();
                jgen.writeNumber(aFloat);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeDoublePrimitiveArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        double[] doubles = (double[])method.invoke((Object)value, new Object[0]);
        if (doubles != null) {
            for (double aDouble : doubles) {
                jgen.writeNumber(aDouble);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeDoubleArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        Double[] doubles = (Double[])method.invoke((Object)value, new Object[0]);
        if (doubles != null) {
            Double[] arr$ = doubles;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                double aDouble = arr$[i$];
                jgen.writeNumber(aDouble);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeBooleanPrimitiveArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        boolean[] booleans = (boolean[])method.invoke((Object)value, new Object[0]);
        if (booleans != null) {
            for (boolean booleanValue : booleans) {
                jgen.writeBoolean(booleanValue);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeBooleanArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        Boolean[] booleans = (Boolean[])method.invoke((Object)value, new Object[0]);
        if (booleans != null) {
            Boolean[] arr$ = booleans;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                boolean booleanValue = arr$[i$];
                jgen.writeBoolean(booleanValue);
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeCharPrimitiveArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        char[] chars = (char[])method.invoke((Object)value, new Object[0]);
        if (chars != null) {
            for (char aChar : chars) {
                jgen.writeString(String.valueOf(aChar));
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeCharArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        Character[] chars = (Character[])method.invoke((Object)value, new Object[0]);
        if (chars != null) {
            Character[] arr$ = chars;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                char aChar = arr$[i$].charValue();
                jgen.writeString(String.valueOf(aChar));
            }
        }
        jgen.writeEndArray();
    }

    protected void serializeStringArray(Method method, Annotation value, JsonGenerator jgen) throws JsonGenerationException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        jgen.writeArrayFieldStart(method.getName());
        String[] strings = (String[])method.invoke((Object)value, new Object[0]);
        if (strings != null) {
            for (String string : strings) {
                jgen.writeString(string);
            }
        }
        jgen.writeEndArray();
    }
}

