/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.rest.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.channel.HstPropertyDefinition;
import org.hippoecm.hst.core.parameters.DropDownList;
import org.hippoecm.hst.core.parameters.FieldGroup;
import org.hippoecm.hst.core.parameters.FieldGroupList;
import org.hippoecm.hst.core.parameters.ImageSetPath;
import org.hippoecm.hst.core.parameters.JcrPath;
import org.hippoecm.hst.rest.beans.ChannelInfoClassInfo;
import org.hippoecm.hst.rest.beans.FieldGroupInfo;
import org.hippoecm.hst.rest.beans.HstPropertyDefinitionInfo;

public final class InformationObjectsBuilder {
    public static ChannelInfoClassInfo buildChannelInfoClassInfo(Class<? extends ChannelInfo> channelInfoClass) {
        ChannelInfoClassInfo channelInfoClassInfo = new ChannelInfoClassInfo();
        channelInfoClassInfo.setClassName(channelInfoClass.getName());
        channelInfoClassInfo.setFieldsGroup(InformationObjectsBuilder.buildFieldGroupListInfo(channelInfoClass.getAnnotation(FieldGroupList.class)));
        return channelInfoClassInfo;
    }

    public static List<FieldGroupInfo> buildFieldGroupListInfo(FieldGroupList fieldsGroup) {
        ArrayList<FieldGroupInfo> fieldsGroupList = new ArrayList<FieldGroupInfo>();
        if (fieldsGroup != null) {
            for (FieldGroup fieldGroup : fieldsGroup.value()) {
                try {
                    fieldsGroupList.add(InformationObjectsBuilder.buildFieldGroupInfo(fieldGroup));
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
        }
        return fieldsGroupList;
    }

    public static FieldGroupInfo buildFieldGroupInfo(FieldGroup fieldGroup) {
        if (fieldGroup == null) {
            throw new IllegalArgumentException("Got a 'null' field group argument!");
        }
        FieldGroupInfo fieldGroupInfo = new FieldGroupInfo();
        fieldGroupInfo.setValue(fieldGroup.value());
        fieldGroupInfo.setTitleKey(fieldGroup.titleKey());
        return fieldGroupInfo;
    }

    public static List<HstPropertyDefinitionInfo> buildHstPropertyDefinitionInfos(List<HstPropertyDefinition> hstPropertyDefinitions) {
        ArrayList<HstPropertyDefinitionInfo> hstPropertyDefinitionInfos = new ArrayList<HstPropertyDefinitionInfo>(hstPropertyDefinitions.size());
        for (HstPropertyDefinition hstPropertyDefinition : hstPropertyDefinitions) {
            hstPropertyDefinitionInfos.add(InformationObjectsBuilder.buildHstPropertyDefinitionInfo(hstPropertyDefinition));
        }
        return hstPropertyDefinitionInfos;
    }

    public static HstPropertyDefinitionInfo buildHstPropertyDefinitionInfo(HstPropertyDefinition hstPropertyDefinition) {
        HstPropertyDefinitionInfo hstPropertyDefinitionInfo = new HstPropertyDefinitionInfo();
        hstPropertyDefinitionInfo.setIsRequired(hstPropertyDefinition.isRequired());
        hstPropertyDefinitionInfo.setDefaultValue(hstPropertyDefinition.getDefaultValue());
        hstPropertyDefinitionInfo.setName(hstPropertyDefinition.getName());
        hstPropertyDefinitionInfo.setValueType(hstPropertyDefinition.getValueType());
        hstPropertyDefinitionInfo.setAnnotations(hstPropertyDefinition.getAnnotations(Arrays.asList(ImageSetPath.class, JcrPath.class, DropDownList.class)));
        return hstPropertyDefinitionInfo;
    }

    public static Properties buildResourceBundleProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        for (String key : resourceBundle.keySet()) {
            properties.put(key, resourceBundle.getString(key));
        }
        return properties;
    }
}

