/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.site.request.DefaultContextCredentialsProvider;

public class SiteNameDecoratedContextCredentialsProvider
extends DefaultContextCredentialsProvider {
    protected Map<String, Credentials> defaultCredentialsCache = Collections.synchronizedMap(new HashMap());
    protected Map<String, Credentials> defaultCredentialsForPreviewModeCache = Collections.synchronizedMap(new HashMap());
    protected Map<String, Credentials> writableCredentialsCache = Collections.synchronizedMap(new HashMap());
    protected String siteNameSeparator = "@";

    public SiteNameDecoratedContextCredentialsProvider(Credentials defaultCredentials) {
        super(defaultCredentials);
    }

    public SiteNameDecoratedContextCredentialsProvider(Credentials defaultCredentials, Credentials defaultCredentialsForPreviewMode) {
        super(defaultCredentials, defaultCredentialsForPreviewMode);
    }

    public SiteNameDecoratedContextCredentialsProvider(Credentials defaultCredentials, Credentials defaultCredentialsForPreviewMode, Credentials writableCredentials) {
        super(defaultCredentials, defaultCredentialsForPreviewMode, writableCredentials);
    }

    public void setSiteNameSeparator(String siteNameSeparator) {
        this.siteNameSeparator = siteNameSeparator;
    }

    public String getSiteNameSeparator() {
        return this.siteNameSeparator;
    }

    @Override
    public Credentials getDefaultCredentials(HstRequestContext requestContext) {
        Credentials credentials = super.getDefaultCredentials(requestContext);
        if (credentials instanceof SimpleCredentials) {
            String siteName = requestContext.getResolvedSiteMapItem().getResolvedMount().getMount().getHstSite().getName();
            String userID = ((SimpleCredentials)credentials).getUserID();
            String userIDWithSiteName = userID + this.siteNameSeparator + siteName;
            char[] password = ((SimpleCredentials)credentials).getPassword();
            if (requestContext.isPreview()) {
                credentials = this.defaultCredentialsForPreviewModeCache.get(userIDWithSiteName);
                if (credentials == null) {
                    credentials = new SimpleCredentials(userIDWithSiteName, password);
                    this.defaultCredentialsForPreviewModeCache.put(userIDWithSiteName, credentials);
                }
            } else {
                credentials = this.defaultCredentialsCache.get(userIDWithSiteName);
                if (credentials == null) {
                    credentials = new SimpleCredentials(userIDWithSiteName, password);
                    this.defaultCredentialsCache.put(userIDWithSiteName, credentials);
                }
            }
        }
        return credentials;
    }

    @Override
    public Credentials getWritableCredentials(HstRequestContext requestContext) {
        Credentials credentials = super.getWritableCredentials(requestContext);
        if (credentials instanceof SimpleCredentials) {
            String siteName = requestContext.getResolvedSiteMapItem().getResolvedMount().getMount().getHstSite().getName();
            String userID = ((SimpleCredentials)credentials).getUserID();
            String userIDWithSiteName = userID + this.siteNameSeparator + siteName;
            char[] password = ((SimpleCredentials)credentials).getPassword();
            credentials = this.writableCredentialsCache.get(userIDWithSiteName);
            if (credentials == null) {
                credentials = new SimpleCredentials(userIDWithSiteName, password);
                this.writableCredentialsCache.put(userIDWithSiteName, credentials);
            }
        }
        return credentials;
    }
}

