/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import java.util.HashMap;
import java.util.Map;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlerConfiguration;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.request.SiteMapItemHandlerConfiguration;
import org.hippoecm.hst.core.util.PropertyParser;
import org.hippoecm.hst.site.request.ComponentConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteMapItemHandlerConfigurationImpl
implements SiteMapItemHandlerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentConfigurationImpl.class);
    public HstSiteMapItemHandlerConfiguration handlerConfig;

    public SiteMapItemHandlerConfigurationImpl(HstSiteMapItemHandlerConfiguration handlerConfig) {
        this.handlerConfig = handlerConfig;
    }

    public <T> Map<String, T> getProperties(ResolvedSiteMapItem resolvedSiteMapItem, Class<T> mappingClass) {
        HashMap properties = new HashMap();
        PropertyParser pp = new PropertyParser(resolvedSiteMapItem.getParameters());
        for (Map.Entry entry : this.handlerConfig.getProperties().entrySet()) {
            Object val = entry.getValue();
            if (val == null) {
                log.debug("value is null for '{}'. Skip property", entry.getKey());
                continue;
            }
            if (mappingClass.isAssignableFrom(val.getClass())) {
                if (val instanceof String || val instanceof String[]) {
                    Object parsedVal = pp.resolveProperty((String)entry.getKey(), val);
                    if (parsedVal == null) continue;
                    properties.put(entry.getKey(), parsedVal);
                    continue;
                }
                properties.put(entry.getKey(), val);
                continue;
            }
            log.debug("Found a property for key '{}' but the value is not assignable from '{}' because it is of type '" + val.getClass().getName() + "'. Skip key-val pair.", entry.getKey(), (Object)mappingClass.getName());
        }
        return properties;
    }

    public <T> T getProperty(String name, ResolvedSiteMapItem resolvedSiteMapItem, Class<T> mappingClass) {
        Object val = this.handlerConfig.getProperty(name);
        if (val == null) {
            log.debug("value is null for '{}'. Return null");
            return null;
        }
        PropertyParser pp = new PropertyParser(resolvedSiteMapItem.getParameters());
        if (mappingClass.isAssignableFrom(val.getClass())) {
            if (val instanceof String || val instanceof String[]) {
                Object parsedVal = pp.resolveProperty(name, val);
                return (T)parsedVal;
            }
            return (T)val;
        }
        log.debug("Found a property for key '{}' but the value is not assignable from '{}' because it is of type '" + val.getClass().getName() + "'. Skip key-val pair.", (Object)name, (Object)mappingClass.getName());
        return null;
    }

    public <T> Map<String, T> getRawProperties(Class<T> mappingClass) {
        HashMap parameters = new HashMap();
        for (Map.Entry entry : this.handlerConfig.getProperties().entrySet()) {
            Object val = entry.getValue();
            if (val == null) {
                log.debug("value is null for '{}'. Skip property", entry.getKey());
                continue;
            }
            if (!mappingClass.isAssignableFrom(val.getClass())) continue;
            parameters.put(entry.getKey(), val);
        }
        return parameters;
    }

    public <T> T getRawProperty(String name, Class<T> mappingClass) {
        Object val = this.handlerConfig.getProperty(name);
        if (val == null) {
            log.debug("value is null for '{}'. Return null");
            return null;
        }
        if (mappingClass.isAssignableFrom(val.getClass())) {
            return (T)val;
        }
        log.debug("Found a property for key '{}' but the value is not assignable from '{}' because it is of type '" + val.getClass().getName() + "'. Skip key-val pair.", (Object)name, (Object)mappingClass.getName());
        return null;
    }
}

