/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.hosting.MatchException;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.PortMount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedVirtualHost;
import org.hippoecm.hst.site.request.ResolvedMountImpl;
import org.hippoecm.hst.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvedVirtualHostImpl
implements ResolvedVirtualHost {
    private static final Logger log = LoggerFactory.getLogger(ResolvedVirtualHostImpl.class);
    private VirtualHost virtualHost;
    private PortMount portMount;
    private String hostName;

    public ResolvedVirtualHostImpl(VirtualHost virtualHost, String hostName, PortMount portMount) {
        this.virtualHost = virtualHost;
        this.hostName = hostName;
        this.portMount = portMount;
    }

    public VirtualHost getVirtualHost() {
        return this.virtualHost;
    }

    public ResolvedMount matchMount(String contextPath, String requestPath) throws MatchException {
        int position;
        if (this.portMount.getRootMount() == null) {
            log.error("Virtual Host '{}' for portnumber '{}' is not (correctly) mounted: We cannot return a ResolvedMount. Return null", (Object)this.virtualHost.getHostName(), (Object)String.valueOf(this.portMount.getPortNumber()));
            return null;
        }
        String path = PathUtils.normalizePath((String)requestPath);
        String matchingIgnoredPrefix = null;
        if (!StringUtils.isEmpty((String)this.virtualHost.getVirtualHosts().getCmsPreviewPrefix())) {
            if (path.equals(this.virtualHost.getVirtualHosts().getCmsPreviewPrefix())) {
                matchingIgnoredPrefix = this.virtualHost.getVirtualHosts().getCmsPreviewPrefix();
                path = "";
            } else if (path.startsWith(this.virtualHost.getVirtualHosts().getCmsPreviewPrefix() + "/")) {
                matchingIgnoredPrefix = this.virtualHost.getVirtualHosts().getCmsPreviewPrefix();
                path = path.substring(this.virtualHost.getVirtualHosts().getCmsPreviewPrefix().length() + 1);
            }
        }
        String[] requestPathSegments = path.split("/");
        Mount mount = this.portMount.getRootMount();
        for (position = 0; position < requestPathSegments.length && mount.getChildMount(requestPathSegments[position]) != null; ++position) {
            mount = mount.getChildMount(requestPathSegments[position]);
        }
        if (contextPath != null && mount.getContextPath() != null) {
            while (mount != null && contextPath != null && mount.getContextPath() != null && !mount.getContextPath().equals(contextPath)) {
                log.debug("Mount '{}' cannot be used because the contextPath '{}' is not valid for this Mount, because it is only for context path. Try parent Mount's if present.'" + mount.getContextPath() + "' ", (Object)mount.getName(), (Object)contextPath);
                mount = mount.getParent();
                --position;
            }
        }
        if (mount == null) {
            log.warn("Virtual Host '{}' is not (correctly) mounted for portnumber '{}' and contextpath '{}': We cannot return a ResolvedMount. Return null", new Object[]{this.virtualHost.getHostName(), String.valueOf(this.portMount.getPortNumber()), contextPath});
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (position > 0) {
            builder.insert(0, requestPathSegments[--position]).insert(0, "/");
        }
        String resolvedMountPath = builder.toString();
        ResolvedMountImpl resolvedMount = new ResolvedMountImpl(mount, this, resolvedMountPath, matchingIgnoredPrefix, this.portMount.getPortNumber());
        log.debug("Found ResolvedMount is '{}' and the mount prefix for it is :", (Object)resolvedMount.getResolvedMountPath());
        return resolvedMount;
    }

    @Deprecated
    public String getResolvedHostName() {
        return this.hostName;
    }

    @Deprecated
    public int getPortNumber() {
        return this.portMount.getPortNumber();
    }
}

