/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.util.PropertyParser;
import org.hippoecm.hst.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvedSiteMapItemImpl
implements ResolvedSiteMapItem {
    private static final Logger log = LoggerFactory.getLogger(ResolvedSiteMapItemImpl.class);
    private HstSiteMapItem hstSiteMapItem;
    private Properties resolvedParameters;
    private Properties localResolvedParameters;
    private ResolvedMount resolvedMount;
    private String relativeContentPath;
    private HstComponentConfiguration hstComponentConfiguration;
    private String pathInfo;
    private String pageTitle;
    private PropertyParser pp;
    private boolean isComponentResolved;

    public ResolvedSiteMapItemImpl(HstSiteMapItem hstSiteMapItem, Properties params, String pathInfo, ResolvedMount resolvedMount) {
        Object o;
        this.pathInfo = PathUtils.normalizePath((String)pathInfo);
        this.hstSiteMapItem = hstSiteMapItem;
        this.resolvedMount = resolvedMount;
        this.resolvedParameters = new Properties();
        this.localResolvedParameters = new Properties();
        this.resolvedParameters.putAll((Map<?, ?>)params);
        this.localResolvedParameters.putAll((Map<?, ?>)params);
        this.pp = new PropertyParser(params);
        for (Map.Entry entry : hstSiteMapItem.getParameters().entrySet()) {
            o = this.pp.resolveProperty((String)entry.getKey(), entry.getValue());
            if (o == null) continue;
            this.resolvedParameters.put(entry.getKey(), o);
        }
        for (Map.Entry mountParams : resolvedMount.getMount().getParameters().entrySet()) {
            if (this.resolvedParameters.contains(mountParams.getKey()) || (o = this.pp.resolveProperty((String)mountParams.getKey(), mountParams.getValue())) == null) continue;
            this.resolvedParameters.put(mountParams.getKey(), o);
        }
        for (Map.Entry entry : hstSiteMapItem.getLocalParameters().entrySet()) {
            o = this.pp.resolveProperty((String)entry.getKey(), entry.getValue());
            if (o == null) continue;
            this.localResolvedParameters.put(entry.getKey(), o);
        }
        this.relativeContentPath = (String)this.pp.resolveProperty("relativeContentPath", hstSiteMapItem.getRelativeContentPath());
        this.pageTitle = (String)this.pp.resolveProperty("pageTitle", hstSiteMapItem.getPageTitle());
    }

    public int getStatusCode() {
        return this.hstSiteMapItem.getStatusCode();
    }

    public int getErrorCode() {
        return this.hstSiteMapItem.getErrorCode();
    }

    public HstSiteMapItem getHstSiteMapItem() {
        return this.hstSiteMapItem;
    }

    public HstComponentConfiguration getHstComponentConfiguration() {
        if (this.isComponentResolved) {
            return this.hstComponentConfiguration;
        }
        this.resolveComponentConfiguration();
        return this.hstComponentConfiguration;
    }

    public String getParameter(String name) {
        return (String)this.resolvedParameters.get(name);
    }

    public Properties getParameters() {
        return this.resolvedParameters;
    }

    public String getLocalParameter(String name) {
        return (String)this.localResolvedParameters.get(name);
    }

    public Properties getLocalParameters() {
        return this.localResolvedParameters;
    }

    public String getRelativeContentPath() {
        return this.relativeContentPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public ResolvedMount getResolvedMount() {
        return this.resolvedMount;
    }

    public String getNamedPipeline() {
        return this.hstSiteMapItem.getNamedPipeline();
    }

    public boolean isAuthenticated() {
        return this.hstSiteMapItem.isAuthenticated();
    }

    public Set<String> getRoles() {
        return this.hstSiteMapItem.getRoles();
    }

    public Set<String> getUsers() {
        return this.hstSiteMapItem.getUsers();
    }

    private void resolveComponentConfiguration() {
        String componentConfigurationId = this.resolveMappedConponentConfigurationId();
        HstSite hstSite = this.hstSiteMapItem.getHstSiteMap().getSite();
        if (componentConfigurationId == null && this.hstSiteMapItem.getComponentConfigurationId() == null) {
            log.debug("The ResolvedSiteMapItemImpl does not have a component configuration id because the sitemap item '{}' does not have one", (Object)this.hstSiteMapItem.getId());
        } else {
            if (componentConfigurationId == null) {
                log.debug("No mapped component configuration id, getting the default componentconfiguration id");
                componentConfigurationId = this.hstSiteMapItem.getComponentConfigurationId();
            }
            if (componentConfigurationId != null) {
                String resolvedComponentConfigurationId = (String)this.pp.resolveProperty("componentConfigurationId", componentConfigurationId);
                this.hstComponentConfiguration = hstSite.getComponentsConfiguration().getComponentConfiguration(resolvedComponentConfigurationId);
                if (this.hstComponentConfiguration == null) {
                    log.warn("ResolvedSiteMapItemImpl cannot be created correctly, because the component configuration id {} cannot be found.", (Object)componentConfigurationId);
                }
            }
        }
        this.isComponentResolved = true;
    }

    private String resolveMappedConponentConfigurationId() {
        if (this.hstSiteMapItem.getComponentConfigurationIdMappings() == null || this.hstSiteMapItem.getComponentConfigurationIdMappings().isEmpty()) {
            return null;
        }
        if (this.getRelativeContentPath() == null) {
            log.debug("No relative content path for '{}' so cannot lookup mapped component configuration id", (Object)this.hstSiteMapItem.getId());
            return null;
        }
        try {
            Session session = RequestContextProvider.get().getSession();
            String absPath = this.getResolvedMount().getMount().getContentPath() + "/" + PathUtils.normalizePath((String)this.getRelativeContentPath());
            if (!session.nodeExists(absPath)) {
                log.debug("No node found at '{}'. No mapped configuration can be returned", (Object)absPath);
                return null;
            }
            Node node = session.getNode(absPath);
            if (node.isNodeType("hippo:handle")) {
                if (!node.hasNode(node.getName())) {
                    log.debug("No mapped configuration can be returned because no document below handle");
                    return null;
                }
                node = node.getNode(node.getName());
            }
            String primaryType = node.getPrimaryNodeType().getName();
            return (String)this.hstSiteMapItem.getComponentConfigurationIdMappings().get(primaryType);
        }
        catch (RepositoryException e) {
            log.error("Repository exception while looking up component mapping", (Throwable)e);
            return null;
        }
    }
}

