/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import java.util.Set;
import org.hippoecm.hst.configuration.hosting.MatchException;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.NotFoundException;
import org.hippoecm.hst.core.internal.MutableResolvedMount;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.request.ResolvedVirtualHost;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.hippoecm.hst.util.HstSiteMapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvedMountImpl
implements MutableResolvedMount {
    private static final Logger log = LoggerFactory.getLogger(ResolvedMountImpl.class);
    private Mount mount;
    private final ResolvedVirtualHost resolvedVirtualHost;
    private final String resolvedMountPath;
    private final String matchingIgnoredPrefix;
    private final int portNumber;

    public ResolvedMountImpl(Mount mount, ResolvedVirtualHost resolvedVirtualHost, String resolvedMountPath, String matchingIgnoredPrefix, int portNumber) {
        this.mount = mount;
        this.resolvedVirtualHost = resolvedVirtualHost;
        this.resolvedMountPath = resolvedMountPath;
        this.matchingIgnoredPrefix = matchingIgnoredPrefix;
        this.portNumber = portNumber;
    }

    public Mount getMount() {
        return this.mount;
    }

    public void setMount(Mount mount) {
        this.mount = mount;
    }

    @Deprecated
    public ResolvedVirtualHost getResolvedVirtualHost() {
        return this.resolvedVirtualHost;
    }

    public String getResolvedMountPath() {
        return this.resolvedMountPath;
    }

    public String getMatchingIgnoredPrefix() {
        return this.matchingIgnoredPrefix;
    }

    public String getNamedPipeline() {
        return this.mount.getNamedPipeline();
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedSiteMapItem matchSiteMapItem(String siteMapPathInfo) throws MatchException {
        if (this.getMount().getHstSite() == null) {
            throw new MatchException("No HstSite attached to Mount '" + this.getMount().getName() + "'. The path '" + siteMapPathInfo + "' thus not be matched to a sitemap item");
        }
        if (siteMapPathInfo == null) {
            throw new MatchException("SiteMapPathInfo is not allowed to be null");
        }
        Task matchingTask = null;
        try {
            HstSiteMapMatcher matcher;
            if (HDC.isStarted()) {
                matchingTask = HDC.getCurrentTask().startSubtask("Sitemap Matching");
            }
            if ("".equals(siteMapPathInfo) || "/".equals(siteMapPathInfo)) {
                log.debug("siteMapPathInfo is '' or '/'. If there is a homepage path configured, we try to map this path to the sitemap");
                siteMapPathInfo = HstSiteMapUtils.getPath((Mount)this.mount, (String)this.mount.getHomePage());
                if (siteMapPathInfo == null || "".equals(siteMapPathInfo) || "/".equals(siteMapPathInfo)) {
                    log.warn("Mount '{}' for host '{}' does not have a homepage configured and the path info is empty. Cannot map to sitemap item. Return null", (Object)this.getMount().getName(), (Object)this.mount.getVirtualHost().getHostName());
                    throw new MatchException("No homepage configured and empty path after Mount");
                }
                log.debug("Trying to map homepage '{}' to the sitemap for Mount '{}'", (Object)siteMapPathInfo, (Object)this.getMount().getName());
            }
            if ((matcher = this.getMount().getHstSiteMapMatcher()) == null) {
                throw new MatchException("The VirtualHostManager does not have a HstSiteMapMatcher configured. Cannot match request to a sitemap without this");
            }
            ResolvedSiteMapItem item = null;
            try {
                item = matcher.match(siteMapPathInfo, (ResolvedMount)this);
            }
            catch (NotFoundException e) {
                log.debug("Cannot match '{}'. Try getting the pagenotfound", (Object)siteMapPathInfo);
                String pageNotFound = HstSiteMapUtils.getPath((Mount)this.mount, (String)this.mount.getPageNotFound());
                if (pageNotFound == null) {
                    throw new MatchException("There is no pagenotfound configured for '" + this.mount.getName() + "'");
                }
                item = matcher.match(pageNotFound, (ResolvedMount)this);
            }
            ResolvedSiteMapItem resolvedSiteMapItem = item;
            return resolvedSiteMapItem;
        }
        finally {
            if (matchingTask != null) {
                matchingTask.stop();
            }
        }
    }

    public boolean isAuthenticated() {
        return this.mount.isAuthenticated();
    }

    public Set<String> getRoles() {
        return this.mount.getRoles();
    }

    public Set<String> getUsers() {
        return this.mount.getUsers();
    }

    public boolean isSubjectBasedSession() {
        return this.mount.isSubjectBasedSession();
    }

    public boolean isSessionStateful() {
        return this.mount.isSessionStateful();
    }

    public String getFormLoginPage() {
        return this.mount.getFormLoginPage();
    }
}

