/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.hippoecm.hst.configuration.channel.Blueprint;
import org.hippoecm.hst.configuration.channel.ChannelException;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.channel.HstPropertyDefinition;
import org.hippoecm.hst.configuration.hosting.MatchException;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.PortMount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.configuration.internal.ContextualizableMount;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.internal.MountDecorator;
import org.hippoecm.hst.core.internal.MutableResolvedMount;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.request.ResolvedVirtualHost;
import org.onehippo.cms7.services.hst.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountDecoratorImpl
implements MountDecorator {
    protected static final Logger log = LoggerFactory.getLogger(MountDecoratorImpl.class);

    public Mount decorateMountAsPreview(Mount mount) {
        if (mount instanceof PreviewDecoratedMount) {
            log.debug("Already preview decorated mount '{}'. Return", (Object)mount.toString());
            return mount;
        }
        if (mount.isPreview()) {
            log.debug("Mount {} is already a preview mount. Still decorate the backing virtualhosts to preview", (Object)mount.toString());
        }
        return new PreviewDecoratedMount(mount);
    }

    private ResolvedMount decoratedResolvedMount(ResolvedMount resolvedMount) {
        if (resolvedMount == null) {
            return null;
        }
        if (!(resolvedMount instanceof MutableResolvedMount)) {
            String msg = String.format("Resolved mount '%s' expected to be a MutableResolvedMount but was not.", resolvedMount.getMount().toString());
            throw new IllegalStateException(msg);
        }
        ((MutableResolvedMount)resolvedMount).setMount(this.decorateMountAsPreview(resolvedMount.getMount()));
        return resolvedMount;
    }

    private class PreviewDecoratedResolvedVirtualHost
    implements ResolvedVirtualHost {
        private final ResolvedVirtualHost delegatee;

        public PreviewDecoratedResolvedVirtualHost(ResolvedVirtualHost delegatee) {
            this.delegatee = delegatee;
        }

        public VirtualHost getVirtualHost() {
            return new PreviewDecoratedVirtualHost(this.delegatee.getVirtualHost());
        }

        @Deprecated
        public String getResolvedHostName() {
            return this.delegatee.getResolvedHostName();
        }

        @Deprecated
        public int getPortNumber() {
            return this.delegatee.getPortNumber();
        }

        public ResolvedMount matchMount(String contextPath, String requestPath) throws MatchException {
            ResolvedMount resolvedMount = this.delegatee.matchMount(contextPath, requestPath);
            return MountDecoratorImpl.this.decoratedResolvedMount(resolvedMount);
        }
    }

    class PreviewDecoratedVirtualHosts
    implements VirtualHosts {
        private VirtualHosts delegatee;

        private PreviewDecoratedVirtualHosts(VirtualHosts delegatee) {
            this.delegatee = delegatee;
        }

        @Deprecated
        public HstManager getHstManager() {
            return this.delegatee.getHstManager();
        }

        @Deprecated
        public boolean isExcluded(String pathInfo) {
            return this.isHstFilterExcludedPath(pathInfo);
        }

        public boolean isHstFilterExcludedPath(String pathInfo) {
            return this.delegatee.isHstFilterExcludedPath(pathInfo);
        }

        @Deprecated
        public ResolvedSiteMapItem matchSiteMapItem(HstContainerURL hstContainerURL) throws MatchException {
            ResolvedMount decoratedMount = this.matchMount(hstContainerURL.getHostName(), hstContainerURL.getContextPath(), hstContainerURL.getRequestPath());
            ResolvedSiteMapItem resolvedSiteMapItem = decoratedMount.matchSiteMapItem(hstContainerURL.getPathInfo());
            return resolvedSiteMapItem;
        }

        public ResolvedMount matchMount(String hostName, String contextPath, String requestPath) throws MatchException {
            ResolvedMount resolvedMount = this.delegatee.matchMount(hostName, contextPath, requestPath);
            return MountDecoratorImpl.this.decoratedResolvedMount(resolvedMount);
        }

        public ResolvedVirtualHost matchVirtualHost(String hostName) throws MatchException {
            ResolvedVirtualHost undecorated = this.delegatee.matchVirtualHost(hostName);
            return new PreviewDecoratedResolvedVirtualHost(undecorated);
        }

        public String getDefaultHostName() {
            return this.delegatee.getDefaultHostName();
        }

        public boolean isContextPathInUrl() {
            return this.delegatee.isContextPathInUrl();
        }

        public String getDefaultContextPath() {
            return this.delegatee.getDefaultContextPath();
        }

        public boolean isPortInUrl() {
            return this.delegatee.isPortInUrl();
        }

        public String getLocale() {
            return this.delegatee.getLocale();
        }

        public Mount getMountByGroupAliasAndType(String hostGroupName, String alias, String type) {
            Mount liveMount = this.delegatee.getMountByGroupAliasAndType(hostGroupName, alias, "live");
            if (liveMount == null) {
                log.debug("No preview or live mount found for alias '{}' in host group '{}'. Return null", (Object)alias, (Object)hostGroupName);
                return null;
            }
            log.debug("Found live mount '{}' for alias '{}' in host group '{}'. Return preview decorated version,", new Object[]{liveMount, alias, hostGroupName});
            return MountDecoratorImpl.this.decorateMountAsPreview(liveMount);
        }

        public List<Mount> getMountsByHostGroup(String hostGroupName) {
            List mountsByHostGroup = this.delegatee.getMountsByHostGroup(hostGroupName);
            ArrayList<Mount> previewMounts = new ArrayList<Mount>();
            for (Mount mount : mountsByHostGroup) {
                if (mount.isPreview() && RequestContextProvider.get().isCmsRequest()) {
                    log.debug("Skipping *explicit* preview mounts for cms requests since they cannot be used in channel manager.");
                    continue;
                }
                previewMounts.add(MountDecoratorImpl.this.decorateMountAsPreview(mount));
            }
            return previewMounts;
        }

        public List<String> getHostGroupNames() {
            return this.delegatee.getHostGroupNames();
        }

        public Mount getMountByIdentifier(String uuid) {
            Mount mountByIdentifier = this.delegatee.getMountByIdentifier(uuid);
            if (mountByIdentifier == null) {
                log.info("Cannot find a mount for uuid '{}'. Most likely just removed.", (Object)uuid);
                return null;
            }
            return MountDecoratorImpl.this.decorateMountAsPreview(mountByIdentifier);
        }

        public String getCmsPreviewPrefix() {
            return this.delegatee.getCmsPreviewPrefix();
        }

        public String getChannelManagerSitesName() {
            return this.delegatee.getChannelManagerSitesName();
        }

        public boolean isDiagnosticsEnabled(String ip) {
            return this.delegatee.isDiagnosticsEnabled(ip);
        }

        public int getDiagnosticsDepth() {
            return this.delegatee.getDiagnosticsDepth();
        }

        public long getDiagnosticsThresholdMillis() {
            return this.delegatee.getDiagnosticsThresholdMillis();
        }

        public long getDiagnosticsUnitThresholdMillis() {
            return this.delegatee.getDiagnosticsUnitThresholdMillis();
        }

        public String getDefaultResourceBundleId() {
            return this.delegatee.getDefaultResourceBundleId();
        }

        public String[] getDefaultResourceBundleIds() {
            return this.delegatee.getDefaultResourceBundleIds();
        }

        public boolean isChannelMngrSiteAuthenticationSkipped() {
            return this.delegatee.isChannelMngrSiteAuthenticationSkipped();
        }

        public Map<String, Channel> getChannels(String hostGroup) {
            return this.delegatee.getChannels(hostGroup);
        }

        public Map<String, Map<String, Channel>> getChannels() {
            return this.delegatee.getChannels();
        }

        public Channel getChannelByJcrPath(String hostGroup, String channelPath) {
            return this.delegatee.getChannelByJcrPath(hostGroup, channelPath);
        }

        public Channel getChannelById(String hostGroup, String id) {
            return this.delegatee.getChannelById(hostGroup, id);
        }

        public List<Blueprint> getBlueprints() {
            return this.delegatee.getBlueprints();
        }

        public Blueprint getBlueprint(String id) {
            return this.delegatee.getBlueprint(id);
        }

        public Class<? extends ChannelInfo> getChannelInfoClass(Channel channel) throws ChannelException {
            return this.delegatee.getChannelInfoClass(channel);
        }

        public Class<? extends ChannelInfo> getChannelInfoClass(String hostGroup, String id) throws ChannelException {
            return this.delegatee.getChannelInfoClass(hostGroup, id);
        }

        public <T extends ChannelInfo> T getChannelInfo(Channel channel) throws ChannelException {
            return (T)this.delegatee.getChannelInfo(channel);
        }

        public ResourceBundle getResourceBundle(Channel channel, Locale locale) {
            return this.delegatee.getResourceBundle(channel, locale);
        }

        public List<HstPropertyDefinition> getPropertyDefinitions(Channel channel) {
            return this.delegatee.getPropertyDefinitions(channel);
        }

        public List<HstPropertyDefinition> getPropertyDefinitions(String hostGroup, String channelId) {
            return this.delegatee.getPropertyDefinitions(hostGroup, channelId);
        }
    }

    class PreviewDecoratedPortMount
    implements PortMount {
        private PortMount delegatee;

        private PreviewDecoratedPortMount(PortMount delegatee) {
            this.delegatee = delegatee;
        }

        public int getPortNumber() {
            return this.delegatee.getPortNumber();
        }

        public Mount getRootMount() {
            Mount rootMount = this.delegatee.getRootMount();
            return MountDecoratorImpl.this.decorateMountAsPreview(rootMount);
        }
    }

    class PreviewDecoratedVirtualHost
    implements VirtualHost {
        private VirtualHost delegatee;

        private PreviewDecoratedVirtualHost(VirtualHost delegatee) {
            this.delegatee = delegatee;
        }

        public String getHostName() {
            return this.delegatee.getHostName();
        }

        public String getName() {
            return this.delegatee.getName();
        }

        public String getHostGroupName() {
            return this.delegatee.getHostGroupName();
        }

        public String getLocale() {
            return this.delegatee.getLocale();
        }

        public VirtualHost getChildHost(String name) {
            VirtualHost child = this.delegatee.getChildHost(name);
            if (child == null) {
                return null;
            }
            return new PreviewDecoratedVirtualHost(child);
        }

        public List<VirtualHost> getChildHosts() {
            List childHosts = this.delegatee.getChildHosts();
            if (childHosts == null) {
                return null;
            }
            ArrayList<VirtualHost> decoratedChildren = new ArrayList<VirtualHost>();
            for (VirtualHost childHost : childHosts) {
                decoratedChildren.add(new PreviewDecoratedVirtualHost(childHost));
            }
            return decoratedChildren;
        }

        public PortMount getPortMount(int portNumber) {
            PortMount portMount = this.delegatee.getPortMount(portNumber);
            if (portMount == null) {
                return null;
            }
            return new PreviewDecoratedPortMount(portMount);
        }

        public VirtualHosts getVirtualHosts() {
            return new PreviewDecoratedVirtualHosts(this.delegatee.getVirtualHosts());
        }

        public boolean isContextPathInUrl() {
            return this.delegatee.isContextPathInUrl();
        }

        @Deprecated
        public String onlyForContextPath() {
            return this.delegatee.onlyForContextPath();
        }

        public String getContextPath() {
            return this.delegatee.getContextPath();
        }

        public boolean isPortInUrl() {
            return this.delegatee.isPortInUrl();
        }

        public String getScheme() {
            return this.delegatee.getScheme();
        }

        public boolean isSchemeAgnostic() {
            return this.delegatee.isSchemeAgnostic();
        }

        public int getSchemeNotMatchingResponseCode() {
            return this.delegatee.getSchemeNotMatchingResponseCode();
        }

        public String getHomePage() {
            return this.delegatee.getHomePage();
        }

        public String getBaseURL(HttpServletRequest request) {
            return this.delegatee.getBaseURL(request);
        }

        public String getPageNotFound() {
            return this.delegatee.getPageNotFound();
        }

        public boolean isVersionInPreviewHeader() {
            return this.delegatee.isVersionInPreviewHeader();
        }

        public boolean isCacheable() {
            return this.delegatee.isCacheable();
        }

        @Deprecated
        public String getDefaultResourceBundleId() {
            return this.delegatee.getDefaultResourceBundleId();
        }

        public String[] getDefaultResourceBundleIds() {
            return this.delegatee.getDefaultResourceBundleIds();
        }

        public String getCdnHost() {
            return this.delegatee.getCdnHost();
        }

        public boolean isCustomHttpsSupported() {
            return this.delegatee.isCustomHttpsSupported();
        }
    }

    class PreviewDecoratedMount
    implements Mount {
        private Mount delegatee;
        private Map<String, Mount> childAsPreview = new HashMap<String, Mount>();

        public PreviewDecoratedMount(Mount delegatee) {
            this.delegatee = delegatee;
        }

        public HstSite getHstSite() {
            if (this.delegatee.isPreview() || !(this.delegatee instanceof ContextualizableMount)) {
                return this.delegatee.getHstSite();
            }
            return ((ContextualizableMount)this.delegatee).getPreviewHstSite();
        }

        public String getMountPoint() {
            return this.delegatee.getMountPoint();
        }

        public boolean hasNoChannelInfo() {
            return this.delegatee.hasNoChannelInfo();
        }

        @Deprecated
        public String getCanonicalContentPath() {
            return this.delegatee.getContentPath();
        }

        public String getContentPath() {
            return this.delegatee.getContentPath();
        }

        public boolean isPreview() {
            return true;
        }

        public Mount getParent() {
            if (this.delegatee.getParent() == null) {
                return null;
            }
            return MountDecoratorImpl.this.decorateMountAsPreview(this.delegatee.getParent());
        }

        public Mount getChildMount(String name) {
            Mount child = this.childAsPreview.get(name);
            if (child != null) {
                return child;
            }
            if (this.delegatee.getChildMount(name) == null) {
                return null;
            }
            child = MountDecoratorImpl.this.decorateMountAsPreview(this.delegatee.getChildMount(name));
            this.childAsPreview.put(name, child);
            return child;
        }

        public List<Mount> getChildMounts() {
            List childMounts = this.delegatee.getChildMounts();
            ArrayList<Mount> previewChilds = new ArrayList<Mount>();
            for (Mount child : childMounts) {
                previewChilds.add(this.getChildMount(child.getName()));
            }
            return Collections.unmodifiableList(previewChilds);
        }

        public String getType() {
            if (this.delegatee.isPreview()) {
                return this.delegatee.getType();
            }
            if ("live".equals(this.delegatee.getType())) {
                return "preview";
            }
            return this.delegatee.getType();
        }

        public List<String> getTypes() {
            if (this.delegatee.isPreview()) {
                return this.delegatee.getTypes();
            }
            List types = this.delegatee.getTypes();
            String decoratedType = this.getType();
            String unDecoratedType = this.delegatee.getType();
            ArrayList<String> decoratedTypes = new ArrayList<String>();
            for (String type : types) {
                if (type.equals(unDecoratedType)) {
                    decoratedTypes.add(decoratedType);
                    continue;
                }
                decoratedTypes.add(type + "-preview");
            }
            return Collections.unmodifiableList(decoratedTypes);
        }

        public <T extends ChannelInfo> T getChannelInfo() {
            if (this.delegatee instanceof ContextualizableMount) {
                return (T)((ContextualizableMount)this.delegatee).getPreviewChannelInfo();
            }
            return (T)this.delegatee.getChannelInfo();
        }

        @Deprecated
        public String getChannelPath() {
            if (this.delegatee instanceof ContextualizableMount) {
                return ((ContextualizableMount)this.delegatee).getPreviewChannelPath();
            }
            return this.delegatee.getChannelPath();
        }

        public Channel getChannel() {
            if (this.delegatee instanceof ContextualizableMount) {
                return ((ContextualizableMount)this.delegatee).getPreviewChannel();
            }
            return this.delegatee.getChannel();
        }

        public String getAlias() {
            return this.delegatee.getAlias();
        }

        public String[] getDefaultSiteMapItemHandlerIds() {
            return this.delegatee.getDefaultSiteMapItemHandlerIds();
        }

        public boolean isCacheable() {
            return false;
        }

        @Deprecated
        public String getDefaultResourceBundleId() {
            return this.delegatee.getDefaultResourceBundleId();
        }

        public String[] getDefaultResourceBundleIds() {
            return this.delegatee.getDefaultResourceBundleIds();
        }

        public String getFormLoginPage() {
            return this.delegatee.getFormLoginPage();
        }

        public String getHomePage() {
            return this.delegatee.getHomePage();
        }

        public HstSiteMapMatcher getHstSiteMapMatcher() {
            return this.delegatee.getHstSiteMapMatcher();
        }

        public String getIdentifier() {
            return this.delegatee.getIdentifier();
        }

        public String getLocale() {
            return this.delegatee.getLocale();
        }

        public String getMountPath() {
            return this.delegatee.getMountPath();
        }

        public Map<String, String> getMountProperties() {
            return this.delegatee.getMountProperties();
        }

        public String getName() {
            return this.delegatee.getName();
        }

        public String getNamedPipeline() {
            return this.delegatee.getNamedPipeline();
        }

        public String getPageNotFound() {
            return this.delegatee.getPageNotFound();
        }

        public int getPort() {
            return this.delegatee.getPort();
        }

        public String getProperty(String name) {
            return this.delegatee.getProperty(name);
        }

        public List<String> getPropertyNames() {
            return this.delegatee.getPropertyNames();
        }

        public String getParameter(String name) {
            return this.delegatee.getParameter(name);
        }

        public Map<String, String> getParameters() {
            return this.delegatee.getParameters();
        }

        public Set<String> getRoles() {
            return this.delegatee.getRoles();
        }

        public String getScheme() {
            return this.delegatee.getScheme();
        }

        public boolean isSchemeAgnostic() {
            return true;
        }

        public boolean containsMultipleSchemes() {
            return false;
        }

        public int getSchemeNotMatchingResponseCode() {
            return 200;
        }

        public Set<String> getUsers() {
            return this.delegatee.getUsers();
        }

        public VirtualHost getVirtualHost() {
            return new PreviewDecoratedVirtualHost(this.delegatee.getVirtualHost());
        }

        public boolean isAuthenticated() {
            return this.delegatee.isAuthenticated();
        }

        public boolean isContextPathInUrl() {
            return this.delegatee.isContextPathInUrl();
        }

        public boolean isMapped() {
            return this.delegatee.isMapped();
        }

        public boolean isOfType(String type) {
            return this.delegatee.isOfType(type);
        }

        public boolean isPortInUrl() {
            return this.delegatee.isPortInUrl();
        }

        public boolean isSessionStateful() {
            return this.delegatee.isSessionStateful();
        }

        @Deprecated
        public boolean isSite() {
            return this.delegatee.isSite();
        }

        public boolean isSubjectBasedSession() {
            return this.delegatee.isSubjectBasedSession();
        }

        public boolean isVersionInPreviewHeader() {
            return this.delegatee.isVersionInPreviewHeader();
        }

        @Deprecated
        public String onlyForContextPath() {
            return this.delegatee.onlyForContextPath();
        }

        public String getContextPath() {
            return this.delegatee.getContextPath();
        }

        @Deprecated
        public String getCmsLocation() {
            return this.delegatee.getCmsLocation();
        }

        public List<String> getCmsLocations() {
            return this.delegatee.getCmsLocations();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MountAsPreviewDecorator for Mount [");
            builder.append(this.delegatee.toString());
            builder.append("]");
            return builder.toString();
        }
    }
}

