/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.manager.ObjectBeanManager;
import org.hippoecm.hst.content.beans.manager.ObjectBeanManagerImpl;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.query.HstQueryManager;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.tool.ContentBeansTool;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstParameterInfoProxyFactory;
import org.hippoecm.hst.core.component.HstParameterInfoProxyFactoryImpl;
import org.hippoecm.hst.core.component.HstURLFactory;
import org.hippoecm.hst.core.container.ContainerConfiguration;
import org.hippoecm.hst.core.container.HstComponentWindowFilter;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.HstContainerURLProvider;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.linking.HstLinkCreator;
import org.hippoecm.hst.core.request.ContextCredentialsProvider;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.search.HstQueryManagerFactory;
import org.hippoecm.hst.core.sitemenu.HstSiteMenus;
import org.hippoecm.hst.core.sitemenu.HstSiteMenusManager;
import org.hippoecm.hst.site.request.CachingObjectConverter;
import org.hippoecm.hst.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstRequestContextImpl
implements HstMutableRequestContext {
    private static final Logger log = LoggerFactory.getLogger(HstRequestContextImpl.class);
    private static final HstParameterInfoProxyFactory HST_PARAMETER_INFO_PROXY_FACTORY = new HstParameterInfoProxyFactoryImpl();
    protected ServletContext servletContext;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected Repository repository;
    protected ContextCredentialsProvider contextCredentialsProvider;
    protected Session session;
    protected ResolvedMount resolvedMount;
    protected ResolvedSiteMapItem resolvedSiteMapItem;
    protected HstURLFactory urlFactory;
    protected HstContainerURL baseURL;
    protected HstLinkCreator linkCreator;
    protected HstParameterInfoProxyFactory parameterInfoProxyFactory;
    protected HstSiteMapMatcher siteMapMatcher;
    protected Optional<HstSiteMenus> siteMenus;
    protected HstQueryManagerFactory hstQueryManagerFactory;
    protected ContentBeansTool contentBeansTool;
    protected HstSiteMenusManager siteMenusManager;
    protected boolean cachingObjectConverterEnabled;
    protected Map<String, Object> attributes;
    protected ContainerConfiguration containerConfiguration;
    protected Subject subject;
    protected Locale preferredLocale;
    protected List<Locale> locales;
    protected String pathSuffix;
    protected Set<String> componentFilterTags;
    private List<HstComponentWindowFilter> filters;
    protected boolean fullyQualifiedURLs;
    protected String renderHost;
    protected boolean cmsRequest;
    private Map<Session, ObjectBeanManager> objectBeanManagers;
    private Map<Session, HstQueryManager> hstQueryManagers;
    private Map<String, Object> unmodifiableAttributes;
    private boolean disposed;
    private boolean matchingFinished;

    public HstRequestContextImpl(Repository repository) {
        this(repository, null);
    }

    public HstRequestContextImpl(Repository repository, ContextCredentialsProvider contextCredentialsProvider) {
        this.repository = repository;
        this.contextCredentialsProvider = contextCredentialsProvider;
    }

    public boolean isPreview() {
        this.checkStateValidity();
        return this.resolvedMount.getMount().isPreview();
    }

    public ServletContext getServletContext() {
        this.checkStateValidity();
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public HttpServletRequest getServletRequest() {
        this.checkStateValidity();
        return this.servletRequest;
    }

    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        this.checkStateValidity();
        return this.servletResponse;
    }

    public void setServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public Session getSession() throws RepositoryException {
        return this.getSession(true);
    }

    public Session getSession(boolean create) throws RepositoryException {
        this.checkStateValidity();
        if (this.session == null) {
            if (create) {
                ContextCredentialsProvider credsProvider = this.getContextCredentialsProvider();
                if (credsProvider != null) {
                    SimpleCredentials defaultCredentials = (SimpleCredentials)credsProvider.getDefaultCredentials((HstRequestContext)this);
                    try {
                        this.session = this.repository.login((Credentials)defaultCredentials);
                    }
                    catch (LoginException e) {
                        log.warn("Login Exception for session for userID {}. Cannot create session.", (Object)defaultCredentials.getUserID());
                        throw e;
                    }
                } else {
                    try {
                        this.session = this.repository.login();
                    }
                    catch (LoginException e) {
                        log.warn("Login Exception for anonymous login.");
                        throw e;
                    }
                }
            }
        } else if (!this.session.isLive()) {
            throw new HstComponentException("Invalid session.");
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.checkStateValidity();
        this.session = session;
    }

    public void setResolvedMount(ResolvedMount resolvedMount) {
        this.checkStateValidity();
        this.resolvedMount = resolvedMount;
    }

    public ResolvedMount getResolvedMount() {
        this.checkStateValidity();
        return this.resolvedMount;
    }

    public void setResolvedSiteMapItem(ResolvedSiteMapItem resolvedSiteMapItem) {
        this.checkStateValidity();
        this.resolvedSiteMapItem = resolvedSiteMapItem;
    }

    public ResolvedSiteMapItem getResolvedSiteMapItem() {
        this.checkStateValidity();
        return this.resolvedSiteMapItem;
    }

    public void setBaseURL(HstContainerURL baseURL) {
        this.checkStateValidity();
        this.baseURL = baseURL;
    }

    public HstContainerURL getBaseURL() {
        this.checkStateValidity();
        return this.baseURL;
    }

    public void setURLFactory(HstURLFactory urlFactory) {
        this.checkStateValidity();
        this.urlFactory = urlFactory;
    }

    public HstURLFactory getURLFactory() {
        this.checkStateValidity();
        return this.urlFactory;
    }

    public HstContainerURLProvider getContainerURLProvider() {
        this.checkStateValidity();
        return this.urlFactory != null ? this.urlFactory.getContainerURLProvider() : null;
    }

    public void setSiteMapMatcher(HstSiteMapMatcher siteMapMatcher) {
        this.checkStateValidity();
        this.siteMapMatcher = siteMapMatcher;
    }

    public HstSiteMapMatcher getSiteMapMatcher() {
        this.checkStateValidity();
        return this.siteMapMatcher;
    }

    public void setLinkCreator(HstLinkCreator linkCreator) {
        this.checkStateValidity();
        this.linkCreator = linkCreator;
    }

    public HstLinkCreator getHstLinkCreator() {
        this.checkStateValidity();
        return this.linkCreator;
    }

    public void setParameterInfoProxyFactory(HstParameterInfoProxyFactory parameterInfoProxyFactory) {
        this.checkStateValidity();
        this.parameterInfoProxyFactory = parameterInfoProxyFactory;
    }

    public HstParameterInfoProxyFactory getParameterInfoProxyFactory() {
        this.checkStateValidity();
        if (this.parameterInfoProxyFactory == null) {
            return HST_PARAMETER_INFO_PROXY_FACTORY;
        }
        return this.parameterInfoProxyFactory;
    }

    public void setHstSiteMenusManager(HstSiteMenusManager siteMenusManager) {
        this.checkStateValidity();
        this.siteMenusManager = siteMenusManager;
    }

    public void setHstSiteMenus(HstSiteMenus siteMenus) {
        this.checkStateValidity();
        this.siteMenus = Optional.ofNullable(siteMenus);
    }

    public HstSiteMenus getHstSiteMenus() {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getHstSiteMenus");
        if (this.resolvedSiteMapItem == null) {
            throw new IllegalStateException("HstRequestContext#getHstSiteMenus() is not allowed to be invoked without there being a ResolvedSiteMapItem matched and set on this HstRequestContext.");
        }
        if (this.siteMenus == null) {
            this.siteMenus = Optional.ofNullable(this.siteMenusManager.getSiteMenus((HstRequestContext)this));
        }
        return this.siteMenus.orElse(null);
    }

    public HstQueryManagerFactory getHstQueryManagerFactory() {
        this.checkStateValidity();
        return this.hstQueryManagerFactory;
    }

    public void setHstQueryManagerFactory(HstQueryManagerFactory hstQueryManagerFactory) {
        this.checkStateValidity();
        this.hstQueryManagerFactory = hstQueryManagerFactory;
    }

    public Object getAttribute(String name) {
        this.checkStateValidity();
        if (name == null) {
            throw new IllegalArgumentException("attribute name cannot be null.");
        }
        Object value = null;
        if (this.attributes != null) {
            value = this.attributes.get(name);
        }
        return value;
    }

    public Enumeration<String> getAttributeNames() {
        this.checkStateValidity();
        if (this.attributes != null) {
            return Collections.enumeration(this.attributes.keySet());
        }
        List emptyAttrNames = Collections.emptyList();
        return Collections.enumeration(emptyAttrNames);
    }

    public void removeAttribute(String name) {
        this.checkStateValidity();
        if (name == null) {
            throw new IllegalArgumentException("attribute name cannot be null.");
        }
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object object) {
        this.checkStateValidity();
        if (name == null) {
            throw new IllegalArgumentException("attribute name cannot be null.");
        }
        if (object == null) {
            this.removeAttribute(name);
        }
        if (this.attributes == null) {
            HstRequestContextImpl hstRequestContextImpl = this;
            synchronized (hstRequestContextImpl) {
                if (this.attributes == null) {
                    this.attributes = new HashMap<String, Object>();
                }
            }
        }
        this.attributes.put(name, object);
    }

    public Map<String, Object> getAttributes() {
        this.checkStateValidity();
        if (this.unmodifiableAttributes == null && this.attributes != null) {
            this.unmodifiableAttributes = Collections.unmodifiableMap(this.attributes);
        }
        if (this.unmodifiableAttributes == null) {
            return Collections.emptyMap();
        }
        return this.unmodifiableAttributes;
    }

    public ContainerConfiguration getContainerConfiguration() {
        this.checkStateValidity();
        return this.containerConfiguration;
    }

    public void setContainerConfiguration(ContainerConfiguration containerConfiguration) {
        this.checkStateValidity();
        this.containerConfiguration = containerConfiguration;
    }

    public VirtualHost getVirtualHost() {
        this.checkStateValidity();
        return this.resolvedMount.getMount().getVirtualHost();
    }

    public ContextCredentialsProvider getContextCredentialsProvider() {
        this.checkStateValidity();
        return this.contextCredentialsProvider;
    }

    public void setSubject(Subject subject) {
        this.checkStateValidity();
        this.subject = subject;
    }

    public Subject getSubject() {
        this.checkStateValidity();
        return this.subject;
    }

    public void setPreferredLocale(Locale preferredLocale) {
        this.checkStateValidity();
        this.preferredLocale = preferredLocale;
    }

    public Locale getPreferredLocale() {
        this.checkStateValidity();
        return this.preferredLocale;
    }

    public void setLocales(List<Locale> locales) {
        this.checkStateValidity();
        this.locales = locales;
    }

    public Enumeration<Locale> getLocales() {
        this.checkStateValidity();
        if (this.locales != null) {
            return Collections.enumeration(this.locales);
        }
        return null;
    }

    public void setPathSuffix(String pathSuffix) {
        this.checkStateValidity();
        this.pathSuffix = pathSuffix;
    }

    public String getPathSuffix() {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getPathSuffix");
        return this.pathSuffix;
    }

    public void setComponentFilterTags(Set<String> componentFilterTags) {
        this.checkStateValidity();
        this.componentFilterTags = componentFilterTags;
    }

    public Set<String> getComponentFilterTags() {
        this.checkStateValidity();
        if (this.componentFilterTags == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.componentFilterTags);
    }

    public Mount getMount(String alias) {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getMount");
        if (alias == null) {
            throw new IllegalArgumentException("Alias is not allowed to be null");
        }
        Mount currentMount = this.getResolvedMount().getMount();
        String mappedAlias = (String)currentMount.getMountProperties().get(alias.toLowerCase());
        if (mappedAlias != null) {
            log.debug("Did find mappedAlias '{}' for alias '{}'. Try to find a mount for this mappedAlias.", (Object)mappedAlias, (Object)alias);
            Mount mount = this.lookupMount(mappedAlias.toLowerCase());
            if (mount != null) {
                return mount;
            }
            log.debug("did not find a Mount for mappedAlias '{}'. Try fallback to find a Mount having alias '{}'", (Object)mappedAlias, (Object)alias);
        }
        return this.lookupMount(alias.toLowerCase());
    }

    public Mount getMount(String alias, String type) {
        Mount mount;
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getMount");
        if (alias == null || type == null) {
            throw new IllegalArgumentException("Alias and type are not allowed to be null");
        }
        String mappedAlias = (String)this.getResolvedMount().getMount().getMountProperties().get(alias.toLowerCase());
        if (mappedAlias != null) {
            mount = this.getVirtualHost().getVirtualHosts().getMountByGroupAliasAndType(this.getVirtualHost().getHostGroupName(), mappedAlias, type);
            if (mount != null) {
                return mount;
            }
            log.debug("We did not find a mapped mount for mappedAlias '{}'. Try to find a mount for alias '{}' directly", (Object)mappedAlias, (Object)alias);
        } else {
            log.debug("Did not find a mappedAlias for alias '{}'. Try alias directly", (Object)alias);
        }
        mount = this.getVirtualHost().getVirtualHosts().getMountByGroupAliasAndType(this.getVirtualHost().getHostGroupName(), alias.toLowerCase(), type);
        if (mount == null) {
            log.debug("We did not find a direct mount for alias '{}'. Return null.", (Object)alias);
        }
        return mount;
    }

    private Mount lookupMount(String alias) {
        Mount currentMount = this.getResolvedMount().getMount();
        String hostGroupName = currentMount.getVirtualHost().getHostGroupName();
        VirtualHosts hosts = currentMount.getVirtualHost().getVirtualHosts();
        ArrayList<Mount> possibleMounts = new ArrayList<Mount>();
        for (String type : currentMount.getTypes()) {
            Mount possibleMount = hosts.getMountByGroupAliasAndType(hostGroupName, alias, type);
            if (possibleMount == null) continue;
            possibleMounts.add(possibleMount);
        }
        if (possibleMounts.size() == 0) {
            log.debug("Did not find a mount for alias '{}'. Return null", (Object)alias);
            return null;
        }
        if (possibleMounts.size() == 1) {
            return (Mount)possibleMounts.get(0);
        }
        for (Mount possibleMount : possibleMounts) {
            if (!possibleMount.getType().equals(currentMount.getType())) continue;
            return possibleMount;
        }
        ArrayList<Mount> narrowedPossibleMounts = new ArrayList<Mount>();
        if (possibleMounts.size() > 1) {
            int mostCommon = 0;
            for (Mount s : possibleMounts) {
                int inCommon = this.countCommon(s.getTypes(), currentMount.getTypes());
                if (inCommon > mostCommon) {
                    mostCommon = inCommon;
                    narrowedPossibleMounts.clear();
                    narrowedPossibleMounts.add(s);
                    continue;
                }
                if (inCommon != mostCommon) continue;
                narrowedPossibleMounts.add(s);
            }
        }
        if (narrowedPossibleMounts.size() > 0) {
            return (Mount)narrowedPossibleMounts.get(0);
        }
        return (Mount)possibleMounts.get(0);
    }

    private int countCommon(List<String> types, List<String> types2) {
        int counter = 0;
        for (String type : types) {
            if (!types2.contains(type)) continue;
            ++counter;
        }
        return counter;
    }

    public void setFullyQualifiedURLs(boolean fullyQualifiedURLs) {
        this.checkStateValidity();
        this.fullyQualifiedURLs = fullyQualifiedURLs;
    }

    public boolean isFullyQualifiedURLs() {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("isFullyQualifiedURLs");
        return this.fullyQualifiedURLs;
    }

    public void setRenderHost(String renderHost) {
        this.checkStateValidity();
        this.renderHost = renderHost;
    }

    public String getRenderHost() {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getRenderHost");
        return this.renderHost;
    }

    public List<HstComponentWindowFilter> getComponentWindowFilters() {
        this.checkStateValidity();
        if (this.filters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.filters);
    }

    public void addComponentWindowFilter(HstComponentWindowFilter filter) {
        log.warn("HstRequestContextImpl.addComponentWindowFilter is deprecated. Use spring bean 'org.hippoecm.hst.core.container.HstComponentWindowFilter.list' to add HstComponentWindowFilter instances");
        this.checkStateValidity();
        if (this.filters == null) {
            this.filters = new ArrayList<HstComponentWindowFilter>();
        }
        this.filters.add(filter);
    }

    public void setComponentWindowFilters(List<HstComponentWindowFilter> filters) {
        this.filters = filters;
    }

    public boolean isCmsRequest() {
        this.checkStateValidity();
        return this.cmsRequest;
    }

    public void setCmsRequest(boolean cmsRequest) {
        this.checkStateValidity();
        this.cmsRequest = cmsRequest;
    }

    public ContentBeansTool getContentBeansTool() {
        this.checkStateValidity();
        return this.contentBeansTool;
    }

    public void setContentBeansTool(ContentBeansTool contentBeansTool) {
        this.checkStateValidity();
        this.contentBeansTool = contentBeansTool;
    }

    public void setCachingObjectConverter(boolean enabled) {
        this.checkStateValidity();
        this.cachingObjectConverterEnabled = enabled;
    }

    public HippoBean getContentBean() {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getContentBean");
        if (this.getResolvedSiteMapItem() != null) {
            return this.getBeanForResolvedSiteMapItem(this.getResolvedSiteMapItem());
        }
        if (!this.getResolvedMount().getMount().isMapped()) {
            String contentPathInfo = PathUtils.normalizePath((String)this.getBaseURL().getPathInfo());
            return this.getHippoBean(this.getSiteContentBasePath(), contentPathInfo);
        }
        log.info("Did not find a content bean for '{}'", (Object)this.getServletRequest());
        return null;
    }

    public <T extends HippoBean> T getContentBean(Class<T> beanMappingClass) {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getContentBean");
        HippoBean bean = this.getContentBean();
        if (bean == null) {
            return null;
        }
        if (!beanMappingClass.isAssignableFrom(bean.getClass())) {
            log.debug("Required bean of type '{}' but found of type '{}'. Return null.", (Object)beanMappingClass.getName(), (Object)bean.getClass().getName());
            return null;
        }
        return (T)bean;
    }

    public String getSiteContentBasePath() {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getSiteContentBasePath");
        return PathUtils.normalizePath((String)this.getResolvedMount().getMount().getContentPath());
    }

    public HippoBean getSiteContentBaseBean() {
        this.checkStateValidity();
        this.checkMatchingPhaseFinished("getSiteContentBaseBean");
        String base = this.getSiteContentBasePath();
        try {
            return (HippoBean)this.getObjectBeanManager().getObject("/" + base);
        }
        catch (ObjectBeanManagerException e) {
            log.error("ObjectBeanManagerException. Return null : {}", (Throwable)e);
            return null;
        }
    }

    private HippoBean getBeanForResolvedSiteMapItem(ResolvedSiteMapItem resolvedSiteMapItem) {
        String base = this.getSiteContentBasePath();
        String relPath = PathUtils.normalizePath((String)resolvedSiteMapItem.getRelativeContentPath());
        if (relPath == null) {
            log.debug("Cannot return a content bean for relative path null for resolvedSitemapItem belonging to '{}'. Return null", (Object)resolvedSiteMapItem.getHstSiteMapItem().getId());
            return null;
        }
        return this.getHippoBean(base, relPath);
    }

    private HippoBean getHippoBean(String base, String relPath) {
        try {
            if (StringUtils.isEmpty((String)relPath)) {
                return (HippoBean)this.getObjectBeanManager().getObject("/" + base);
            }
            return (HippoBean)this.getObjectBeanManager().getObject("/" + base + "/" + relPath);
        }
        catch (ObjectBeanManagerException e) {
            log.error("ObjectBeanManagerException. Return null : {}", (Throwable)e);
            return null;
        }
    }

    public ObjectBeanManager getObjectBeanManager() {
        this.checkStateValidity();
        try {
            return this.getObjectBeanManager(this.getSession());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Cannot get ObjectBeanManager. Cause : '" + e.toString() + "'", e);
        }
    }

    public ObjectBeanManager getObjectBeanManager(Session session) {
        ObjectBeanManager objectBeanManager;
        this.checkStateValidity();
        if (this.objectBeanManagers == null) {
            this.objectBeanManagers = new IdentityHashMap<Session, ObjectBeanManager>();
        }
        if ((objectBeanManager = this.objectBeanManagers.get(session)) == null) {
            objectBeanManager = this.createObjectBeanManager(session);
            this.objectBeanManagers.put(session, objectBeanManager);
        }
        return objectBeanManager;
    }

    public HstQueryManager getQueryManager() throws IllegalStateException {
        this.checkStateValidity();
        try {
            return this.getQueryManager(this.getSession());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Cannot get HstQueryManager. Cause : '" + e.toString() + "'", e);
        }
    }

    public HstQueryManager getQueryManager(Session session) throws IllegalStateException {
        HstQueryManager hstQueryManager;
        this.checkStateValidity();
        if (this.hstQueryManagers == null) {
            this.hstQueryManagers = new IdentityHashMap<Session, HstQueryManager>();
        }
        if ((hstQueryManager = this.hstQueryManagers.get(session)) == null) {
            hstQueryManager = this.createQueryManager(session);
            this.hstQueryManagers.put(session, hstQueryManager);
        }
        return hstQueryManager;
    }

    public void clearObjectAndQueryManagers() {
        this.checkStateValidity();
        if (this.objectBeanManagers != null) {
            this.objectBeanManagers.clear();
        }
        if (this.hstQueryManagers != null) {
            this.hstQueryManagers.clear();
        }
    }

    public void dispose() {
        this.servletContext = null;
        this.servletRequest = null;
        this.servletResponse = null;
        this.repository = null;
        this.contextCredentialsProvider = null;
        this.session = null;
        this.resolvedMount = null;
        this.resolvedSiteMapItem = null;
        this.urlFactory = null;
        this.baseURL = null;
        this.linkCreator = null;
        this.parameterInfoProxyFactory = null;
        this.siteMapMatcher = null;
        this.siteMenus = null;
        this.hstQueryManagerFactory = null;
        this.contentBeansTool = null;
        this.attributes = null;
        this.containerConfiguration = null;
        this.subject = null;
        this.preferredLocale = null;
        this.locales = null;
        this.pathSuffix = null;
        this.componentFilterTags = null;
        this.filters = null;
        this.renderHost = null;
        this.objectBeanManagers = null;
        this.hstQueryManagers = null;
        this.unmodifiableAttributes = null;
        this.disposed = true;
    }

    public void matchingFinished() {
        this.matchingFinished = true;
    }

    private ObjectBeanManager createObjectBeanManager(Session session) {
        return new ObjectBeanManagerImpl(session, this.getObjectConverter());
    }

    private HstQueryManager createQueryManager(Session session) throws IllegalStateException {
        return this.hstQueryManagerFactory.createQueryManager(session, this.getObjectConverter());
    }

    public ObjectConverter getObjectConverter() {
        ObjectConverter converter = this.getContentBeansTool().getObjectConverter();
        if (this.cachingObjectConverterEnabled) {
            return new CachingObjectConverter(converter);
        }
        return converter;
    }

    private void checkStateValidity() {
        if (this.disposed) {
            throw new IllegalStateException("Invocation on an invalid HstRequestContext instance. \nAn HstRequestContext instance MUST not be used after a request processing cycle.\nCheck if your component implementation is thread-safe!!!");
        }
    }

    private void checkMatchingPhaseFinished(String methodName) {
        if (!this.matchingFinished) {
            throw new IllegalStateException(String.format("Invocation of method '%s' is only allowed after all matching to host, mount and optionally sitemap has finished, but matching is not yes finished. Problematic request is '%s'", methodName, this.getServletRequest()));
        }
    }
}

