/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.core.request.ComponentConfiguration;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.util.PropertyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentConfigurationImpl
implements ComponentConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentConfigurationImpl.class);
    private final HstComponentConfiguration componentConfiguration;
    private final List<String> parameterNames;

    public ComponentConfigurationImpl(HstComponentConfiguration compConfig) {
        this.componentConfiguration = compConfig;
        this.parameterNames = this.componentConfiguration.getParameters() == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(this.componentConfiguration.getParameters().keySet()));
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public Map<String, String> getParameters(ResolvedSiteMapItem hstResolvedSiteMapItem) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        PropertyParser pp = new PropertyParser(hstResolvedSiteMapItem.getParameters());
        for (Map.Entry entry : this.componentConfiguration.getParameters().entrySet()) {
            String parsedParamValue = (String)pp.resolveProperty((String)entry.getKey(), entry.getValue());
            parameters.put((String)entry.getKey(), parsedParamValue);
        }
        return parameters;
    }

    public String getParameter(String name, ResolvedSiteMapItem hstResolvedSiteMapItem) {
        String paramValue = this.componentConfiguration.getParameter(name);
        PropertyParser pp = new PropertyParser(hstResolvedSiteMapItem.getParameters());
        String parsedParamValue = (String)pp.resolveProperty(name, paramValue);
        log.debug("Return value '{}' for property '{}'", (Object)parsedParamValue, (Object)name);
        return parsedParamValue;
    }

    public Map<String, String> getLocalParameters(ResolvedSiteMapItem hstResolvedSiteMapItem) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        PropertyParser pp = new PropertyParser(hstResolvedSiteMapItem.getParameters());
        for (Map.Entry entry : this.componentConfiguration.getLocalParameters().entrySet()) {
            String parsedParamValue = (String)pp.resolveProperty((String)entry.getKey(), entry.getValue());
            parameters.put((String)entry.getKey(), parsedParamValue);
        }
        return parameters;
    }

    public String getLocalParameter(String name, ResolvedSiteMapItem hstResolvedSiteMapItem) {
        String paramValue = this.componentConfiguration.getLocalParameter(name);
        PropertyParser pp = new PropertyParser(hstResolvedSiteMapItem.getParameters());
        String parsedParamValue = (String)pp.resolveProperty(name, paramValue);
        log.debug("Return value '{}' for property '{}'", (Object)parsedParamValue, (Object)name);
        return parsedParamValue;
    }

    public Map<String, String> getRawParameters() {
        return this.componentConfiguration.getParameters();
    }

    public Map<String, String> getRawLocalParameters() {
        return this.componentConfiguration.getLocalParameters();
    }

    public String getRenderPath() {
        return this.componentConfiguration.getRenderPath();
    }

    public String getServeResourcePath() {
        return this.componentConfiguration.getServeResourcePath();
    }

    public String getCanonicalPath() {
        return this.componentConfiguration.getCanonicalStoredLocation();
    }

    public String getCanonicalIdentifier() {
        return this.componentConfiguration.getCanonicalIdentifier();
    }

    public String getXType() {
        return this.componentConfiguration.getXType();
    }

    public HstComponentConfiguration.Type getComponentType() {
        return this.componentConfiguration.getComponentType();
    }
}

