/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import com.google.common.base.Optional;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.manager.ObjectConverterAware;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.site.HstServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingObjectConverter
implements ObjectConverter {
    private static final Logger log = LoggerFactory.getLogger(CachingObjectConverter.class);
    private static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private final ObjectConverter delegatee;
    private final ObjectCache objectCache;

    protected CachingObjectConverter(ObjectConverter delegatee) {
        this(delegatee, HstServices.isAvailable() ? HstServices.getComponentManager().getContainerConfiguration().getInt("caching.object.converter.maxsize", 100) : 100);
    }

    protected CachingObjectConverter(ObjectConverter delegatee, int maxCacheSize) {
        this.objectCache = new ObjectCache(maxCacheSize);
        this.delegatee = delegatee;
    }

    public String getPrimaryObjectType(Node node) throws ObjectBeanManagerException {
        return this.delegatee.getPrimaryObjectType(node);
    }

    public Object getObject(Session session, String path) throws ObjectBeanManagerException {
        if (StringUtils.isEmpty((String)path) || !path.startsWith("/")) {
            log.warn("Illegal argument for '{}' : not an absolute path", (Object)path);
            return null;
        }
        CacheKey key = new CacheKey(session, path);
        Optional<Object> cached = this.objectCache.get(key);
        if (cached != null) {
            return cached.orNull();
        }
        Object o = this.delegatee.getObject(session, path);
        this.setObjectConverter(o);
        this.objectCache.put(key, o);
        return o;
    }

    public Object getObject(Node node) throws ObjectBeanManagerException {
        CacheKey key = new CacheKey(node);
        Optional<Object> cached = this.objectCache.get(key);
        if (cached != null) {
            return cached.orNull();
        }
        Object o = this.delegatee.getObject(node);
        this.setObjectConverter(o);
        this.objectCache.put(key, o);
        return o;
    }

    public Object getObject(Node node, String relPath) throws ObjectBeanManagerException {
        if (StringUtils.isEmpty((String)relPath) || relPath.startsWith("/")) {
            log.info("'{}' is not a valid relative path. Return null.", (Object)relPath);
            return null;
        }
        if (node == null) {
            log.warn("Node is null. Cannot get document with relative path '{}'", (Object)relPath);
            return null;
        }
        CacheKey key = new CacheKey(node, relPath);
        Optional<Object> cached = this.objectCache.get(key);
        if (cached != null) {
            return cached.orNull();
        }
        Object o = this.delegatee.getObject(node, relPath);
        this.setObjectConverter(o);
        this.objectCache.put(key, o);
        return o;
    }

    public Object getObject(String uuid, Session session) throws ObjectBeanManagerException {
        CacheKey key = new CacheKey(session, uuid);
        Optional<Object> cached = this.objectCache.get(key);
        if (cached != null) {
            return cached.orNull();
        }
        Object o = this.delegatee.getObject(uuid, session);
        this.setObjectConverter(o);
        this.objectCache.put(key, o);
        return o;
    }

    public Object getObject(String uuid, Node node) throws ObjectBeanManagerException {
        CacheKey key = new CacheKey(node, uuid);
        Optional<Object> cached = this.objectCache.get(key);
        if (cached != null) {
            return cached.orNull();
        }
        Object o = this.delegatee.getObject(uuid, node);
        this.setObjectConverter(o);
        this.objectCache.put(key, o);
        return o;
    }

    public Class<? extends HippoBean> getAnnotatedClassFor(String jcrPrimaryNodeType) {
        return this.delegatee.getAnnotatedClassFor(jcrPrimaryNodeType);
    }

    public String getPrimaryNodeTypeNameFor(Class<? extends HippoBean> hippoBean) {
        return this.delegatee.getPrimaryNodeTypeNameFor(hippoBean);
    }

    private void setObjectConverter(Object o) {
        if (o instanceof ObjectConverterAware) {
            ((ObjectConverterAware)o).setObjectConverter((ObjectConverter)this);
        }
    }

    private class CacheKey {
        final String sessionUserId;
        final String pathOrUuid;

        private CacheKey(Session session, String pathOrUuid) {
            this.sessionUserId = session.getUserID();
            this.pathOrUuid = pathOrUuid;
        }

        private CacheKey(Node node) throws ObjectBeanManagerException {
            try {
                this.sessionUserId = node.getSession().getUserID();
                this.pathOrUuid = node.getPath();
            }
            catch (RepositoryException e) {
                throw new ObjectBeanManagerException((Throwable)e);
            }
        }

        private CacheKey(Node node, String relPath) throws ObjectBeanManagerException {
            try {
                this.sessionUserId = node.getSession().getUserID();
                this.pathOrUuid = node.getPath() + "/" + relPath;
            }
            catch (RepositoryException e) {
                throw new ObjectBeanManagerException((Throwable)e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.pathOrUuid.equals(cacheKey.pathOrUuid) && this.sessionUserId.equals(cacheKey.sessionUserId);
        }

        public int hashCode() {
            int result = this.sessionUserId.hashCode();
            result = 31 * result + this.pathOrUuid.hashCode();
            return result;
        }
    }

    private class ObjectCache {
        private final Map<CacheKey, Optional<Object>> cache;

        ObjectCache(int maxSize) {
            this.cache = new LRUMap(maxSize);
        }

        public Optional<Object> get(CacheKey key) {
            return this.cache.get(key);
        }

        public void put(CacheKey key, Object object) {
            if (object == null) {
                this.cache.put(key, (Optional<Object>)Optional.absent());
            } else {
                this.cache.put(key, (Optional<Object>)Optional.of((Object)object));
            }
        }
    }
}

