/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.NotFoundException;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.sitemap.HstSiteMap;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItemService;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.linking.HstLinkImpl;
import org.hippoecm.hst.core.linking.HstLinkProcessor;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.site.request.ResolvedSiteMapItemImpl;
import org.hippoecm.hst.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicHstSiteMapMatcher
implements HstSiteMapMatcher {
    private static final Logger log = LoggerFactory.getLogger(BasicHstSiteMapMatcher.class);
    private HstLinkProcessor linkProcessor;

    public void setLinkProcessor(HstLinkProcessor linkProcessor) {
        this.linkProcessor = linkProcessor;
    }

    public ResolvedSiteMapItem match(String pathInfo, ResolvedMount resolvedMount) throws NotFoundException {
        HstSiteMapItem index;
        String parameter;
        HstSiteMapItemService service;
        Mount mount = resolvedMount.getMount();
        if (!mount.isMapped()) {
            throw new NotFoundException(String.format("Cannot match '%s' to a sitemap item for mount '%s' because the mount is not mapped and thus does not have an associated sitemap.", pathInfo, mount));
        }
        HstSite hstSite = mount.getHstSite();
        Properties params = new Properties();
        pathInfo = PathUtils.normalizePath((String)pathInfo);
        if (this.linkProcessor != null) {
            HstLinkImpl link = new HstLinkImpl(pathInfo, resolvedMount.getMount(), false, false);
            link = this.linkProcessor.preProcess((HstLink)link);
            pathInfo = link.getPath();
        }
        String[] elements = pathInfo.split("/");
        HstSiteMap siteMap = hstSite.getSiteMap();
        HstSiteMapItem hstSiteMapItem = siteMap.getSiteMapItem(elements[0]);
        HstSiteMapItem matchedSiteMapItem = null;
        if (hstSiteMapItem != null && !hstSiteMapItem.isMarkedDeleted()) {
            matchedSiteMapItem = this.resolveMatchingSiteMap(hstSiteMapItem, params, 1, elements);
        }
        if (matchedSiteMapItem == null) {
            params.clear();
            for (HstSiteMapItem item : siteMap.getSiteMapItems()) {
                if (item.isMarkedDeleted() || !(service = (HstSiteMapItemService)item).containsWildCard() || !service.patternMatch(elements[0], service.getPrefix(), service.getPostfix())) continue;
                parameter = this.getStrippedParameter(service, elements[0]);
                params.put(String.valueOf(params.size() + 1), parameter);
                matchedSiteMapItem = this.resolveMatchingSiteMap(service, params, 1, elements);
                if (matchedSiteMapItem == null) continue;
                break;
            }
        }
        if (matchedSiteMapItem == null) {
            params.clear();
            hstSiteMapItem = siteMap.getSiteMapItem("_default_");
            if (hstSiteMapItem != null && !hstSiteMapItem.isMarkedDeleted()) {
                params.put(String.valueOf(params.size() + 1), elements[0]);
                matchedSiteMapItem = this.resolveMatchingSiteMap(hstSiteMapItem, params, 1, elements);
            }
        }
        if (matchedSiteMapItem == null) {
            params.clear();
            for (HstSiteMapItem item : siteMap.getSiteMapItems()) {
                if (item.isMarkedDeleted() || !(service = (HstSiteMapItemService)item).containsAny() || !service.patternMatch(pathInfo, service.getPrefix(), service.getPostfix())) continue;
                parameter = this.getStrippedParameter(service, pathInfo);
                params.put(String.valueOf(params.size() + 1), parameter);
                matchedSiteMapItem = item;
                break;
            }
        }
        if (matchedSiteMapItem == null) {
            params.clear();
            HstSiteMapItem hstSiteMapItemAny = siteMap.getSiteMapItem("_any_");
            if (hstSiteMapItemAny == null || hstSiteMapItemAny.isMarkedDeleted()) {
                log.info("Did not find a matching sitemap item for path '{}', Mount '{}' and Host '" + resolvedMount.getMount().getVirtualHost().getHostName() + "'. Return null", (Object)pathInfo, (Object)(resolvedMount.getMount().getParent() == null ? "hst:root" : resolvedMount.getMount().getMountPath()));
                throw new NotFoundException("PathInfo '" + pathInfo + "' could not be matched");
            }
            params.put(String.valueOf(params.size() + 1), pathInfo);
            matchedSiteMapItem = hstSiteMapItemAny;
        }
        if ((index = matchedSiteMapItem.getChild("_index_")) != null) {
            log.info("Found an '{}' sitemap item below '{}'. Check if the relative content path points to an existing folder/document.", (Object)"_index_", (Object)this.getSiteMapItemPath(matchedSiteMapItem));
            ResolvedSiteMapItemImpl indexResolvedSiteMapItem = new ResolvedSiteMapItemImpl(index, params, pathInfo + "/" + "_index_", resolvedMount);
            if (indexResolvedSiteMapItem.getRelativeContentPath() != null) {
                String absolutePath = mount.getContentPath() + "/" + indexResolvedSiteMapItem.getRelativeContentPath();
                try {
                    if (RequestContextProvider.get() != null && RequestContextProvider.get().getSession().itemExists(absolutePath)) {
                        log.info("Use '{}' sitemap item below '{}' because content path '{}' for the '{}' item exists.", new Object[]{"_index_", this.getSiteMapItemPath(matchedSiteMapItem), absolutePath, "_index_"});
                        this.logMatchedItem(pathInfo, params, matchedSiteMapItem);
                        return indexResolvedSiteMapItem;
                    }
                    log.info("Don't use '{}' sitemap item below '{}' because content path '{}' for the '{}' item does NOT exist.", new Object[]{"_index_", this.getSiteMapItemPath(matchedSiteMapItem), absolutePath, "_index_"});
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get JCR session needed to check existing of the document belonging to the _index_ sitemap item.", (Throwable)e);
                }
            }
        }
        this.logMatchedItem(pathInfo, params, matchedSiteMapItem);
        ResolvedSiteMapItemImpl r = new ResolvedSiteMapItemImpl(matchedSiteMapItem, params, pathInfo, resolvedMount);
        return r;
    }

    private void logMatchedItem(String pathInfo, Properties params, HstSiteMapItem matchedSiteMapItem) {
        if (log.isInfoEnabled()) {
            String path = this.getSiteMapItemPath(matchedSiteMapItem);
            log.info("For path '{}' we found SiteMapItem with path '{}'", (Object)pathInfo, (Object)path);
            log.debug("Params for resolved sitemap item: '{}'", (Object)params);
        }
    }

    private String getSiteMapItemPath(HstSiteMapItem matchedSiteMapItem) {
        String path = matchedSiteMapItem.getId();
        path = path.replace("_default_", "*");
        path = path.replace("_any_", "**");
        return path;
    }

    private HstSiteMapItem resolveMatchingSiteMap(HstSiteMapItem hstSiteMapItem, Properties params, int position, String[] elements) {
        return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, new ArrayList<HstSiteMapItem>());
    }

    private HstSiteMapItem traverseInToSiteMapItem(HstSiteMapItem hstSiteMapItem, Properties params, int position, String[] elements, List<HstSiteMapItem> checkedSiteMapItems) {
        HstSiteMapItemService hstSiteMapItemService = (HstSiteMapItemService)hstSiteMapItem;
        checkedSiteMapItems.add(hstSiteMapItemService);
        if (position == elements.length) {
            return hstSiteMapItemService;
        }
        HstSiteMapItem s = hstSiteMapItemService.getChild(elements[position]);
        if (s != null && !checkedSiteMapItems.contains(s) && !s.isMarkedDeleted()) {
            if (s.isAny() || s.isWildCard()) {
                params.put(String.valueOf(params.size() + 1), this.getStrippedParameter((HstSiteMapItemService)s, elements[position]));
            }
            return this.traverseInToSiteMapItem(s, params, ++position, elements, checkedSiteMapItems);
        }
        s = hstSiteMapItemService.getWildCardPatternChild(elements[position], checkedSiteMapItems);
        if (s != null && !s.isMarkedDeleted()) {
            String parameter = this.getStrippedParameter((HstSiteMapItemService)s, elements[position]);
            params.put(String.valueOf(params.size() + 1), parameter);
            return this.traverseInToSiteMapItem(s, params, ++position, elements, checkedSiteMapItems);
        }
        s = hstSiteMapItemService.getChild("_default_");
        if (s != null && !checkedSiteMapItems.contains(s) && !s.isMarkedDeleted()) {
            params.put(String.valueOf(params.size() + 1), elements[position]);
            return this.traverseInToSiteMapItem(s, params, ++position, elements, checkedSiteMapItems);
        }
        s = hstSiteMapItemService.getAnyPatternChild(elements, position, checkedSiteMapItems);
        if (s != null && !s.isMarkedDeleted()) {
            StringBuffer remainder = new StringBuffer(elements[position]);
            while (++position < elements.length) {
                remainder.append("/").append(elements[position]);
            }
            String parameter = this.getStrippedParameter((HstSiteMapItemService)s, remainder.toString());
            params.put(String.valueOf(params.size() + 1), parameter);
            return s;
        }
        if (hstSiteMapItemService.getChild("_any_") != null && !hstSiteMapItemService.getChild("_any_").isMarkedDeleted()) {
            StringBuffer remainder = new StringBuffer(elements[position]);
            while (++position < elements.length) {
                remainder.append("/").append(elements[position]);
            }
            params.put(String.valueOf(params.size() + 1), remainder.toString());
            return hstSiteMapItem.getChild("_any_");
        }
        return this.traverseUp(hstSiteMapItemService, params, position, elements, checkedSiteMapItems);
    }

    private HstSiteMapItem traverseUp(HstSiteMapItem hstSiteMapItem, Properties params, int position, String[] elements, List<HstSiteMapItem> checkedSiteMapItems) {
        HstSiteMapItemService hstSiteMapItemService = (HstSiteMapItemService)hstSiteMapItem;
        if (hstSiteMapItem == null) {
            return null;
        }
        if (hstSiteMapItem.isWildCard()) {
            HstSiteMapItem s = hstSiteMapItem.getChild("_default_");
            if (s != null && !checkedSiteMapItems.contains(s)) {
                return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, checkedSiteMapItems);
            }
            s = hstSiteMapItemService.getWildCardPatternChild(elements[position], checkedSiteMapItems);
            if (s != null && !checkedSiteMapItems.contains(s)) {
                return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, checkedSiteMapItems);
            }
            if (hstSiteMapItem.getChild("_any_") != null) {
                return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, checkedSiteMapItems);
            }
            s = hstSiteMapItemService.getAnyPatternChild(elements, position, checkedSiteMapItems);
            if (s != null && !checkedSiteMapItems.contains(s)) {
                return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, checkedSiteMapItems);
            }
            params.remove(String.valueOf(params.size()));
            return this.traverseUp(hstSiteMapItem.getParentItem(), params, --position, elements, checkedSiteMapItems);
        }
        HstSiteMapItem s = hstSiteMapItem.getChild("_default_");
        if (s != null && !checkedSiteMapItems.contains(s)) {
            return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, checkedSiteMapItems);
        }
        s = hstSiteMapItemService.getWildCardPatternChild(elements[position], checkedSiteMapItems);
        if (s != null && !checkedSiteMapItems.contains(s)) {
            return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, checkedSiteMapItems);
        }
        if (hstSiteMapItem.getChild("_any_") != null) {
            return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, checkedSiteMapItems);
        }
        s = hstSiteMapItemService.getAnyPatternChild(elements, position, checkedSiteMapItems);
        if (s != null && !checkedSiteMapItems.contains(s)) {
            return this.traverseInToSiteMapItem(hstSiteMapItem, params, position, elements, checkedSiteMapItems);
        }
        return this.traverseUp(hstSiteMapItem.getParentItem(), params, --position, elements, checkedSiteMapItems);
    }

    private String getStrippedParameter(HstSiteMapItemService s, String parameter) {
        String removePrefix = s.getPrefix();
        String removePostfix = s.getPostfix();
        if (removePrefix != null && parameter.startsWith(removePrefix)) {
            parameter = parameter.substring(removePrefix.length());
        }
        if (removePostfix != null && parameter.endsWith(removePostfix)) {
            parameter = parameter.substring(0, parameter.length() - removePostfix.length());
        }
        return parameter;
    }

    public void invalidate() {
    }
}

