/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container.session;

import java.util.EventObject;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.hippoecm.hst.container.event.HttpSessionCreatedEvent;
import org.hippoecm.hst.container.event.HttpSessionDestroyedEvent;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.site.HstServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionEventPublisher
implements HttpSessionListener {
    private static Logger log = LoggerFactory.getLogger(HttpSessionEventPublisher.class);

    public void sessionCreated(HttpSessionEvent event) {
        this.publishSessionEventToComponentManagers(event, true);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.publishSessionEventToComponentManagers(event, false);
    }

    private void publishSessionEventToComponentManagers(HttpSessionEvent event, boolean isSessionCreatedEvent) {
        if (!HstServices.isAvailable()) {
            log.debug("HST Services are not available yet. Skips publishing {} to componentManager(s).", (Object)event);
            return;
        }
        Object eventObject = isSessionCreatedEvent ? new HttpSessionCreatedEvent(event.getSession()) : new HttpSessionDestroyedEvent(event.getSession());
        ComponentManager containerComponentManager = HstServices.getComponentManager();
        if (containerComponentManager == null) {
            log.warn("HST Services seem to be reloaded now. Skips session event publishing to componentManager(s): {}", eventObject);
            return;
        }
        log.debug("Publishing event object to component manager(s): {}", eventObject);
        containerComponentManager.publishEvent((EventObject)eventObject);
    }
}

