/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.hippoecm.hst.container.event.ComponentManagerBeforeReplacedEvent;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.ComponentManagerAware;
import org.hippoecm.hst.site.container.UnregisterableMBeanExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnregisteringMBeanExportersListener
implements ComponentManagerAware {
    private static Logger log = LoggerFactory.getLogger(UnregisteringMBeanExportersListener.class);
    private ComponentManager componentManager;

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public void init() {
        this.componentManager.registerEventSubscriber((Object)this);
    }

    public void destroy() {
        this.componentManager.unregisterEventSubscriber((Object)this);
    }

    @Subscribe
    public void onComponentManagerBeforeReloadedEvent(ComponentManagerBeforeReplacedEvent event) {
        try {
            Map unregisterableMBeanExportersMap = this.componentManager.getComponentsOfType(UnregisterableMBeanExporter.class);
            if (!MapUtils.isEmpty((Map)unregisterableMBeanExportersMap)) {
                for (Map.Entry entry : unregisterableMBeanExportersMap.entrySet()) {
                    log.info("Unregistering MBeans from the exporter, '{}'.", entry.getKey());
                    ((UnregisterableMBeanExporter)((Object)entry.getValue())).unregisterBeans();
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to unregister MBeans from the old component manager.", (Throwable)e);
        }
    }
}

