/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hippoecm.hst.util.ClasspathResourceScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;

public class SpringMetadataReaderClasspathResourceScanner
implements ClasspathResourceScanner,
ResourceLoaderAware {
    private static Logger log = LoggerFactory.getLogger(SpringMetadataReaderClasspathResourceScanner.class);
    private ResourcePatternResolver resourcePatternResolver;

    public Set<String> scanClassNamesAnnotatedBy(Class<? extends Annotation> annotationType, boolean matchSuperClass, String ... locationPatterns) {
        if (this.resourcePatternResolver == null) {
            throw new IllegalStateException("ResourceLoader has not been set.");
        }
        if (locationPatterns == null || locationPatterns.length == 0) {
            throw new IllegalArgumentException("Provide one or more location pattern(s).");
        }
        LinkedHashSet<String> annotatedClassNames = new LinkedHashSet<String>();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
        try {
            CustomAnnotationTypeFilter typeFilter = new CustomAnnotationTypeFilter(annotationType, matchSuperClass);
            for (String locationPattern : locationPatterns) {
                Resource[] resources;
                for (Resource resource : resources = this.resourcePatternResolver.getResources(locationPattern)) {
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    if (!typeFilter.match(metadataReader, (MetadataReaderFactory)metadataReaderFactory)) continue;
                    annotatedClassNames.add(metadataReader.getAnnotationMetadata().getClassName());
                }
            }
        }
        catch (IOException e) {
            log.error("Cannot load resource(s) from the classpath.", (Throwable)e);
            throw new RuntimeException("Cannot load resource(s) from the classpath.", e);
        }
        return annotatedClassNames;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    private static class CustomAnnotationTypeFilter
    extends AnnotationTypeFilter {
        private boolean matchSuperClass;

        public CustomAnnotationTypeFilter(Class<? extends Annotation> annotationType, boolean matchSuperClass) {
            super(annotationType);
            this.matchSuperClass = matchSuperClass;
        }

        public CustomAnnotationTypeFilter(Class<? extends Annotation> annotationType, boolean considerMetaAnnotations, boolean matchSuperClass) {
            super(annotationType, considerMetaAnnotations);
            this.matchSuperClass = matchSuperClass;
        }

        protected Boolean matchSuperClass(String superClassName) {
            if (this.matchSuperClass) {
                return super.matchSuperClass(superClassName);
            }
            return Boolean.FALSE;
        }
    }
}

