/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.hippoecm.hst.addon.module.ModuleInstance;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.ComponentManagerAware;
import org.hippoecm.hst.core.container.ComponentsException;
import org.hippoecm.hst.core.container.ContainerConfiguration;
import org.hippoecm.hst.core.container.ContainerConfigurationImpl;
import org.hippoecm.hst.core.container.ModuleNotFoundException;
import org.hippoecm.hst.core.order.ObjectOrderer;
import org.hippoecm.hst.site.addon.module.model.ModuleDefinition;
import org.hippoecm.hst.site.addon.module.runtime.ModuleInstanceImpl;
import org.hippoecm.hst.site.container.ApplicationContextUtils;
import org.hippoecm.hst.site.container.DefaultComponentManagerApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringComponentManager
implements ComponentManager {
    private static final String LOGGER_FQCN = SpringComponentManager.class.getName();
    private static Logger log = LoggerFactory.getLogger((String)LOGGER_FQCN);
    public static final String IGNORE_UNRESOLVABLE_PLACE_HOLDERS = SpringComponentManager.class.getName() + ".ignoreUnresolvablePlaceholders";
    public static final String SYSTEM_PROPERTIES_MODE = SpringComponentManager.class.getName() + ".systemPropertiesMode";
    public static final String BEAN_REGISTER_CONDITION = SpringComponentManager.class.getName() + ".registerCondition";
    private static final String FALLBACK_ROOT_WEBAPP_CONTEXT_PROPERTY = "component.fallback.root.web.application.context";
    protected AbstractRefreshableConfigApplicationContext applicationContext;
    protected Configuration configuration;
    protected ContainerConfiguration containerConfiguration;
    protected String[] configurationResources = new String[]{SpringComponentManager.class.getName().replace(".", "/") + ".xml", SpringComponentManager.class.getName().replace(".", "/") + "-*.xml"};
    private List<ModuleDefinition> addonModuleDefinitions;
    private Map<String, ModuleInstance> addonModuleInstancesMap;
    private List<ModuleInstance> addonModuleInstancesList;
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private EventBus containerEventBus = new EventBus();
    private boolean fallbackRootApplicationContextLookup;

    public SpringComponentManager() {
        this((Configuration)new PropertiesConfiguration());
    }

    public SpringComponentManager(Configuration configuration) {
        this.configuration = configuration;
        this.containerConfiguration = new ContainerConfigurationImpl(this.configuration);
    }

    public SpringComponentManager(ServletConfig servletConfig, Configuration configuration) {
        this(configuration);
        this.setServletConfig(servletConfig);
    }

    public SpringComponentManager(ServletContext servletContext, Configuration configuration) {
        this(configuration);
        this.setServletContext(servletContext);
    }

    @Deprecated
    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (servletConfig != null) {
            this.setServletContext(servletConfig.getServletContext());
        }
    }

    @Deprecated
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object[] checkedConfigurationResources;
        this.applicationContext = new DefaultComponentManagerApplicationContext(this, this.containerConfiguration);
        this.fallbackRootApplicationContextLookup = this.containerConfiguration.getBoolean(FALLBACK_ROOT_WEBAPP_CONTEXT_PROPERTY, false);
        if (this.fallbackRootApplicationContextLookup) {
            log.info("Component fallback to root webapplication context if available is enabled.");
        }
        if (ArrayUtils.isEmpty((Object[])(checkedConfigurationResources = ApplicationContextUtils.getCheckedLocationPatterns((ApplicationContext)this.applicationContext, this.getConfigurationResources())))) {
            log.warn("There's no valid component configuration.");
        }
        this.applicationContext.setConfigLocations((String[])checkedConfigurationResources);
        this.applicationContext.refresh();
        if (this.addonModuleDefinitions != null && !this.addonModuleDefinitions.isEmpty()) {
            this.orderAddonModuleDefinitions();
            this.addonModuleInstancesMap = Collections.synchronizedMap(new HashMap());
            for (ModuleDefinition addonModuleDefinition : this.addonModuleDefinitions) {
                AbstractRefreshableConfigApplicationContext parentApplicationContext;
                ModuleInstanceImpl addonModuleInstance = new ModuleInstanceImpl(addonModuleDefinition);
                if (addonModuleDefinition.getParent() != null) {
                    ModuleInstanceImpl parentModuleInstance = (ModuleInstanceImpl)this.addonModuleInstancesMap.get(addonModuleDefinition.getParent());
                    if (parentModuleInstance == null) {
                        log.error(String.format("Failed to initialize invalid module instance, %s, because the parent '%s' does not exist. Module instance will be ignored.", addonModuleInstance.getFullName(), addonModuleDefinition.getParent()));
                        continue;
                    }
                    parentApplicationContext = parentModuleInstance.getApplicationContext();
                } else {
                    parentApplicationContext = this.applicationContext;
                }
                if (addonModuleInstance instanceof ComponentManagerAware) {
                    ((ComponentManagerAware)addonModuleInstance).setComponentManager((ComponentManager)this);
                }
                if (addonModuleInstance instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)addonModuleInstance).setApplicationContext((ApplicationContext)parentApplicationContext);
                }
                try {
                    log.info("Initializing addon module, {}", (Object)addonModuleInstance.getFullName());
                    addonModuleInstance.initialize();
                    this.addonModuleInstancesMap.put(addonModuleInstance.getName(), addonModuleInstance);
                }
                catch (Exception e) {
                    log.error("Failed to initialize invalid module instance, " + addonModuleInstance.getFullName() + ", which will be just closed and ignored.", (Throwable)e);
                    try {
                        addonModuleInstance.close();
                    }
                    catch (Exception ce) {
                        log.warn("Failed to close invalid module instance, " + addonModuleInstance.getFullName() + ".", (Throwable)e);
                    }
                }
            }
            Map<String, ModuleInstance> map = this.addonModuleInstancesMap;
            synchronized (map) {
                this.addonModuleInstancesList = Collections.synchronizedList(new ArrayList<ModuleInstance>(this.addonModuleInstancesMap.values()));
            }
        }
    }

    private void orderAddonModuleDefinitions() {
        ObjectOrderer<ModuleDefinition> objectOrderer = new ObjectOrderer<ModuleDefinition>("Addon Module Definition Orderer");
        for (ModuleDefinition addonModuleDefinition : this.addonModuleDefinitions) {
            objectOrderer.add(addonModuleDefinition, addonModuleDefinition.getName(), addonModuleDefinition.getParent(), null);
        }
        this.addonModuleDefinitions = objectOrderer.getOrderedObjects();
    }

    public void start() {
        this.applicationContext.start();
        ArrayList<ModuleInstance> failedModuleInstances = new ArrayList<ModuleInstance>();
        for (ModuleInstance addonModuleInstance : this.getAddonModuleInstances()) {
            try {
                log.info("Starting addon module, {}", (Object)addonModuleInstance.getFullName());
                addonModuleInstance.start();
            }
            catch (Exception e) {
                log.warn("Failed to start module instance, " + addonModuleInstance.getFullName() + ", which will be just removed.", (Throwable)e);
                failedModuleInstances.add(addonModuleInstance);
            }
        }
        for (ModuleInstance addonModuleInstance : failedModuleInstances) {
            try {
                addonModuleInstance.stop();
            }
            catch (Exception e) {
                log.warn("Failed to stop non-starting module instance, " + addonModuleInstance.getFullName() + ".", (Throwable)e);
            }
            try {
                addonModuleInstance.close();
            }
            catch (Exception e) {
                log.warn("Failed to close non-starting module instance, " + addonModuleInstance.getFullName() + ".", (Throwable)e);
            }
            this.addonModuleInstancesMap.remove(addonModuleInstance.getName());
            this.addonModuleInstancesList.remove(addonModuleInstance);
        }
    }

    public void stop() {
        for (ModuleInstance addonModuleInstance : this.getAddonModuleInstances()) {
            try {
                log.info("Stopping addon module, {}", (Object)addonModuleInstance.getFullName());
                addonModuleInstance.stop();
            }
            catch (Exception e) {
                log.warn("Failed to stop module instance, " + addonModuleInstance.getFullName() + ".", (Throwable)e);
            }
        }
        this.applicationContext.stop();
    }

    public void close() {
        for (ModuleInstance addonModuleInstance : this.getAddonModuleInstances()) {
            try {
                log.info("Closing addon module, {}", (Object)addonModuleInstance.getFullName());
                addonModuleInstance.close();
            }
            catch (Exception e) {
                log.warn("Failed to close module instance, " + addonModuleInstance.getFullName() + ".", (Throwable)e);
            }
        }
        this.applicationContext.close();
    }

    public <T> T getComponent(String name) {
        return this.getComponent(name, (String[])null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getComponent(String name, String ... addonModuleNames) {
        Object bean = null;
        if (addonModuleNames == null || addonModuleNames.length == 0) {
            try {
                bean = this.applicationContext.getBean(name);
                return (T)bean;
            }
            catch (Exception e) {
                if (this.fallbackRootApplicationContextLookup && this.servletContext != null) {
                    WebApplicationContext rootWebAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
                    if (rootWebAppContext != null) {
                        log.info("The requested bean '{}' doesn't exist in HST spring core component manager. Trying fallback to the root application context", (Object)name);
                        try {
                            return (T)rootWebAppContext.getBean(name);
                        }
                        catch (Exception e2) {
                            log.info("The requested bean '{}' doesn't exist in HST spring component manager nor in the fallback root application context.", (Object)name);
                            return (T)bean;
                        }
                    } else {
                        log.info("The requested bean '{}' doesn't exist.", (Object)name);
                    }
                    return (T)bean;
                }
                log.info("The requested bean '{}' doesn't exist.", (Object)name);
            }
            return (T)bean;
        }
        if (this.addonModuleInstancesMap == null || this.addonModuleInstancesMap.isEmpty()) {
            throw new ModuleNotFoundException("No Addon Module is found.");
        }
        ModuleInstance moduleInstance = this.addonModuleInstancesMap.get(addonModuleNames[0]);
        if (moduleInstance == null) {
            throw new ModuleNotFoundException("Module is not found: '" + addonModuleNames[0] + "'");
        }
        for (int i = 1; i < addonModuleNames.length; ++i) {
            if ((moduleInstance = moduleInstance.getModuleInstance(addonModuleNames[i])) != null) continue;
            throw new ModuleNotFoundException("Module is not found in '" + ArrayUtils.toString((Object)ArrayUtils.subarray((Object[])addonModuleNames, (int)0, (int)(i + 1))) + "'");
        }
        try {
            bean = moduleInstance.getComponent(name);
            return (T)bean;
        }
        catch (Exception e) {
            log.info("The requested bean doesn't exist: '{}' in the addon module context, '{}'.", (Object)name, (Object)ArrayUtils.toString((Object)addonModuleNames));
        }
        return (T)bean;
    }

    public <T> T getComponent(Class<T> requiredType) throws ComponentsException {
        return this.getComponent(requiredType, (String[])null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getComponent(Class<T> requiredType, String ... addonModuleNames) throws ComponentsException {
        Object bean;
        block15: {
            bean = null;
            if (addonModuleNames == null || addonModuleNames.length == 0) {
                try {
                    bean = this.applicationContext.getBean(requiredType);
                }
                catch (Exception e) {
                    if (this.fallbackRootApplicationContextLookup && this.servletContext != null) {
                        WebApplicationContext rootWebAppContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
                        if (rootWebAppContext != null) {
                            log.info("The requested bean by type '{}' doesn't exist in HST spring core component manager. Trying fallback to the root application context", requiredType);
                            try {
                                return (T)rootWebAppContext.getBean(requiredType);
                            }
                            catch (Exception e2) {
                                log.warn("The requested bean by type '{}' doesn't exist in HST spring component manager nor in the fallback root application context.", requiredType);
                                break block15;
                            }
                        } else {
                            log.warn("The requested bean '{}' doesn't exist by the required type: '{}'", requiredType);
                        }
                        break block15;
                    }
                    log.warn("The requested bean '{}' doesn't exist by the required type: '{}'", requiredType);
                }
            } else {
                if (this.addonModuleInstancesMap == null || this.addonModuleInstancesMap.isEmpty()) {
                    throw new ModuleNotFoundException("No Addon Module is found.");
                }
                ModuleInstance moduleInstance = this.addonModuleInstancesMap.get(addonModuleNames[0]);
                if (moduleInstance == null) {
                    throw new ModuleNotFoundException("Module is not found: '" + addonModuleNames[0] + "'");
                }
                for (int i = 1; i < addonModuleNames.length; ++i) {
                    if ((moduleInstance = moduleInstance.getModuleInstance(addonModuleNames[i])) != null) continue;
                    throw new ModuleNotFoundException("Module is not found in '" + ArrayUtils.toString((Object)ArrayUtils.subarray((Object[])addonModuleNames, (int)0, (int)(i + 1))) + "'");
                }
                try {
                    bean = moduleInstance.getComponent(requiredType);
                }
                catch (Exception e) {
                    log.warn("The requested bean doesn't exist by the required type: '{}' in the addon module context, '{}'.", requiredType, (Object)ArrayUtils.toString((Object)addonModuleNames));
                }
            }
        }
        if (bean == null) {
            throw new ComponentsException("No component found, not exactly matching a single component by the specified type, " + requiredType);
        }
        return (T)bean;
    }

    public <T> Map<String, T> getComponentsOfType(Class<T> requiredType) {
        return this.getComponentsOfType(requiredType, null);
    }

    public <T> Map<String, T> getComponentsOfType(Class<T> requiredType, String ... addonModuleNames) {
        Map beansMap = Collections.emptyMap();
        if (addonModuleNames == null || addonModuleNames.length == 0) {
            try {
                beansMap = this.applicationContext.getBeansOfType(requiredType);
            }
            catch (Exception e) {
                log.warn("The required typed bean doesn't exist: '{}'", requiredType);
            }
        } else {
            if (this.addonModuleInstancesMap == null || this.addonModuleInstancesMap.isEmpty()) {
                throw new ModuleNotFoundException("No Addon Module is found.");
            }
            ModuleInstance moduleInstance = this.addonModuleInstancesMap.get(addonModuleNames[0]);
            if (moduleInstance == null) {
                throw new ModuleNotFoundException("Module is not found: '" + addonModuleNames[0] + "'");
            }
            for (int i = 1; i < addonModuleNames.length; ++i) {
                if ((moduleInstance = moduleInstance.getModuleInstance(addonModuleNames[i])) != null) continue;
                throw new ModuleNotFoundException("Module is not found in '" + ArrayUtils.toString((Object)ArrayUtils.subarray((Object[])addonModuleNames, (int)0, (int)(i + 1))) + "'");
            }
            try {
                beansMap = moduleInstance.getComponentsOfType(requiredType);
            }
            catch (Exception e) {
                log.warn("The required typed bean doesn't exist: '{}' in the addon module context, '{}'.", requiredType, (Object)ArrayUtils.toString((Object)addonModuleNames));
            }
        }
        return beansMap;
    }

    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public String[] getConfigurationResources() {
        if (this.configurationResources == null) {
            return null;
        }
        String[] cloned = new String[this.configurationResources.length];
        System.arraycopy(this.configurationResources, 0, cloned, 0, this.configurationResources.length);
        return cloned;
    }

    public void setConfigurationResources(String[] configurationResources) {
        if (configurationResources == null) {
            this.configurationResources = null;
        } else {
            this.configurationResources = new String[configurationResources.length];
            System.arraycopy(configurationResources, 0, this.configurationResources, 0, configurationResources.length);
        }
    }

    public void publishEvent(EventObject event) {
        this.containerEventBus.post((Object)event);
    }

    public void registerEventSubscriber(Object subscriber) {
        this.containerEventBus.register(subscriber);
    }

    public void unregisterEventSubscriber(Object subscriber) {
        this.containerEventBus.unregister(subscriber);
    }

    public void setAddonModuleDefinitions(List<ModuleDefinition> addonModuleDefinitions) {
        this.addonModuleDefinitions = addonModuleDefinitions == null ? null : new ArrayList<ModuleDefinition>(addonModuleDefinitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ModuleInstance> getAddonModuleInstances() {
        if (this.addonModuleInstancesList == null) {
            return Collections.emptyList();
        }
        ArrayList<ModuleInstance> addonModuleInstances = null;
        List<ModuleInstance> list = this.addonModuleInstancesList;
        synchronized (list) {
            addonModuleInstances = new ArrayList<ModuleInstance>(this.addonModuleInstancesList);
        }
        return addonModuleInstances;
    }
}

