/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ResourceFactoryBean
implements FactoryBean<Object>,
ResourceLoaderAware {
    private static Logger log = LoggerFactory.getLogger(ResourceFactoryBean.class);
    private ResourceLoader resourceLoader;
    private String resourcePath;
    private Class<?> objectType;
    private boolean singleton = true;
    private Object singletonBean;
    private boolean ignoreCreationError;
    private Object defaultResourceObject;

    public ResourceFactoryBean(String resourcePath) {
        this(resourcePath, null);
    }

    public ResourceFactoryBean(String resourcePath, Class<?> objectType) {
        this(resourcePath, objectType, null);
    }

    public ResourceFactoryBean(String resourcePath, Class<?> objectType, Object defaultResourceObject) {
        this.resourcePath = resourcePath;
        this.objectType = objectType;
        this.defaultResourceObject = defaultResourceObject;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Object getObject() throws Exception {
        if (this.singleton) {
            if (this.singletonBean == null) {
                this.singletonBean = this.createInstance();
                this.resourceLoader = null;
            }
            return this.singletonBean;
        }
        return this.createInstance();
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public Class<?> getObjectType() {
        return this.objectType != null ? this.objectType : Resource.class;
    }

    public boolean isIgnoreCreationError() {
        return this.ignoreCreationError;
    }

    public void setIgnoreCreationError(boolean ignoreCreationError) {
        this.ignoreCreationError = ignoreCreationError;
    }

    protected Object createInstance() throws Exception {
        Resource resource = null;
        try {
            resource = this.resourceLoader.getResource(this.resourcePath);
            if (URL.class == this.objectType) {
                return resource.getURL();
            }
            if (String.class == this.objectType) {
                return resource.getURL().toString();
            }
            if (URI.class == this.objectType) {
                return resource.getURI();
            }
            if (File.class == this.objectType) {
                return resource.getFile();
            }
        }
        catch (Throwable th) {
            if (this.isIgnoreCreationError()) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to create resource, '{}'.", (Object)this.resourcePath, (Object)th);
                } else {
                    log.warn("Failed to create resource, '{}'. {}", (Object)this.resourcePath, (Object)th.toString());
                }
                if (this.defaultResourceObject != null) {
                    return this.defaultResourceObject;
                }
            }
            throw new BeanCreationException("Failed to create resource, '" + this.resourcePath + "'.", th);
        }
        return resource;
    }
}

