/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.site.addon.module.model.ModuleDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDescriptorUtils {
    private static Logger log = LoggerFactory.getLogger(ModuleDescriptorUtils.class);

    private ModuleDescriptorUtils() {
    }

    public static List<ModuleDefinition> collectAllModuleDefinitions() throws IOException {
        return ModuleDescriptorUtils.collectAllModuleDefinitions(Thread.currentThread().getContextClassLoader());
    }

    static List<ModuleDefinition> collectAllModuleDefinitions(ClassLoader classLoader) throws IOException {
        return ModuleDescriptorUtils.collectAllModuleDefinitions(classLoader, StringUtils.split((String)"META-INF/hst-assembly/addon/module.xml", (String)" ,"));
    }

    static List<ModuleDefinition> collectAllModuleDefinitions(ClassLoader classLoader, String ... moduleDescriptorResourcePaths) throws IOException {
        ArrayList<ModuleDefinition> moduleDefinitions = new ArrayList<ModuleDefinition>();
        for (String moduleDescriptorResourcePath : moduleDescriptorResourcePaths) {
            Enumeration<URL> moduleDescriptorURLs = classLoader.getResources(moduleDescriptorResourcePath);
            while (moduleDescriptorURLs.hasMoreElements()) {
                URL moduleDescriptorURL = moduleDescriptorURLs.nextElement();
                try {
                    log.info("Loading module descriptor from {}", (Object)moduleDescriptorURL);
                    ModuleDefinition moduleDefinition = ModuleDescriptorUtils.loadModuleDefinition(moduleDescriptorURL);
                    moduleDefinitions.add(moduleDefinition);
                }
                catch (Exception e) {
                    log.warn("Failed to load module descriptor, " + moduleDescriptorURL + ", which will be just ignored.", (Throwable)e);
                }
            }
        }
        return moduleDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleDefinition loadModuleDefinition(URL url) throws JAXBException, IOException {
        ModuleDefinition moduleDefinition = null;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ModuleDefinition.class});
        Unmarshaller um = jc.createUnmarshaller();
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            is = url.openStream();
            bis = new BufferedInputStream(is);
            moduleDefinition = (ModuleDefinition)um.unmarshal(url.openStream());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly((InputStream)is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)is);
        return moduleDefinition;
    }
}

