/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import java.io.Serializable;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.hippoecm.hst.site.container.DefaultHstSiteConfigurer;
import org.hippoecm.hst.site.container.HstSiteConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstContextLoaderListener
implements ServletContextListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(HstContextLoaderListener.class);
    private HstSiteConfigurer siteConfigurer;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.siteConfigurer = new DefaultHstSiteConfigurer();
            ((DefaultHstSiteConfigurer)this.siteConfigurer).setServletContext(sce.getServletContext());
            this.siteConfigurer.initialize();
        }
        catch (Exception e) {
            log.error("Error occurred while initializing HstSiteConfigurer.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.siteConfigurer != null) {
            try {
                this.siteConfigurer.destroy();
            }
            catch (Exception e) {
                log.error("Error occurred while destroying HstSiteConfigurer.", (Throwable)e);
            }
        }
    }
}

