/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.jexl.Script;
import org.apache.commons.jexl.ScriptFactory;
import org.apache.commons.lang.BooleanUtils;
import org.hippoecm.hst.core.container.ContainerConfiguration;
import org.hippoecm.hst.site.container.SpringComponentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

class FilteringByExpressionListableBeanFactory
extends DefaultListableBeanFactory {
    private static Logger log = LoggerFactory.getLogger(FilteringByExpressionListableBeanFactory.class);
    private JexlContext jexlContext = JexlHelper.createContext();

    public FilteringByExpressionListableBeanFactory(BeanFactory parentBeanFactory, ContainerConfiguration containerConfiguration) {
        super(parentBeanFactory);
        this.jexlContext.getVars().put("sys", System.class);
        this.jexlContext.getVars().put("config", containerConfiguration);
    }

    public void registerBeanDefinition(String beanName, BeanDefinition bd) throws BeanDefinitionStoreException {
        boolean registrable = true;
        String expression = (String)bd.getAttribute(SpringComponentManager.BEAN_REGISTER_CONDITION);
        if (expression != null) {
            try {
                Script jexlScript = ScriptFactory.createScript((String)expression);
                Object result = jexlScript.execute(this.jexlContext);
                if (result == null) {
                    registrable = false;
                } else if (result instanceof Boolean) {
                    registrable = BooleanUtils.toBoolean((Boolean)((Boolean)result));
                } else if (result instanceof String) {
                    registrable = BooleanUtils.toBoolean((String)((String)result));
                } else if (result instanceof Integer) {
                    registrable = BooleanUtils.toBoolean((int)((Integer)result));
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Expression execution error: " + expression, (Throwable)e);
                }
                log.warn("Expression execution error: {}. {}", (Object)expression, (Object)e);
            }
        }
        if (registrable) {
            super.registerBeanDefinition(beanName, bd);
        } else {
            log.debug("Skipping the bean definition: " + bd);
        }
    }
}

