/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.hippoecm.hst.container.event.ComponentManagerBeforeReplacedEvent;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.util.PropertyParser;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.site.addon.module.model.ModuleDefinition;
import org.hippoecm.hst.site.container.HstSiteConfigurer;
import org.hippoecm.hst.site.container.ModuleDescriptorUtils;
import org.hippoecm.hst.site.container.SpringComponentManager;
import org.hippoecm.hst.util.ServletConfigUtils;
import org.onehippo.cms7.services.ServletContextRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHstSiteConfigurer
implements HstSiteConfigurer {
    private static final long serialVersionUID = 1L;
    private static final String HST_CONFIGURATION_XML = "hst-configuration.xml";
    private static final String HST_CONFIG_PROPERTIES = "hst-config.properties";
    private static final String HST_CONFIG_ENV_PROPERTIES = "${catalina.base}/conf/hst.properties";
    private static final String HST_CONFIGURATION_REFRESH_DELAY_PARAM = "hst-config-refresh-delay";
    private static final String FORCEFUL_REINIT_PARAM = "forceful.reinit";
    private static final String ASSEMBLY_OVERRIDES_CONFIGURATIONS_PARAM = "assembly.overrides";
    private static final long DEFAULT_CONFIGURATION_REFRESH_DELAY = 0L;
    private static final Logger log = LoggerFactory.getLogger(DefaultHstSiteConfigurer.class);
    private String[] assemblyOverridesConfigurations = new String[]{"META-INF/hst-assembly/overrides/*.xml"};
    private boolean initialized;
    private boolean forcefulReinitialization;
    private Configuration configuration;
    private long configurationRefreshDelay;
    private boolean hstSystemPropertiesOverride = true;
    private String hstConfigEnvProperties = "${catalina.base}/conf/hst.properties";
    private static final String INIT_START_MSG = "HstSiteConfigurer Starting Initialization...";
    private static final String INIT_DONE_MSG = "HstSiteConfigurer Initialization complete, Ready to service requests.";
    private HstSiteConfigurationChangesChecker hstSiteConfigurationChangesCheckerThread;
    private ServletContext servletContext;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void initialize() throws ContainerException {
        if (this.getServletContext() == null) {
            throw new ContainerException("No ServletContext available.");
        }
        ServletContextRegistry.register((ServletContext)this.getServletContext(), (ServletContextRegistry.WebAppType)ServletContextRegistry.WebAppType.HST);
        log.debug("Registered servlet context '{}' at {}", (Object)this.getServletContext().getContextPath(), (Object)ServletContextRegistry.class.getName());
        this.forcefulReinitialization = Boolean.parseBoolean(this.getConfigOrContextInitParameter(FORCEFUL_REINIT_PARAM, null));
        if (!this.forcefulReinitialization && HstServices.isAvailable()) {
            return;
        }
        this.hstSystemPropertiesOverride = BooleanUtils.toBoolean((String)this.getConfigOrContextInitParameter("hst-system-properties-override", "true"));
        this.hstConfigEnvProperties = this.getConfigOrContextInitParameter("hst-env-config-properties", HST_CONFIG_ENV_PROPERTIES);
        this.configurationRefreshDelay = NumberUtils.toLong((String)this.getConfigOrContextInitParameter(HST_CONFIGURATION_REFRESH_DELAY_PARAM, null), (long)0L);
        this.configuration = this.getConfiguration();
        if (this.configurationRefreshDelay > 0L) {
            this.setUpFileConfigurationReloadingStrategies();
        }
        if (this.configuration.containsKey(ASSEMBLY_OVERRIDES_CONFIGURATIONS_PARAM)) {
            this.assemblyOverridesConfigurations = this.configuration.getStringArray(ASSEMBLY_OVERRIDES_CONFIGURATIONS_PARAM);
        }
        this.initializeComponentManager();
    }

    protected synchronized boolean isInitialized() {
        return this.initialized;
    }

    private synchronized void initializeComponentManager() {
        block11: {
            SpringComponentManager componentManager = null;
            ComponentManager oldComponentManager = HstServices.getComponentManager();
            if (oldComponentManager != null) {
                log.info("HstSiteConfigServlet will re-initialize the Component manager...");
                oldComponentManager.publishEvent((EventObject)new ComponentManagerBeforeReplacedEvent(oldComponentManager));
            }
            try {
                List<ModuleDefinition> addonModuleDefinitions;
                log.info(INIT_START_MSG);
                log.info("HstSiteConfigServlet attempting to create the Component manager...");
                componentManager = new SpringComponentManager(this.getServletContext(), this.configuration);
                log.info("HSTSiteServlet attempting to start the Component Manager...");
                if (this.assemblyOverridesConfigurations != null && this.assemblyOverridesConfigurations.length > 0) {
                    Object[] configurations = componentManager.getConfigurationResources();
                    configurations = (String[])ArrayUtils.addAll((Object[])configurations, (Object[])this.assemblyOverridesConfigurations);
                    componentManager.setConfigurationResources((String[])configurations);
                }
                if ((addonModuleDefinitions = ModuleDescriptorUtils.collectAllModuleDefinitions()) != null && !addonModuleDefinitions.isEmpty()) {
                    componentManager.setAddonModuleDefinitions(addonModuleDefinitions);
                }
                componentManager.initialize();
                componentManager.start();
                log.info("HstSiteConfigServlet has successfuly started the Component Manager....");
                HstServices.setComponentManager((ComponentManager)componentManager);
                if (oldComponentManager != null) {
                    log.info("HstSiteConfigServlet attempting to stop the old component manager...");
                    try {
                        oldComponentManager.stop();
                        oldComponentManager.close();
                    }
                    catch (Exception ce) {
                        log.warn("Old Component Manager stopping/closing error", (Throwable)ce);
                    }
                }
                this.initialized = true;
                log.info(INIT_DONE_MSG);
            }
            catch (Exception e) {
                log.error("HstSiteConfigServlet: ComponentManager initialization failed.", (Throwable)e);
                if (componentManager == null) break block11;
                try {
                    componentManager.stop();
                    componentManager.close();
                }
                catch (Exception ce) {
                    if (log.isDebugEnabled()) {
                        log.warn("Exception occurred during stopping componentManager.", (Throwable)e);
                        break block11;
                    }
                    if (!log.isWarnEnabled()) break block11;
                    log.warn("Exception occurred during stopping componentManager. {}", (Object)e.toString());
                }
            }
        }
    }

    @Override
    public synchronized void destroy() {
        log.info("Done shutting down!");
        ServletContextRegistry.unregister((ServletContext)this.getServletContext());
        log.debug("Unregistered servlet context '{}' from {}", (Object)this.getServletContext().getContextPath(), (Object)ServletContextRegistry.class.getName());
        this.destroyHstSiteConfigurationChangesCheckerThread();
        ComponentManager componentManager = HstServices.getComponentManager();
        if (componentManager != null) {
            try {
                componentManager.stop();
                componentManager.close();
            }
            catch (Exception e) {
                log.warn("Component Manager stopping/closing error", (Throwable)e);
            }
            finally {
                HstServices.setComponentManager(null);
            }
        }
    }

    protected Configuration getConfiguration() throws ContainerException {
        try {
            Configuration[] configs = this.loadFileConfigurations();
            CompositeConfiguration configuration = new CompositeConfiguration();
            if (this.hstSystemPropertiesOverride) {
                configuration.addConfiguration((Configuration)new SystemConfiguration());
                log.info("Adding System Properties to HST Configuration.");
            }
            for (Configuration config : configs) {
                configuration.addConfiguration(config);
            }
            Configuration defaultHstConf = this.loadDefaultHstConfiguration();
            if (defaultHstConf != null) {
                configuration.addConfiguration(defaultHstConf);
            }
            return configuration;
        }
        catch (Exception e) {
            throw new ContainerException((Throwable)e);
        }
    }

    private Configuration loadDefaultHstConfiguration() {
        PropertiesConfiguration defaultHstConfiguration = null;
        try {
            URL defaultContainerPropsUrl = Thread.currentThread().getContextClassLoader().getResource(StringUtils.replace((String)SpringComponentManager.class.getName(), (String)".", (String)"/") + ".properties");
            defaultHstConfiguration = new PropertiesConfiguration(defaultContainerPropsUrl);
        }
        catch (Exception e) {
            log.warn("Failed to load the default container properties.", (Throwable)e);
        }
        return defaultHstConfiguration;
    }

    private void setUpFileConfigurationReloadingStrategies() {
        boolean reloadingStrategySet = false;
        int configSize = ((CompositeConfiguration)this.configuration).getNumberOfConfigurations();
        for (int i = 0; i < configSize; ++i) {
            Configuration config = ((CompositeConfiguration)this.configuration).getConfiguration(i);
            if (!(config instanceof AbstractFileConfiguration)) continue;
            ((AbstractFileConfiguration)config).setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy(){

                public void reloadingPerformed() {
                    super.reloadingPerformed();
                    log.warn("HstSiteConfigServlet is trying to reinitialize component manager on configuration change in {}.", (Object)this.getFile());
                    try {
                        DefaultHstSiteConfigurer.this.initializeComponentManager();
                        log.warn("HstSiteConfigServlet has completed reinitializing component manager on configuration change in {}.", (Object)this.getFile());
                    }
                    catch (Exception e) {
                        log.error("HstSiteConfigServlet failed to reinitialize component manager on configuration change in " + this.getFile(), (Throwable)e);
                    }
                }
            });
            reloadingStrategySet = true;
        }
        if (reloadingStrategySet) {
            log.info("HstSiteConfigServlet enables component manager reloading on configuration change with refreshing delay = {} ms", (Object)this.configurationRefreshDelay);
            this.destroyHstSiteConfigurationChangesCheckerThread();
            this.hstSiteConfigurationChangesCheckerThread = new HstSiteConfigurationChangesChecker();
            this.hstSiteConfigurationChangesCheckerThread.start();
        }
    }

    protected Configuration[] loadFileConfigurations() throws ConfigurationException {
        Configuration config;
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        String fileParam = ServletConfigUtils.getInitParameter(null, (ServletContext)this.getServletContext(), (String)"hst-configuration", null);
        if (StringUtils.isNotBlank((String)fileParam)) {
            config = this.loadConfigurationFromDefinitionXml(this.getResourceFile(fileParam, true));
            if (config != null) {
                log.info("Adding Configurarion file to HST Configuration: {}", (Object)fileParam);
                configs.add(config);
            }
        } else {
            fileParam = ServletConfigUtils.getInitParameter(null, (ServletContext)this.getServletContext(), (String)"hst-config-properties", null);
            config = this.loadConfigurationFromProperties(this.getResourceFile(fileParam, true));
            if (config != null) {
                log.info("Adding Configurarion file to HST Configuration: {}", (Object)fileParam);
                configs.add(config);
            }
        }
        config = this.loadConfigurationFromProperties(this.getResourceFile(this.hstConfigEnvProperties, true));
        if (config != null) {
            log.info("Adding Configurarion file to HST Configuration: {}", (Object)fileParam);
            configs.add(config);
        }
        if ((config = this.loadConfigurationFromDefinitionXml(this.getResourceFile(fileParam = "/WEB-INF/hst-configuration.xml", true))) != null) {
            log.info("Adding Configurarion file to HST Configuration: {}", (Object)fileParam);
            configs.add(config);
        } else {
            fileParam = "/WEB-INF/hst-config.properties";
            config = this.loadConfigurationFromProperties(this.getResourceFile(fileParam, true));
            if (config != null) {
                log.info("Adding Configurarion file to HST Configuration: {}", (Object)fileParam);
                configs.add(config);
            }
        }
        return configs.toArray(new Configuration[configs.size()]);
    }

    protected String getConfigOrContextInitParameter(String paramName, String defaultValue) {
        String value = ServletConfigUtils.getInitParameter(null, (ServletContext)this.getServletContext(), (String)paramName, (String)defaultValue);
        return value != null ? value.trim() : null;
    }

    protected File getResourceFile(String resourcePath) {
        return this.getResourceFile(resourcePath, false);
    }

    protected File getResourceFile(String resourcePath, boolean resolveSysProps) {
        if (StringUtils.isBlank((String)resourcePath)) {
            return null;
        }
        if (resolveSysProps) {
            PropertyParser propParser = new PropertyParser(System.getProperties(), "${", "}", PropertyParser.DEFAULT_VALUE_SEPARATOR, true);
            resourcePath = (String)propParser.resolveProperty("resourceFile", StringUtils.trim((String)resourcePath));
        }
        File resourceFile = null;
        if (resourcePath.startsWith("file:")) {
            try {
                resourceFile = new File(URI.create(resourcePath));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid URI for file: {}", (Object)resourcePath);
            }
            catch (Exception e) {
                log.warn("Failed to create a file from URI: {}. {}", (Object)resourcePath, (Object)e);
            }
        } else if (resourcePath.startsWith("/")) {
            String realPath = null;
            try {
                URL resourceUrl = this.getServletContext().getResource(resourcePath);
                realPath = resourceUrl != null ? this.getServletContext().getRealPath(resourcePath) : resourcePath;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (realPath != null) {
                resourceFile = new File(realPath);
            }
        } else {
            resourceFile = new File(resourcePath);
        }
        return resourceFile;
    }

    private Configuration loadConfigurationFromDefinitionXml(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        try {
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            builder.setFile(file);
            return builder.getConfiguration();
        }
        catch (ConfigurationException e) {
            log.warn("Configuration error from: " + file, (Throwable)e);
            return null;
        }
    }

    private Configuration loadConfigurationFromProperties(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        try {
            return new PropertiesConfiguration(file);
        }
        catch (ConfigurationException e) {
            log.warn("Configuration error from: " + file, (Throwable)e);
            return null;
        }
    }

    private void destroyHstSiteConfigurationChangesCheckerThread() {
        try {
            if (this.hstSiteConfigurationChangesCheckerThread != null && this.hstSiteConfigurationChangesCheckerThread.isAlive()) {
                this.hstSiteConfigurationChangesCheckerThread.setStopped(true);
                this.hstSiteConfigurationChangesCheckerThread.interrupt();
                this.hstSiteConfigurationChangesCheckerThread.join(10000L);
            }
        }
        catch (Exception e) {
            log.warn("HstSiteConfigurationChangesCheckerThread interruption error", (Throwable)e);
        }
        finally {
            this.hstSiteConfigurationChangesCheckerThread = null;
        }
    }

    private class HstSiteConfigurationChangesChecker
    extends Thread {
        private boolean stopped;

        private HstSiteConfigurationChangesChecker() {
            super("HstSiteConfigurationChangesChecker");
            this.setDaemon(true);
        }

        public void setStopped(boolean stopped) {
            this.stopped = stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                DefaultHstSiteConfigurer.this.configuration.getString("development.mode");
                HstSiteConfigurationChangesChecker hstSiteConfigurationChangesChecker = this;
                synchronized (hstSiteConfigurationChangesChecker) {
                    block6: {
                        try {
                            this.wait(DefaultHstSiteConfigurer.this.configurationRefreshDelay);
                        }
                        catch (InterruptedException e) {
                            if (!this.stopped) break block6;
                            break;
                        }
                    }
                }
            }
        }
    }
}

