/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.ComponentManagerAware;
import org.hippoecm.hst.core.container.ContainerConfiguration;
import org.hippoecm.hst.site.container.FilteringByExpressionListableBeanFactory;
import org.hippoecm.hst.site.container.OverridingByAttributesPropertyPlaceholderConfigurer;
import org.hippoecm.hst.site.container.SpringComponentManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DefaultComponentManagerApplicationContext
extends ClassPathXmlApplicationContext
implements BeanPostProcessor,
ComponentManagerAware {
    private ContainerConfiguration containerConfiguration;
    private ComponentManager componentManager;

    public DefaultComponentManagerApplicationContext() {
        this(null, null, null);
    }

    public DefaultComponentManagerApplicationContext(ContainerConfiguration containerConfiguration) {
        this(containerConfiguration, null);
    }

    public DefaultComponentManagerApplicationContext(ComponentManager componentManager) {
        this(componentManager, null, null);
    }

    public DefaultComponentManagerApplicationContext(ComponentManager componentManager, ContainerConfiguration containerConfiguration) {
        this(componentManager, containerConfiguration, null);
    }

    public DefaultComponentManagerApplicationContext(ContainerConfiguration containerConfiguration, ApplicationContext parentApplicationContext) {
        this(null, containerConfiguration, parentApplicationContext);
    }

    public DefaultComponentManagerApplicationContext(ComponentManager componentManager, ContainerConfiguration containerConfiguration, ApplicationContext parentApplicationContext) {
        super(parentApplicationContext);
        this.componentManager = componentManager;
        this.containerConfiguration = containerConfiguration;
        if (this.containerConfiguration != null && !this.containerConfiguration.isEmpty()) {
            Properties initProps = this.containerConfiguration.toProperties();
            OverridingByAttributesPropertyPlaceholderConfigurer ppc = new OverridingByAttributesPropertyPlaceholderConfigurer();
            ppc.setIgnoreUnresolvablePlaceholders(this.containerConfiguration.getBoolean(SpringComponentManager.IGNORE_UNRESOLVABLE_PLACE_HOLDERS, true));
            ppc.setSystemPropertiesMode(this.containerConfiguration.getInt(SpringComponentManager.SYSTEM_PROPERTIES_MODE, 1));
            ppc.setProperties(initProps);
            this.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
        }
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)this);
        if (this.componentManager != null && this.componentManager.getServletContext() != null) {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.componentManager.getServletContext(), this.componentManager.getServletConfig()));
            beanFactory.ignoreDependencyInterface(ServletContextAware.class);
            if (this.componentManager.getServletConfig() != null) {
                beanFactory.ignoreDependencyInterface(ServletConfigAware.class);
            }
            WebApplicationContextUtils.registerWebApplicationScopes((ConfigurableListableBeanFactory)beanFactory, (ServletContext)this.componentManager.getServletContext());
            WebApplicationContextUtils.registerEnvironmentBeans((ConfigurableListableBeanFactory)beanFactory, (ServletContext)this.componentManager.getServletContext(), (ServletConfig)this.componentManager.getServletConfig());
        }
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        if (this.containerConfiguration == null) {
            return super.createBeanFactory();
        }
        BeanFactory parentBeanFactory = this.getInternalParentBeanFactory();
        return new FilteringByExpressionListableBeanFactory(parentBeanFactory, this.containerConfiguration);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.componentManager != null && bean instanceof ComponentManagerAware) {
            ((ComponentManagerAware)bean).setComponentManager(this.componentManager);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

