/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ApplicationContextUtils {
    private static Logger log = LoggerFactory.getLogger(ApplicationContextUtils.class);

    private ApplicationContextUtils() {
    }

    public static String[] getCheckedLocationPatterns(ApplicationContext applicationContext, String[] locationPatterns) {
        ArrayList<String> existingLocationPatterns = new ArrayList<String>();
        if (locationPatterns != null) {
            for (String locationPattern : locationPatterns) {
                try {
                    applicationContext.getResources(locationPattern);
                    existingLocationPatterns.add(locationPattern);
                }
                catch (IOException e) {
                    log.debug("Ignoring resources on {}. It does not exist.", (Object)locationPattern);
                }
            }
        }
        return existingLocationPatterns.toArray(new String[existingLocationPatterns.size()]);
    }

    public static String[] getCheckedLocationPatterns(ApplicationContext applicationContext, List<String> locationPatterns) {
        return ApplicationContextUtils.getCheckedLocationPatterns(applicationContext, new ArrayList<String>(locationPatterns).toArray(new String[locationPatterns.size()]));
    }
}

