/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.site.addon.module.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.hippoecm.hst.addon.module.ModuleInstance;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.ComponentManagerAware;
import org.hippoecm.hst.core.container.ComponentsException;
import org.hippoecm.hst.site.addon.module.model.ModuleDefinition;
import org.hippoecm.hst.site.container.ApplicationContextUtils;
import org.hippoecm.hst.site.container.DefaultComponentManagerApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;

public class ModuleInstanceImpl
implements ModuleInstance,
ComponentManagerAware,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ModuleInstanceImpl.class);
    private ModuleDefinition moduleDefinition;
    private String name;
    private String fullName;
    private ApplicationContext parentApplicationContext;
    private AbstractRefreshableConfigApplicationContext applicationContext;
    private ComponentManager componentManager;
    private Map<String, ModuleInstance> childModuleInstancesMap;
    private List<ModuleInstance> childModuleInstancesList;

    public ModuleInstanceImpl(ModuleDefinition moduleDefinition) {
        this(moduleDefinition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleInstanceImpl(ModuleDefinition moduleDefinition, String[] namePrefixes) {
        this.moduleDefinition = moduleDefinition;
        this.name = this.moduleDefinition.getName();
        String[] mergedNamePrefixes = (String[])ArrayUtils.add((Object[])namePrefixes, (Object)this.name);
        this.fullName = ArrayUtils.toString((Object)mergedNamePrefixes);
        List<ModuleDefinition> childModuleDefinitions = this.moduleDefinition.getModuleDefinitions();
        if (childModuleDefinitions != null && !childModuleDefinitions.isEmpty()) {
            this.childModuleInstancesMap = Collections.synchronizedMap(new HashMap());
            for (ModuleDefinition childModuleDefinition : childModuleDefinitions) {
                ModuleInstanceImpl childModuleInstance = new ModuleInstanceImpl(childModuleDefinition, mergedNamePrefixes);
                this.childModuleInstancesMap.put(childModuleInstance.getName(), childModuleInstance);
            }
            Map<String, ModuleInstance> map = this.childModuleInstancesMap;
            synchronized (map) {
                this.childModuleInstancesList = Collections.synchronizedList(new ArrayList<ModuleInstance>(this.childModuleInstancesMap.values()));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public void setApplicationContext(ApplicationContext parentApplicationContext) throws BeansException {
        this.parentApplicationContext = parentApplicationContext;
    }

    public void initialize() {
        Object[] checkedConfigurationResources;
        this.applicationContext = new DefaultComponentManagerApplicationContext(this.componentManager.getContainerConfiguration(), this.parentApplicationContext);
        if (this.componentManager != null && this.applicationContext instanceof ComponentManagerAware) {
            ((ComponentManagerAware)this.applicationContext).setComponentManager(this.componentManager);
        }
        if (ArrayUtils.isEmpty((Object[])(checkedConfigurationResources = ApplicationContextUtils.getCheckedLocationPatterns((ApplicationContext)this.applicationContext, this.moduleDefinition.getConfigLocations())))) {
            log.warn("There's no valid component configuration for addon module, '{}'.", (Object)this.name);
        }
        this.applicationContext.setConfigLocations((String[])checkedConfigurationResources);
        this.applicationContext.refresh();
        for (ModuleInstance moduleInstance : this.getModuleInstances()) {
            if (this.componentManager != null && moduleInstance instanceof ComponentManagerAware) {
                ((ComponentManagerAware)moduleInstance).setComponentManager(this.componentManager);
            }
            if (this.componentManager != null && moduleInstance instanceof ApplicationContextAware) {
                ((ApplicationContextAware)moduleInstance).setApplicationContext((ApplicationContext)this.applicationContext);
            }
            moduleInstance.initialize();
        }
    }

    public void start() {
        this.applicationContext.start();
        for (ModuleInstance moduleInstance : this.getModuleInstances()) {
            moduleInstance.start();
        }
    }

    public void stop() {
        for (ModuleInstance moduleInstance : this.getModuleInstances()) {
            moduleInstance.stop();
        }
        this.applicationContext.stop();
    }

    public void close() {
        for (ModuleInstance moduleInstance : this.getModuleInstances()) {
            moduleInstance.close();
        }
        this.applicationContext.close();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public <T> T getComponent(String name) {
        Object bean = null;
        try {
            bean = this.applicationContext.getBean(name);
        }
        catch (Exception ignore) {
            log.warn("The requested bean doesn't exist: '{}'", (Object)name);
        }
        return (T)bean;
    }

    public <T> T getComponent(Class<T> requiredType) {
        Object bean = null;
        try {
            bean = this.applicationContext.getBean(requiredType);
        }
        catch (Exception ignore) {
            log.warn("The requested bean doesn't exist by the required type: '{}'", requiredType);
        }
        if (bean == null) {
            throw new ComponentsException("No component found, not exactly matching a single component by the specified type, " + requiredType);
        }
        return (T)bean;
    }

    public <T> Map<String, T> getComponentsOfType(Class<T> requiredType) {
        Map beansMap = Collections.emptyMap();
        try {
            beansMap = this.applicationContext.getBeansOfType(requiredType);
        }
        catch (Exception ignore) {
            log.warn("The requested bean doesn't exist: '{}'", (Object)this.name);
        }
        return beansMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModuleInstance> getModuleInstances() {
        if (this.childModuleInstancesList == null) {
            return Collections.emptyList();
        }
        ArrayList<ModuleInstance> moduleInstances = null;
        List<ModuleInstance> list = this.childModuleInstancesList;
        synchronized (list) {
            moduleInstances = new ArrayList<ModuleInstance>(this.childModuleInstancesList);
        }
        return moduleInstances;
    }

    public ModuleInstance getModuleInstance(String name) {
        if (this.childModuleInstancesMap == null) {
            return null;
        }
        return this.childModuleInstancesMap.get(name);
    }
}

