/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.proxy.Invoker;

public class DynaBeanMethodInvoker
implements Invoker,
Serializable {
    private static final long serialVersionUID = 1L;
    private DynaBean dynaBean;

    public DynaBeanMethodInvoker(DynaBean dynaBean) {
        this.dynaBean = dynaBean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        if (methodName.startsWith("get")) {
            String propName = DynaBeanMethodInvoker.getCamelString(methodName.substring(3));
            if (paramTypes.length == 0) {
                return this.dynaBean.get(propName);
            }
            if (paramTypes.length != 1) throw new UnsupportedOperationException("No getter for " + propName + " with " + paramTypes.length + " parameters.");
            if (paramTypes[0] == Integer.TYPE || paramTypes[0] == Integer.class) {
                return this.dynaBean.get(propName, ((Integer)args[0]).intValue());
            }
            if (paramTypes[0] != String.class) throw new UnsupportedOperationException("No getter for " + propName + " with " + paramTypes[0] + " type.");
            return this.dynaBean.get(propName, (String)args[0]);
        }
        if (methodName.startsWith("is") && paramTypes.length == 0 && (returnType == Boolean.TYPE || returnType == Boolean.class)) {
            String propName = DynaBeanMethodInvoker.getCamelString(methodName.substring(2));
            return this.dynaBean.get(propName);
        }
        if (!methodName.startsWith("set")) return MethodUtils.invokeMethod((Object)this.dynaBean, (String)methodName, (Object[])args);
        String propName = DynaBeanMethodInvoker.getCamelString(methodName.substring(3));
        if (paramTypes.length == 1) {
            this.dynaBean.set(propName, args[0]);
            return null;
        } else {
            if (paramTypes.length != 2) throw new UnsupportedOperationException("No setter for " + propName + " with " + paramTypes.length + " parameters.");
            if (paramTypes[0] == Integer.TYPE || paramTypes[0] == Integer.class) {
                this.dynaBean.set(propName, ((Integer)args[0]).intValue(), args[1]);
                return null;
            } else {
                if (paramTypes[0] != String.class) throw new UnsupportedOperationException("No setter for " + propName + " with " + paramTypes[1] + " type.");
                this.dynaBean.set(propName, (String)args[0], args[1]);
            }
        }
        return null;
    }

    private static String getCamelString(String s) {
        char firstChar = s.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            StringBuilder sb = new StringBuilder(s);
            sb.setCharAt(0, Character.toLowerCase(firstChar));
            s = sb.toString();
        }
        return s;
    }
}

