/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.webfiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhitelistReader {
    private static final Logger log = LoggerFactory.getLogger(WhitelistReader.class);
    private final Set<String> whitelist = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WhitelistReader(InputStream is) {
        try {
            List list = IOUtils.readLines((InputStream)is, (String)"UTF-8");
            for (String line : list) {
                int hashIndex;
                if (StringUtils.isBlank((String)line) || (hashIndex = line.indexOf(35)) == 0) continue;
                if (hashIndex > 0) {
                    String beforeComment = line.substring(0, hashIndex);
                    if (StringUtils.isBlank((String)beforeComment)) continue;
                    this.whitelist.add(beforeComment);
                    continue;
                }
                this.whitelist.add(line);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Could not read InputStream due to wrong encoding. Return empty whitelist", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Error during reading InputStream. Return empty whitelist", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }
}

