/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.util;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class PropertyParser {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    public static final String DEFAULT_VALUE_SEPARATOR = null;
    public static final boolean DEFAULT_IGNORE_UNRESOLVABLE_PLACEHOLDERS = false;
    private static final Logger log = LoggerFactory.getLogger(PropertyParser.class);
    private static final PropertyPlaceholderHelper DEFAULT_PROPERTY_PLACE_HOLDER_HELPER = new PropertyPlaceholderHelper("${", "}", DEFAULT_VALUE_SEPARATOR, false);
    private Properties properties;
    private String placeHolderPrefix;
    private String placeHolderSuffix;
    private String valueSeparator;
    private boolean ignoreUnresolvablePlaceholders;
    private PropertyPlaceholderHelper propertyPlaceHolderHelper;
    private PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver;

    public PropertyParser(Properties properties) {
        this(properties, DEFAULT_PLACEHOLDER_PREFIX, DEFAULT_PLACEHOLDER_SUFFIX, DEFAULT_VALUE_SEPARATOR, false);
    }

    public PropertyParser(Properties properties, String placeHolderPrefix, String placeHolderSuffix, String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        this.properties = properties;
        this.placeHolderPrefix = placeHolderPrefix;
        this.placeHolderSuffix = placeHolderSuffix;
        this.valueSeparator = valueSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
        this.propertyPlaceHolderHelper = StringUtils.equals((String)DEFAULT_PLACEHOLDER_PREFIX, (String)this.placeHolderPrefix) && StringUtils.equals((String)DEFAULT_PLACEHOLDER_SUFFIX, (String)this.placeHolderSuffix) && StringUtils.equals((String)DEFAULT_VALUE_SEPARATOR, (String)this.valueSeparator) && false == this.ignoreUnresolvablePlaceholders ? DEFAULT_PROPERTY_PLACE_HOLDER_HELPER : new PropertyPlaceholderHelper(this.placeHolderPrefix, this.placeHolderSuffix, this.valueSeparator, this.ignoreUnresolvablePlaceholders);
    }

    public void setPlaceholderResolver(PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
        this.placeholderResolver = placeholderResolver;
    }

    public Object resolveProperty(String name, Object o) {
        if (o == null) {
            return null;
        }
        if (this.placeholderResolver == null && this.properties != null) {
            this.placeholderResolver = new PropertyPlaceholderHelper.PlaceholderResolver(){

                public String resolvePlaceholder(String placeholderName) {
                    return PropertyParser.this.properties.getProperty(placeholderName);
                }
            };
        }
        if (this.placeholderResolver == null) {
            return o;
        }
        if (o instanceof String) {
            String s = (String)o;
            try {
                s = this.propertyPlaceHolderHelper.replacePlaceholders((String)o, this.placeholderResolver);
            }
            catch (IllegalArgumentException e) {
                log.debug("Unable to replace property expression for property '" + name + "'. Return null.", (Throwable)e);
                return null;
            }
            return s;
        }
        if (o instanceof String[]) {
            String[] unparsed = (String[])o;
            String[] parsed = new String[unparsed.length];
            for (int i = 0; i < unparsed.length; ++i) {
                String s = unparsed[i];
                try {
                    s = this.propertyPlaceHolderHelper.replacePlaceholders(unparsed[i], this.placeholderResolver);
                }
                catch (IllegalArgumentException e) {
                    log.debug("Unable to replace property expression for property '" + name + "'. Return null.", (Throwable)e);
                    s = null;
                }
                parsed[i] = s;
            }
            return parsed;
        }
        return o;
    }
}

