/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public class PathEncoder {
    private PathEncoder() {
    }

    public static String encode(String pathInfo, String characterEncoding) throws UnsupportedEncodingException {
        return PathEncoder.encode(pathInfo, characterEncoding, null);
    }

    public static String encode(String pathInfo, String characterEncoding, String[] ignorePrefixes) throws UnsupportedEncodingException {
        if (pathInfo == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String pathInfoToEncode = pathInfo;
        if (ignorePrefixes != null) {
            for (String ignorePrefix : ignorePrefixes) {
                if (!pathInfo.startsWith(ignorePrefix)) continue;
                builder.append(ignorePrefix);
                pathInfoToEncode = pathInfoToEncode.substring(ignorePrefix.length());
                break;
            }
        }
        String[] unencodedPaths = StringUtils.splitPreserveAllTokens((String)pathInfoToEncode, (char)'/');
        for (int i = 0; i < unencodedPaths.length; ++i) {
            String path = unencodedPaths[i];
            if (path.indexOf(35) != -1) {
                String[] hashParts = StringUtils.splitPreserveAllTokens((String)path, (char)'#');
                String afterHash = "";
                if (hashParts.length > 2) {
                    for (int j = 1; j < hashParts.length; ++j) {
                        afterHash = afterHash + hashParts[j];
                        if (j >= hashParts.length - 1) continue;
                        afterHash = afterHash + "#";
                    }
                } else {
                    afterHash = hashParts[1];
                }
                if (hashParts[0].indexOf(63) != -1) {
                    String[] parameterParts = StringUtils.splitPreserveAllTokens((String)hashParts[0], (char)'?');
                    builder.append(URLEncoder.encode(parameterParts[0], characterEncoding)).append('?').append(parameterParts[1]).append('#').append(URLEncoder.encode(afterHash, characterEncoding));
                } else {
                    builder.append(URLEncoder.encode(hashParts[0], characterEncoding)).append('#').append(URLEncoder.encode(afterHash, characterEncoding));
                }
            } else if (path.indexOf(63) != -1) {
                String[] parameterParts = StringUtils.splitPreserveAllTokens((String)path, (char)'?');
                builder.append(URLEncoder.encode(parameterParts[0], characterEncoding)).append('?').append(parameterParts[1]);
            } else {
                builder.append(URLEncoder.encode(path, characterEncoding));
            }
            if (i == unencodedPaths.length - 1) continue;
            builder.append('/');
        }
        return builder.toString();
    }
}

