/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.hippoecm.hst.util.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializerImpl
implements JsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(JsonSerializerImpl.class);

    public String toJson(Object value) {
        try {
            return new ObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            if (log.isDebugEnabled()) {
                log.warn("Could not serialize value to JSON", (Throwable)e);
            } else {
                log.warn("Could not serialize value to JSON: {}", (Object)e.toString());
            }
            throw new JsonSerializer.JsonSerializationException("Could not serialize value to JSON", (Throwable)e);
        }
    }
}

