/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.hippoecm.hst.util.DOMElementWriter;
import org.w3c.dom.Element;

public class DOMUtils {
    public static final int DEFAULT_ELEMENT_STRINGIFYING_BUFFER_SIZE = 80;
    public static final int DEFAULT_INDENT = 0;
    public static final String DEFAULT_INDENT_WITH = "\t";

    private DOMUtils() {
    }

    public static String stringifyElement(Element element) {
        return DOMUtils.stringifyElement(element, 80, 0, DEFAULT_INDENT_WITH);
    }

    public static String stringifyElement(Element element, int initialBufferSize, int indent, String indentWith) {
        String stringified = null;
        StringWriter writer = new StringWriter(initialBufferSize);
        try {
            DOMElementWriter domWriter = new DOMElementWriter();
            domWriter.write(element, (Writer)writer, indent, indentWith);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stringified = writer.toString();
        return stringified;
    }

    public static String stringifyElementToHtml(Element element) {
        return DOMUtils.stringifyElement(element);
    }

    public static String getIdAttribute(Element element) {
        String value = null;
        if (element != null) {
            if (element.hasAttribute("id")) {
                value = element.getAttribute("id");
            } else if (element.hasAttribute("ID")) {
                value = element.getAttribute("ID");
            } else if (element.hasAttribute("Id")) {
                value = element.getAttribute("Id");
            } else if (element.hasAttribute("iD")) {
                value = element.getAttribute("iD");
            }
        }
        return value;
    }
}

