/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemenu;

import java.util.HashMap;
import java.util.Map;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenusConfiguration;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.sitemenu.HstSiteMenu;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuImpl;
import org.hippoecm.hst.core.sitemenu.HstSiteMenus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMenusImpl
implements HstSiteMenus {
    private static final Logger log = LoggerFactory.getLogger(HstSiteMenusImpl.class);
    private static final long serialVersionUID = 1L;
    private Map<String, HstSiteMenu> siteMenus = new HashMap<String, HstSiteMenu>();

    public HstSiteMenusImpl(HstRequestContext hstRequestContext) {
        if (hstRequestContext.getResolvedSiteMapItem() == null) {
            log.info("'{}' does not resolve to a siteMap item hence no siteMenus can be provided", (Object)hstRequestContext.getServletRequest());
            return;
        }
        HstSiteMapItem selectedSiteMapItem = hstRequestContext.getResolvedSiteMapItem().getHstSiteMapItem();
        HstSiteMenusConfiguration siteMenusConfiguration = selectedSiteMapItem.getHstSiteMap().getSite().getSiteMenusConfiguration();
        if (siteMenusConfiguration != null) {
            for (HstSiteMenuConfiguration siteMenuConfiguration : siteMenusConfiguration.getSiteMenuConfigurations().values()) {
                HstSiteMenuImpl siteMenu = new HstSiteMenuImpl(this, siteMenuConfiguration, hstRequestContext);
                this.siteMenus.put(siteMenu.getName(), siteMenu);
            }
        }
    }

    public HstSiteMenu getSiteMenu(String name) {
        return this.siteMenus.get(name);
    }

    public Map<String, HstSiteMenu> getSiteMenus() {
        return this.siteMenus;
    }
}

