/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemenu;

import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuItemConfiguration;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMenuUtils {
    private static final Logger log = LoggerFactory.getLogger(HstSiteMenuUtils.class);

    private HstSiteMenuUtils() {
    }

    public static boolean isUserInRole(HstSiteMenuItemConfiguration hstSiteMenuItemConfiguration, HstRequestContext hstRequestContext) {
        for (String role : hstSiteMenuItemConfiguration.getRoles()) {
            if (!hstRequestContext.getServletRequest().isUserInRole(role)) continue;
            log.debug("Found HstSiteMenuItemConfiguration '{}' to be in role '{}'", (Object)hstSiteMenuItemConfiguration.getName(), (Object)role);
            return true;
        }
        log.debug("No matching role found for HstSiteMenuItemConfiguration '{}'", (Object)hstSiteMenuItemConfiguration.getName());
        return false;
    }
}

