/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemenu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuItemConfiguration;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.linking.HstLinkCreator;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.sitemenu.AbstractMenuItem;
import org.hippoecm.hst.core.sitemenu.HstSiteMenu;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuImpl;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuItem;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuUtils;
import org.hippoecm.hst.core.util.PropertyParser;
import org.hippoecm.hst.util.HstSiteMapUtils;
import org.hippoecm.hst.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMenuItemImpl
extends AbstractMenuItem
implements HstSiteMenuItem {
    private static Logger log = LoggerFactory.getLogger(HstSiteMenuItemImpl.class);
    private HstSiteMenu hstSiteMenu;
    private List<HstSiteMenuItem> hstSiteMenuItems = new ArrayList<HstSiteMenuItem>();
    private HstSiteMenuItem parent;
    private HstLinkCreator linkCreator;
    private ResolvedSiteMapItem resolvedSiteMapItem;
    private HstSiteMenuItemConfiguration hstSiteMenuItemConfiguration;
    private String hstSiteMapItemRefId;
    private String hstSiteMapItemPath;
    private String externalLink;
    private Mount targetMount;

    public HstSiteMenuItemImpl(HstSiteMenu hstSiteMenu, HstSiteMenuItem parent, HstSiteMenuItemConfiguration hstSiteMenuItemConfiguration, HstRequestContext hstRequestContext) {
        this.hstSiteMenu = hstSiteMenu;
        this.parent = parent;
        this.hstSiteMenuItemConfiguration = hstSiteMenuItemConfiguration;
        this.externalLink = hstSiteMenuItemConfiguration.getExternalLink();
        this.linkCreator = hstRequestContext.getHstLinkCreator();
        this.name = hstSiteMenuItemConfiguration.getName();
        this.depth = hstSiteMenuItemConfiguration.getDepth();
        this.repositoryBased = hstSiteMenuItemConfiguration.isRepositoryBased();
        this.properties = hstSiteMenuItemConfiguration.getProperties();
        if (hstSiteMenuItemConfiguration.getMountAlias() != null) {
            this.targetMount = hstRequestContext.getMount(hstSiteMenuItemConfiguration.getMountAlias());
            if (this.targetMount == null) {
                log.warn("Cannot create links for sitemenu item '" + this.name + "' of menu '" + hstSiteMenu.getName() + "' because could not lookup mount with alias '{}' for current mount '{}'", (Object)hstSiteMenuItemConfiguration.getMountAlias(), (Object)hstRequestContext.getResolvedMount().getMount());
            }
        } else {
            this.targetMount = hstRequestContext.getResolvedMount().getMount();
        }
        String siteMapItemRefIdOrPath = PathUtils.normalizePath((String)hstSiteMenuItemConfiguration.getSiteMapItemPath());
        if (this.targetMount != null) {
            HstSiteMapItem siteMapItemByRefId = this.targetMount.getHstSite().getSiteMap().getSiteMapItemByRefId(siteMapItemRefIdOrPath);
            if (siteMapItemByRefId != null) {
                this.hstSiteMapItemRefId = siteMapItemRefIdOrPath;
                this.hstSiteMapItemPath = HstSiteMapUtils.getPath((HstSiteMapItem)siteMapItemByRefId);
                log.debug("sitemapitem of sitemenu, '{}', found by refid, '{}'. sitemapitem path: " + this.hstSiteMapItemPath, (Object)this.name, (Object)siteMapItemRefIdOrPath);
            } else {
                this.hstSiteMapItemPath = siteMapItemRefIdOrPath;
                log.debug("sitemapitem of sitemenu, '{}', will be found by path, '{}'.", (Object)this.name, (Object)siteMapItemRefIdOrPath);
            }
        }
        boolean menuVisibleRegardlessRoles = hstRequestContext.isCmsRequest() && hstRequestContext.getResolvedMount().getMount().getVirtualHost().getVirtualHosts().isChannelMngrSiteAuthenticationSkipped();
        for (HstSiteMenuItemConfiguration childItemConfiguration : hstSiteMenuItemConfiguration.getChildItemConfigurations()) {
            if (childItemConfiguration.getRoles() == null || menuVisibleRegardlessRoles) {
                this.hstSiteMenuItems.add(new HstSiteMenuItemImpl(hstSiteMenu, this, childItemConfiguration, hstRequestContext));
                continue;
            }
            if (!HstSiteMenuUtils.isUserInRole(childItemConfiguration, hstRequestContext)) continue;
            this.hstSiteMenuItems.add(new HstSiteMenuItemImpl(hstSiteMenu, this, childItemConfiguration, hstRequestContext));
        }
        this.resolvedSiteMapItem = hstRequestContext.getResolvedSiteMapItem();
        String currentPathInfo = this.resolvedSiteMapItem.getPathInfo();
        if (this.hstSiteMapItemPath != null && currentPathInfo != null) {
            String sub;
            if (this.hstSiteMapItemPath.equals(currentPathInfo)) {
                this.selected = true;
                ((HstSiteMenuImpl)hstSiteMenu).setSelectedSiteMenuItem(this);
            }
            if (currentPathInfo.startsWith(this.hstSiteMapItemPath) && ("".equals(sub = currentPathInfo.substring(this.hstSiteMapItemPath.length())) || sub.startsWith("/"))) {
                this.expanded = true;
                if (this.parent == null) {
                    ((HstSiteMenuImpl)this.hstSiteMenu).setExpanded();
                } else {
                    ((HstSiteMenuItemImpl)this.parent).setExpanded();
                }
            }
        }
    }

    public List<HstSiteMenuItem> getChildMenuItems() {
        return this.hstSiteMenuItems;
    }

    public HstLink getHstLink() {
        if (this.targetMount == null) {
            log.warn("Cannot create link for sitemenu item '{}' of menu '{}' because target mount is null. Return null", (Object)this.name, (Object)this.hstSiteMenu.getName());
            return null;
        }
        if (this.hstSiteMapItemRefId != null) {
            return this.linkCreator.createByRefId(this.hstSiteMapItemRefId, this.targetMount);
        }
        if (this.hstSiteMapItemPath != null) {
            return this.linkCreator.create(this.hstSiteMapItemPath, this.targetMount);
        }
        if (this.externalLink == null) {
            log.debug("Sitemenu item '{}' of menu '{}' does not contain an hstSiteMapItemRefId, an hstSiteMapItemPath or an externalLink. Cannot create link for sitemenu item, return null", (Object)this.name, (Object)this.hstSiteMenu.getName());
        }
        return null;
    }

    public String getExternalLink() {
        return this.externalLink;
    }

    public HstSiteMenuItem getParentItem() {
        return this.parent;
    }

    public void setExpanded() {
        this.expanded = true;
        if (this.parent == null) {
            ((HstSiteMenuImpl)this.hstSiteMenu).setExpanded();
        } else {
            ((HstSiteMenuItemImpl)this.parent).setExpanded();
        }
    }

    public HstSiteMenu getHstSiteMenu() {
        return this.hstSiteMenu;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isRepositoryBased() {
        return this.repositoryBased;
    }

    public HstSiteMenuItem getDeepestExpandedItem() {
        for (HstSiteMenuItem item : this.hstSiteMenuItems) {
            if (!item.isExpanded()) continue;
            return ((HstSiteMenuItemImpl)item).getDeepestExpandedItem();
        }
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        PropertyParser pp = new PropertyParser(this.resolvedSiteMapItem.getParameters());
        for (Map.Entry entry : this.hstSiteMenuItemConfiguration.getParameters().entrySet()) {
            String parsedParamValue = (String)pp.resolveProperty((String)entry.getKey(), entry.getValue());
            parameters.put((String)entry.getKey(), parsedParamValue);
        }
        return parameters;
    }

    public String getParameter(String name) {
        String paramValue = this.hstSiteMenuItemConfiguration.getParameter(name);
        PropertyParser pp = new PropertyParser(this.resolvedSiteMapItem.getParameters());
        String parsedParamValue = (String)pp.resolveProperty(name, paramValue);
        return parsedParamValue;
    }

    public Map<String, String> getLocalParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        PropertyParser pp = new PropertyParser(this.resolvedSiteMapItem.getParameters());
        for (Map.Entry entry : this.hstSiteMenuItemConfiguration.getLocalParameters().entrySet()) {
            String parsedParamValue = (String)pp.resolveProperty((String)entry.getKey(), entry.getValue());
            parameters.put((String)entry.getKey(), parsedParamValue);
        }
        return parameters;
    }

    public String getLocalParameter(String name) {
        String paramValue = this.hstSiteMenuItemConfiguration.getLocalParameter(name);
        PropertyParser pp = new PropertyParser(this.resolvedSiteMapItem.getParameters());
        String parsedParamValue = (String)pp.resolveProperty(name, paramValue);
        return parsedParamValue;
    }
}

