/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemenu;

import java.util.ArrayList;
import java.util.List;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuItemConfiguration;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.sitemenu.AbstractMenu;
import org.hippoecm.hst.core.sitemenu.EditableMenu;
import org.hippoecm.hst.core.sitemenu.EditableMenuImpl;
import org.hippoecm.hst.core.sitemenu.HstSiteMenu;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuItem;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuItemImpl;
import org.hippoecm.hst.core.sitemenu.HstSiteMenuUtils;
import org.hippoecm.hst.core.sitemenu.HstSiteMenus;

public class HstSiteMenuImpl
extends AbstractMenu
implements HstSiteMenu {
    private static final long serialVersionUID = 1L;
    private HstSiteMenus hstSiteMenus;
    private List<HstSiteMenuItem> hstSiteMenuItems = new ArrayList<HstSiteMenuItem>();
    private HstSiteMenuItem selectedSiteMenuItem;

    public HstSiteMenuImpl(HstSiteMenus hstSiteMenus, HstSiteMenuConfiguration siteMenuConfiguration, HstRequestContext hstRequestContext) {
        this.hstSiteMenus = hstSiteMenus;
        this.name = siteMenuConfiguration.getName();
        boolean menuVisibleRegardlessRoles = hstRequestContext.isCmsRequest() && hstRequestContext.getResolvedMount().getMount().getVirtualHost().getVirtualHosts().isChannelMngrSiteAuthenticationSkipped();
        for (HstSiteMenuItemConfiguration hstSiteMenuItemConfiguration : siteMenuConfiguration.getSiteMenuConfigurationItems()) {
            if (hstSiteMenuItemConfiguration.getRoles() == null || menuVisibleRegardlessRoles) {
                this.hstSiteMenuItems.add(new HstSiteMenuItemImpl(this, null, hstSiteMenuItemConfiguration, hstRequestContext));
                continue;
            }
            if (!HstSiteMenuUtils.isUserInRole(hstSiteMenuItemConfiguration, hstRequestContext)) continue;
            this.hstSiteMenuItems.add(new HstSiteMenuItemImpl(this, null, hstSiteMenuItemConfiguration, hstRequestContext));
        }
    }

    public List<HstSiteMenuItem> getSiteMenuItems() {
        return this.hstSiteMenuItems;
    }

    public HstSiteMenus getHstSiteMenus() {
        return this.hstSiteMenus;
    }

    public HstSiteMenuItem getSelectSiteMenuItem() {
        return this.selectedSiteMenuItem;
    }

    public void setSelectedSiteMenuItem(HstSiteMenuItem selectedSiteMenuItem) {
        this.selectedSiteMenuItem = selectedSiteMenuItem;
    }

    public void setExpanded() {
        this.expanded = true;
    }

    public HstSiteMenuItem getDeepestExpandedItem() {
        if (this.selectedSiteMenuItem != null) {
            return this.selectedSiteMenuItem;
        }
        if (!this.expanded) {
            return null;
        }
        for (HstSiteMenuItem item : this.hstSiteMenuItems) {
            if (!item.isExpanded()) continue;
            return ((HstSiteMenuItemImpl)item).getDeepestExpandedItem();
        }
        return null;
    }

    public EditableMenu getEditableMenu() {
        return new EditableMenuImpl((HstSiteMenu)this);
    }
}

