/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemapitemhandler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandler;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteMapItemHandlerRegistryImpl
implements HstSiteMapItemHandlerRegistry {
    static Logger log = LoggerFactory.getLogger(HstSiteMapItemHandlerRegistryImpl.class);
    protected Map<HstContainerConfig, Map<String, HstSiteMapItemHandlerHolder>> servletConfigSiteMapItemHandlersMap = Collections.synchronizedMap(new HashMap());

    public HstSiteMapItemHandler getSiteMapItemHandler(HstContainerConfig requestContainerConfig, String handlerId) {
        HstSiteMapItemHandlerHolder holder = this.getServletConfigSiteMapItemHandlersMap(requestContainerConfig, true).get(handlerId);
        if (holder != null) {
            return holder.getHstSiteMapItemHandler();
        }
        return null;
    }

    public void registerSiteMapItemHandler(HstContainerConfig requestContainerConfig, String handlerId, HstSiteMapItemHandler hstSiteMapItemHandler) {
        this.getServletConfigSiteMapItemHandlersMap(requestContainerConfig, true).put(handlerId, new HstSiteMapItemHandlerHolder(hstSiteMapItemHandler));
    }

    public void unregisterSiteMapItemHandler(HstContainerConfig requestContainerConfig, String handlerId) {
        block4: {
            HstSiteMapItemHandlerHolder holder = this.getServletConfigSiteMapItemHandlersMap(requestContainerConfig, true).remove(handlerId);
            if (holder != null) {
                try {
                    holder.getHstSiteMapItemHandler().destroy();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Exception occurred during destroying component: {}", (Object)e.toString(), (Object)e);
                    }
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Exception occurred during destroying component: {}", (Object)e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllSiteMapItemHandlers() {
        if (this.servletConfigSiteMapItemHandlersMap.isEmpty()) {
            return;
        }
        Map copiedMap = Collections.synchronizedMap(new HashMap());
        Iterator iterator = this.servletConfigSiteMapItemHandlersMap;
        synchronized (iterator) {
            for (HstContainerConfig requestContainerConfig : this.servletConfigSiteMapItemHandlersMap.keySet()) {
                copiedMap.put(requestContainerConfig, new HashMap());
            }
        }
        for (HstContainerConfig requestContainerConfig : copiedMap.keySet()) {
            Map<String, HstSiteMapItemHandlerHolder> siteMapItemHandlersMap = this.getServletConfigSiteMapItemHandlersMap(requestContainerConfig, false);
            if (siteMapItemHandlersMap == null) continue;
            HashMap<String, HstSiteMapItemHandlerHolder> copiedCompMap = new HashMap<String, HstSiteMapItemHandlerHolder>();
            Map<String, HstSiteMapItemHandlerHolder> map = siteMapItemHandlersMap;
            synchronized (map) {
                for (Map.Entry<String, HstSiteMapItemHandlerHolder> compEntry : siteMapItemHandlersMap.entrySet()) {
                    copiedCompMap.put(compEntry.getKey(), compEntry.getValue());
                }
            }
            copiedMap.put(requestContainerConfig, copiedCompMap);
        }
        for (Map.Entry entry : copiedMap.entrySet()) {
            for (Map.Entry compEntry : ((Map)entry.getValue()).entrySet()) {
                this.unregisterSiteMapItemHandler((HstContainerConfig)entry.getKey(), (String)compEntry.getKey());
            }
        }
        this.servletConfigSiteMapItemHandlersMap.clear();
    }

    protected Map<String, HstSiteMapItemHandlerHolder> getServletConfigSiteMapItemHandlersMap(HstContainerConfig requestContainerConfig, boolean create) {
        Map<String, HstSiteMapItemHandlerHolder> siteMapItemHandlersMap = this.servletConfigSiteMapItemHandlersMap.get(requestContainerConfig);
        if (siteMapItemHandlersMap == null && create) {
            siteMapItemHandlersMap = Collections.synchronizedMap(new HashMap());
            this.servletConfigSiteMapItemHandlersMap.put(requestContainerConfig, siteMapItemHandlersMap);
        }
        return this.servletConfigSiteMapItemHandlersMap.get(requestContainerConfig);
    }

    private static class HstSiteMapItemHandlerHolder {
        private HstSiteMapItemHandler hstSiteMapItemHandler;

        private HstSiteMapItemHandlerHolder(HstSiteMapItemHandler hstSiteMapItemHandler) {
            this.hstSiteMapItemHandler = hstSiteMapItemHandler;
        }

        public HstSiteMapItemHandler getHstSiteMapItemHandler() {
            return this.hstSiteMapItemHandler;
        }
    }
}

