/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.sitemapitemhandler;

import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlerConfiguration;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.request.SiteMapItemHandlerConfiguration;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandler;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerException;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerFactory;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerRegistry;
import org.hippoecm.hst.site.request.SiteMapItemHandlerConfigurationImpl;

public class HstSiteMapItemHandlerFactoryImpl
implements HstSiteMapItemHandlerFactory {
    protected HstSiteMapItemHandlerRegistry siteMapItemHandlerRegistry;

    public HstSiteMapItemHandlerFactoryImpl(HstSiteMapItemHandlerRegistry siteMapItemHandlerRegistry) {
        this.siteMapItemHandlerRegistry = siteMapItemHandlerRegistry;
    }

    public HstSiteMapItemHandler getSiteMapItemHandlerInstance(HstContainerConfig requestContainerConfig, HstSiteMapItemHandlerConfiguration handlerConfig) throws HstSiteMapItemHandlerException {
        String handlerId = handlerConfig.getId() + handlerConfig.hashCode();
        HstSiteMapItemHandler handler = this.siteMapItemHandlerRegistry.getSiteMapItemHandler(requestContainerConfig, handlerId);
        if (handler == null) {
            boolean initialized = false;
            String siteMapItemHandlerClassName = handlerConfig.getSiteMapItemHandlerClassName();
            ClassLoader containerClassloader = requestContainerConfig.getContextClassLoader();
            ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> handlerClass;
                if (containerClassloader != currentClassloader) {
                    Thread.currentThread().setContextClassLoader(containerClassloader);
                }
                if (!HstSiteMapItemHandler.class.isAssignableFrom(handlerClass = containerClassloader.loadClass(siteMapItemHandlerClassName))) {
                    throw new HstSiteMapItemHandlerException("Cannot instantiate HstSiteMapItemHandler: The class '" + siteMapItemHandlerClassName + "' of '" + handlerId + "' is not a subtype of '" + HstSiteMapItemHandler.class.getName() + "'. ");
                }
                handler = (HstSiteMapItemHandler)handlerClass.newInstance();
                SiteMapItemHandlerConfigurationImpl handlerConfigImpl = new SiteMapItemHandlerConfigurationImpl(handlerConfig);
                handler.init(requestContainerConfig.getServletContext(), (SiteMapItemHandlerConfiguration)handlerConfigImpl);
                initialized = true;
            }
            catch (ClassNotFoundException e) {
                throw new HstSiteMapItemHandlerException("Cannot find the class of " + handlerId + ": " + siteMapItemHandlerClassName);
            }
            catch (InstantiationException e) {
                throw new HstSiteMapItemHandlerException("Cannot instantiate the class of " + handlerId + ": " + siteMapItemHandlerClassName);
            }
            catch (IllegalAccessException e) {
                throw new HstSiteMapItemHandlerException("Illegal access to the class of " + handlerId + ": " + siteMapItemHandlerClassName);
            }
            finally {
                if (containerClassloader != currentClassloader) {
                    Thread.currentThread().setContextClassLoader(currentClassloader);
                }
            }
            if (initialized) {
                this.siteMapItemHandlerRegistry.registerSiteMapItemHandler(requestContainerConfig, handlerId, handler);
            }
        }
        return handler;
    }
}

