/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.search;

import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.query.HstQueryManager;
import org.hippoecm.hst.content.beans.query.HstQueryManagerImpl;
import org.hippoecm.hst.core.search.HstQueryManagerFactory;
import org.hippoecm.repository.util.DateTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstQueryManagerFactoryImpl
implements HstQueryManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(HstQueryManagerFactoryImpl.class);
    private String defaultQueryDateRangeResolution;

    public HstQueryManager createQueryManager(Session session, ObjectConverter objectConverter) {
        DateTools.Resolution resolution = this.fromString(this.defaultQueryDateRangeResolution);
        log.info("Default query date range resolution is : {}", (Object)resolution);
        HstQueryManagerImpl mngr = new HstQueryManagerImpl(session, objectConverter, resolution);
        return mngr;
    }

    public void setDefaultQueryDateRangeResolution(String defaultQueryDateRangeResolution) {
        this.defaultQueryDateRangeResolution = defaultQueryDateRangeResolution;
    }

    private DateTools.Resolution fromString(String resolution) {
        if (resolution == null || StringUtils.isEmpty((String)resolution)) {
            return DateTools.Resolution.MILLISECOND;
        }
        if ((resolution = resolution.toLowerCase().trim()).equals("year")) {
            return DateTools.Resolution.YEAR;
        }
        if (resolution.equals("month")) {
            return DateTools.Resolution.MONTH;
        }
        if (resolution.equals("day")) {
            return DateTools.Resolution.DAY;
        }
        if (resolution.equals("hour")) {
            return DateTools.Resolution.HOUR;
        }
        log.warn("Unknown resolution '{}'. Return MILLISECOND resolution.", (Object)resolution);
        return DateTools.Resolution.MILLISECOND;
    }
}

