/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.order;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.core.order.ObjectOrdererRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectOrderer<T> {
    public static final String REQUISITES_SEPARATOR_CHARS = " ,\t\r\n";
    private static Logger log = LoggerFactory.getLogger(ObjectOrderer.class);
    private final String objectOrderingName;
    private List<OrderableObjectHolder<T>> orderableObjectHolderList = null;
    private Map<String, OrderableObjectHolder<T>> orderableObjectHolderMap = null;
    private Map<OrderableObjectHolder<T>, Node<T>> nodeMap = null;
    private Node<T> leaderNode;
    private Node<T> trailerNode;
    private boolean ignoreExceptions;

    public ObjectOrderer(String objectOrderingName) {
        this.objectOrderingName = objectOrderingName;
    }

    public boolean isIgnoreExceptions() {
        return this.ignoreExceptions;
    }

    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }

    public void add(T object, String objectName, String prerequisites, String postrequisites) {
        OrderableObjectHolder<T> o;
        if (this.orderableObjectHolderMap == null) {
            this.orderableObjectHolderMap = new HashMap<String, OrderableObjectHolder<T>>();
            this.orderableObjectHolderList = new ArrayList<OrderableObjectHolder<T>>();
        }
        if ((o = this.getOrderableObjectHolder(objectName)) != null) {
            log.error("Duplicate object by name, '{}'. Original object: {}", (Object)objectName, o.getObject());
            return;
        }
        o = new OrderableObjectHolder<T>(object, objectName, prerequisites, postrequisites);
        this.orderableObjectHolderMap.put(objectName, o);
        this.orderableObjectHolderList.add(o);
    }

    public List<T> getOrderedObjects() {
        if (this.orderableObjectHolderMap == null) {
            return Collections.emptyList();
        }
        try {
            this.nodeMap = new HashMap<OrderableObjectHolder<T>, Node<T>>();
            this.initializeGraph();
            List<T> list = this.trailerNode.getOrder();
            return list;
        }
        finally {
            this.nodeMap = null;
            this.leaderNode = null;
            this.trailerNode = null;
        }
    }

    private OrderableObjectHolder<T> getOrderableObjectHolder(String objectName) {
        return this.orderableObjectHolderMap.get(objectName);
    }

    private void initializeGraph() {
        this.addNodes();
        if (this.leaderNode == null) {
            this.leaderNode = new Node<Object>(null, "*-leader-*");
        }
        if (this.trailerNode == null) {
            this.trailerNode = new Node<Object>(null, "*-trailer-*");
        }
        this.addDependencies();
    }

    private Node<T> getNode(String name) {
        return this.nodeMap.get(this.getOrderableObjectHolder(name));
    }

    private void addNodes() {
        for (OrderableObjectHolder<T> o : this.orderableObjectHolderList) {
            Node<T> node = new Node<T>(o.getObject(), o.getName());
            this.nodeMap.put(o, node);
            if ("*".equals(o.getPostrequisites())) {
                if (this.leaderNode == null) {
                    this.leaderNode = node;
                } else {
                    log.error("Duplicate leader object by name, '{}'. Original object: {}", (Object)this.leaderNode.getName(), o.getObject());
                }
            }
            if (!"*".equals(o.getPrerequisites())) continue;
            if (this.trailerNode == null) {
                this.trailerNode = node;
                continue;
            }
            log.error("Duplicate trailer object by name, '{}'. Original object: {}", (Object)this.trailerNode.getName(), o.getObject());
        }
    }

    private void addDependencies() {
        for (OrderableObjectHolder<T> o : this.orderableObjectHolderList) {
            this.addDependencies(o, this.getNode(o.getName()));
        }
    }

    private void addDependencies(OrderableObjectHolder<T> orderable, Node<T> node) {
        block6: {
            this.addPrerequisites(orderable, node);
            this.addPostrequisites(orderable, node);
            try {
                if (node != this.leaderNode) {
                    node.addDependency(this.leaderNode);
                }
                if (node != this.trailerNode) {
                    this.trailerNode.addDependency(node);
                }
            }
            catch (ObjectOrdererRuntimeException ex) {
                String name = node.getName();
                OrderableObjectHolder<T> trigger = this.getOrderableObjectHolder(name);
                if (log.isDebugEnabled()) {
                    log.error("Error in dependency cycle. _objectType: '" + this.objectOrderingName + "', object: " + trigger.getObject(), (Throwable)ex);
                } else {
                    log.error("Error in dependency cycle. _objectType: '" + this.objectOrderingName + "', object: {}. {}", trigger.getObject(), (Object)ex.toString());
                }
                if (this.ignoreExceptions) break block6;
                throw ex;
            }
        }
    }

    private void addPrerequisites(OrderableObjectHolder<T> ordering, Node<T> node) {
        String prereqs = ordering.getPrerequisites();
        if ("*".equals(prereqs)) {
            return;
        }
        String[] names = StringUtils.split((String)prereqs, (String)REQUISITES_SEPARATOR_CHARS);
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String prename = names[i];
                Node<T> prenode = this.getNode(prename);
                if (prenode == null) {
                    log.error("Bad dependency for '{}'. pre node not found by name, '{}'.", (Object)this.objectOrderingName, (Object)prename);
                    continue;
                }
                try {
                    node.addDependency(prenode);
                    continue;
                }
                catch (ObjectOrdererRuntimeException ex) {
                    if (log.isDebugEnabled()) {
                        log.error("Error in dependency cycle. _objectType: '" + this.objectOrderingName + "', object: " + ordering.getObject(), (Throwable)ex);
                    } else {
                        log.error("Error in dependency cycle. _objectType: '" + this.objectOrderingName + "', object: {}. {}", ordering.getObject(), (Object)ex.toString());
                    }
                    if (this.ignoreExceptions) continue;
                    throw ex;
                }
            }
        }
    }

    private void addPostrequisites(OrderableObjectHolder<T> ordering, Node<T> node) {
        String postreqs = ordering.getPostrequisites();
        if ("*".equals(postreqs)) {
            return;
        }
        String[] names = StringUtils.split((String)postreqs, (String)REQUISITES_SEPARATOR_CHARS);
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String postname = names[i];
                Node<T> postnode = this.getNode(postname);
                if (postnode == null) {
                    log.error("Bad dependency for '{}'. post node not found by name, '{}'.", (Object)this.objectOrderingName, (Object)postname);
                    continue;
                }
                try {
                    postnode.addDependency(node);
                    continue;
                }
                catch (ObjectOrdererRuntimeException ex) {
                    if (log.isDebugEnabled()) {
                        log.error("Error in dependency cycle. _objectType: '" + this.objectOrderingName + "', object: " + ordering.getObject(), (Throwable)ex);
                    } else {
                        log.error("Error in dependency cycle. _objectType: '" + this.objectOrderingName + "', object: {}. {}", ordering.getObject(), (Object)ex.toString());
                    }
                    if (this.ignoreExceptions) continue;
                    throw ex;
                }
            }
        }
    }

    private static class Node<T> {
        private T object;
        private String name;
        private List<Node<T>> dependencies;

        public Node(T o, String name) {
            this.object = o;
            this.name = name;
            this.dependencies = new ArrayList<Node<T>>();
        }

        public String getName() {
            return this.name;
        }

        public void addDependency(Node<T> n) {
            if (super.isReachable(this)) {
                throw new ObjectOrdererRuntimeException("A cycle has been detected from the initial object [" + this.name + "] " + this.object);
            }
            this.dependencies.add(n);
        }

        private boolean isReachable(Node<T> n) {
            boolean reachable = n == this;
            Iterator<Node<T>> i = this.dependencies.iterator();
            while (i.hasNext() && !reachable) {
                Node<T> dep = i.next();
                reachable = dep == n ? true : super.isReachable(n);
            }
            return reachable;
        }

        public List<T> getOrder() {
            ArrayList result = new ArrayList();
            this.fillOrder(result);
            return result;
        }

        private void fillOrder(List<T> result) {
            if (result.contains(this.object)) {
                return;
            }
            for (Node<T> dep : this.dependencies) {
                super.fillOrder(result);
            }
            if (this.object != null) {
                result.add(this.object);
            }
        }
    }

    private class OrderableObjectHolder<T> {
        private String name;
        private T object;
        private String prerequisites;
        private String postrequisites;

        OrderableObjectHolder(T object, String name, String prerequisites, String postrequisites) {
            this.object = object;
            this.name = name;
            this.prerequisites = prerequisites;
            this.postrequisites = postrequisites;
        }

        public String getName() {
            return this.name;
        }

        public T getObject() {
            return this.object;
        }

        public String getPrerequisites() {
            return this.prerequisites;
        }

        public String getPostrequisites() {
            return this.postrequisites;
        }

        public String toString() {
            return new StringBuilder(80).append(super.toString()).append(" { name:'" + this.name + "',").append("prerequisites: '" + this.prerequisites + "',").append("postrequisites: '" + this.postrequisites + "',").append("object: " + this.object + " }").toString();
        }
    }
}

