/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.logging;

import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.hippoecm.hst.core.component.HstRequest;
import org.hippoecm.hst.core.component.HstRequestImpl;
import org.hippoecm.hst.core.container.HstComponentWindow;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;

public class HstComponentInvokerProfiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object profile(ProceedingJoinPoint call) throws Throwable {
        if (HDC.isStarted()) {
            Object[] args = call.getArgs();
            String invokerMethodName = call.getSignature().getName();
            String compMethodName = StringUtils.replaceOnce((String)invokerMethodName, (String)"invoke", (String)"do");
            String windowName = "";
            String refNamespace = "";
            Task profileTask = HDC.getCurrentTask().startSubtask(HstComponentInvokerProfiler.class.getSimpleName());
            profileTask.setAttribute("method", (Object)compMethodName);
            try {
                if (args.length > 1 && args[1] instanceof HstRequest) {
                    HstRequest hstRequest = (HstRequest)args[1];
                    HstComponentWindow window = ((HstRequestImpl)hstRequest).getComponentWindow();
                    windowName = window.getName();
                    profileTask.setAttribute("window", (Object)windowName);
                    profileTask.setAttribute("component", (Object)window.getComponentName());
                    refNamespace = hstRequest.getReferenceNamespace();
                    if ("".equals(refNamespace)) {
                        refNamespace = "root";
                    }
                    profileTask.setAttribute("ref", (Object)refNamespace);
                }
                Object object = call.proceed();
                return object;
            }
            finally {
                profileTask.stop();
            }
        }
        return call.proceed();
    }
}

