/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking.resolvers;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.linking.HstLinkImpl;
import org.hippoecm.hst.core.linking.LocationMapTree;
import org.hippoecm.hst.core.linking.ResourceContainer;
import org.hippoecm.hst.core.linking.ResourceLocationResolver;
import org.hippoecm.repository.api.HippoNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HippoResourceLocationResolver
implements ResourceLocationResolver {
    private static final Logger log = LoggerFactory.getLogger(HippoResourceLocationResolver.class);
    private String[] binaryLocations;
    private static final String binariesPrefix = "/binaries";
    private List<ResourceContainer> resourceContainers;
    private static final String NODE_TYPE = "hippo:resource";

    @Deprecated
    public void setLocationMapTree(LocationMapTree locationMapTree) {
    }

    @Deprecated
    public void setBinariesPrefix(String binariesPrefix) {
        if (StringUtils.isNotBlank((String)binariesPrefix)) {
            log.warn("hst-config.properties property 'binaries.prefix.path' is not used any more. Ignoring configured value '{}'. If you configured a cdn host in the binaries prefix, you have to configure that now on a hst:virtualhost or hst:mount configuration node through property '{}'.", (Object)binariesPrefix, (Object)"hst:cdnhost");
        }
    }

    public void setBinaryLocations(String[] binaryLocations) {
        if (binaryLocations == null) {
            this.binaryLocations = null;
        } else {
            this.binaryLocations = new String[binaryLocations.length];
            System.arraycopy(binaryLocations, 0, this.binaryLocations, 0, binaryLocations.length);
        }
    }

    public void setResourceContainers(List<ResourceContainer> resourceContainers) {
        this.resourceContainers = resourceContainers;
    }

    public List<ResourceContainer> getResourceContainers() {
        return this.resourceContainers;
    }

    public String getNodeType() {
        return NODE_TYPE;
    }

    @Deprecated
    public HstLink resolve(Node node, Mount mount) {
        log.warn("This method is deprecated. Use resolve(Node, Mount, LocationMapTree) instead");
        return this.resolve(node, mount, null);
    }

    public HstLink resolve(Node node, Mount mount, LocationMapTree tree) {
        try {
            Node canonicalNode = null;
            if (node instanceof HippoNode) {
                canonicalNode = ((HippoNode)node).getCanonicalNode();
            }
            if (canonicalNode != null && this.isBinaryLocation(canonicalNode.getPath())) {
                node = canonicalNode;
            }
            Node resourceContainerNode = node.getParent();
            for (ResourceContainer container : this.resourceContainers) {
                if (!resourceContainerNode.isNodeType(container.getNodeType())) continue;
                String pathInfo = container.resolveToPathInfo(resourceContainerNode, node, mount);
                if (pathInfo != null) {
                    return new HstLinkImpl(this.getBinariesPrefix() + pathInfo, mount, true);
                }
                log.debug("resourceContainer for '{}' unable to create a HstLink for path '{}'. Try next", (Object)container.getNodeType(), (Object)node.getPath());
            }
            log.debug("No resource container found for '{}'. Fallback to default link for binary which is '{}'/_nodepath_", (Object)resourceContainerNode.getPrimaryNodeType().getName(), (Object)this.getBinariesPrefix());
            return this.defaultResourceLink(node, mount);
        }
        catch (RepositoryException e) {
            log.warn("RepositoryException during creating HstLink for resource. Return null");
            return null;
        }
    }

    private HstLink defaultResourceLink(Node node, Mount mount) throws RepositoryException {
        String pathInfo = this.getBinariesPrefix() + node.getPath();
        boolean containerResource = true;
        return new HstLinkImpl(pathInfo, mount, containerResource);
    }

    public boolean isBinaryLocation(String path) {
        if (this.binaryLocations == null || path == null) {
            return false;
        }
        for (String prefix : this.binaryLocations) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public String getBinariesPrefix() {
        return binariesPrefix == null ? "" : binariesPrefix;
    }
}

