/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItemService;
import org.hippoecm.hst.core.internal.CollectionOptimizer;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.core.linking.LocationMapTree;
import org.hippoecm.hst.core.linking.LocationMapTreeItem;
import org.hippoecm.hst.core.linking.LocationMapTreeItemImpl;
import org.hippoecm.hst.core.util.PropertyParser;
import org.hippoecm.hst.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapTreeSiteMap
implements LocationMapTree {
    private static final String KEY_TO_PROPERTY_PREFIX = "key";
    private static final Logger log = LoggerFactory.getLogger(LocationMapTreeSiteMap.class);
    private Map<String, LocationMapTreeItem> children = new HashMap<String, LocationMapTreeItem>();

    public LocationMapTreeSiteMap(List<HstSiteMapItem> siteMapItems) {
        for (HstSiteMapItem siteMapItem : siteMapItems) {
            this.add2LocationMap(siteMapItem);
        }
        this.optimize();
    }

    public LocationMapTreeSiteMap(HstSiteMapItem siteMapItem) {
        this.add2LocationMap(siteMapItem);
        this.optimize();
    }

    private void add2LocationMap(HstSiteMapItem siteMapItem) {
        String normPath = PathUtils.normalizePath((String)siteMapItem.getRelativeContentPath());
        if (siteMapItem.isExcludedForLinkRewriting()) {
            log.debug("'{}' will not be used for link rewriting as it is marked deleted or is configured to be excluded for link rewriting.", (Object)siteMapItem);
            return;
        }
        if (StringUtils.isNotEmpty((String)normPath)) {
            log.debug("Adding to location map path '{}' for sitemap item '{}'", (Object)normPath, (Object)siteMapItem.getQualifiedId());
            this.addSiteMapItem(normPath, siteMapItem);
        }
        for (HstSiteMapItem child : siteMapItem.getChildren()) {
            this.add2LocationMap(child);
        }
    }

    private void addSiteMapItem(String unresolvedPath, HstSiteMapItem siteMapItem) {
        if (unresolvedPath == null) {
            log.debug("'{}' will not be used for linkrewriting as it has an empty relative content path.", (Object)siteMapItem);
            return;
        }
        ArrayList<String> propertyOrderList = new ArrayList<String>();
        Properties params = new Properties();
        ArrayList<HstSiteMapItem> ancestorItems = new ArrayList<HstSiteMapItem>();
        ancestorItems.add(siteMapItem);
        for (HstSiteMapItem parent = siteMapItem.getParentItem(); parent != null; parent = parent.getParentItem()) {
            ancestorItems.add(parent);
        }
        if (!siteMapItem.isExplicitPath()) {
            int index = ancestorItems.size();
            while (index-- != 0) {
                String paramVal;
                HstSiteMapItemService s = (HstSiteMapItemService)ancestorItems.get(index);
                if (s.isWildCard()) {
                    params.put(String.valueOf(params.size() + 1), "_default_");
                    propertyOrderList.add("${" + params.size() + "}");
                    continue;
                }
                if (s.isAny()) {
                    params.put(String.valueOf(params.size() + 1), "_any_");
                    propertyOrderList.add("${" + params.size() + "}");
                    continue;
                }
                if (s.containsWildCard()) {
                    paramVal = s.getPrefix() + "_default_";
                    if (s.getPostfix().indexOf(".") > -1) {
                        String string = s.getPostfix().substring(0, s.getPostfix().indexOf("."));
                        if (!"".equals(string)) {
                            paramVal = paramVal + string;
                        }
                    } else {
                        paramVal = paramVal + s.getPostfix();
                    }
                    params.put(String.valueOf(params.size() + 1), paramVal);
                    propertyOrderList.add("${" + params.size() + "}");
                    continue;
                }
                if (!s.containsAny()) continue;
                paramVal = s.getPrefix() + "_any_";
                if (s.getPostfix().indexOf(".") > -1) {
                    String string = s.getPostfix().substring(0, s.getPostfix().indexOf("."));
                    if (!"".equals(string)) {
                        paramVal = paramVal + string;
                    }
                } else {
                    paramVal = paramVal + s.getPostfix();
                }
                params.put(String.valueOf(params.size() + 1), paramVal);
                propertyOrderList.add("${" + params.size() + "}");
            }
        }
        HashMap<String, String> keyToPropertyPlaceHolderMap = new HashMap<String, String>();
        String[] unresolvedPathEls = unresolvedPath.split("/");
        int keyNumber = 1;
        for (String pathEl : unresolvedPathEls) {
            int loc = propertyOrderList.indexOf(pathEl);
            if (loc <= -1) continue;
            keyToPropertyPlaceHolderMap.put(KEY_TO_PROPERTY_PREFIX + keyNumber, String.valueOf(loc + 1));
            ++keyNumber;
        }
        ((HstSiteMapItemService)siteMapItem).setKeyToPropertyPlaceHolderMap(keyToPropertyPlaceHolderMap);
        PropertyParser propertyParser = new PropertyParser(params);
        for (Object param : params.keySet()) {
            String propertyPlaceHolder = "${" + param + "}";
            if (unresolvedPath.contains(propertyPlaceHolder)) continue;
            log.debug("The SiteMapItem with id '{}' and relative content path '{}' can only be used in a context aware link rewriting", (Object)siteMapItem.getId(), (Object)siteMapItem.getRelativeContentPath());
            ((HstSiteMapItemService)siteMapItem).setUseableInRightContextOnly(true);
        }
        String resolvedPath = (String)propertyParser.resolveProperty("relative contentpath", unresolvedPath);
        if (resolvedPath == null) {
            log.warn("Skipping '{}' for linkrewriting : Unable to translate relative content path '{}' because the wildcards in '{}' do not match the property placeholders in the relative content path. ", new Object[]{siteMapItem, unresolvedPath, siteMapItem});
            return;
        }
        log.debug("Translated relative contentpath '{}' --> '{}'", (Object)unresolvedPath, (Object)resolvedPath);
        this.addSiteMapItem(resolvedPath.split("/"), siteMapItem);
    }

    private void addSiteMapItem(String[] pathFragments, HstSiteMapItem siteMapItem) {
        if (pathFragments.length == 0) {
            return;
        }
        LocationMapTreeItemImpl child = (LocationMapTreeItemImpl)this.getTreeItem(pathFragments[0]);
        if (child == null) {
            child = new LocationMapTreeItemImpl();
            this.children.put(StringPool.get((String)pathFragments[0]), child);
        }
        child.addSiteMapItem(pathFragments, siteMapItem, 1);
    }

    public LocationMapTreeItem getTreeItem(String name) {
        return this.children.get(name);
    }

    private void optimize() {
        this.children = CollectionOptimizer.optimizeHashMap(this.children);
        for (LocationMapTreeItem child : this.children.values()) {
            ((LocationMapTreeItemImpl)child).optimize();
        }
    }
}

