/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.core.internal.CollectionOptimizer;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.core.linking.LocationMapTreeItem;

public class LocationMapTreeItemImpl
implements LocationMapTreeItem {
    private List<HstSiteMapItem> hstSiteMapItems = new ArrayList<HstSiteMapItem>();
    private Map<String, LocationMapTreeItem> children = new HashMap<String, LocationMapTreeItem>();
    private LocationMapTreeItem parentItem;
    private boolean isWildCard;
    private boolean isAny;

    void addSiteMapItem(String[] pathFragments, HstSiteMapItem hstSiteMapItem, int position) {
        if (pathFragments.length == position) {
            this.hstSiteMapItems.add(hstSiteMapItem);
            return;
        }
        LocationMapTreeItemImpl child = (LocationMapTreeItemImpl)this.getChild(pathFragments[position]);
        if (child == null) {
            child = new LocationMapTreeItemImpl();
            this.children.put(StringPool.get((String)pathFragments[position]), child);
            child.setParentItem(this);
            if ("_default_".equals(pathFragments[position])) {
                child.isWildCard = true;
            } else if ("_any_".equals(pathFragments[position])) {
                child.isAny = true;
            }
        }
        child.addSiteMapItem(pathFragments, hstSiteMapItem, position + 1);
    }

    public List<HstSiteMapItem> getHstSiteMapItems() {
        return this.hstSiteMapItems;
    }

    public LocationMapTreeItem getChild(String name) {
        return this.children.get(name);
    }

    public LocationMapTreeItem getParentItem() {
        return this.parentItem;
    }

    void setParentItem(LocationMapTreeItem parentItem) {
        this.parentItem = parentItem;
    }

    public boolean isAny() {
        return this.isAny;
    }

    public boolean isWildCard() {
        return this.isWildCard;
    }

    void optimize() {
        this.children = CollectionOptimizer.optimizeHashMap(this.children);
        this.hstSiteMapItems = CollectionOptimizer.optimizeArrayList(this.hstSiteMapItems);
        for (LocationMapTreeItem child : this.children.values()) {
            ((LocationMapTreeItemImpl)child).optimize();
        }
    }
}

