/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.components.HstComponentsConfiguration;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.core.internal.CollectionOptimizer;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.core.linking.DocumentParamsScanner;
import org.hippoecm.hst.core.linking.LocationMapTree;
import org.hippoecm.hst.core.linking.LocationMapTreeItem;
import org.hippoecm.hst.core.linking.LocationMapTreeItemImpl;
import org.hippoecm.hst.core.util.PropertyParser;
import org.hippoecm.hst.util.PathUtils;
import org.onehippo.cms7.services.ServletContextRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapTreeComponentDocuments
implements LocationMapTree {
    private static final Logger log = LoggerFactory.getLogger(LocationMapTreeComponentDocuments.class);
    private Map<String, LocationMapTreeItem> children = new HashMap<String, LocationMapTreeItem>();

    public LocationMapTreeComponentDocuments(List<HstSiteMapItem> siteMapItems, HstComponentsConfiguration configuration, String mountContentPath, String contextPath) {
        if (configuration == null) {
            return;
        }
        for (HstSiteMapItem siteMapItem : siteMapItems) {
            this.add2LocationMap(siteMapItem, configuration, mountContentPath, this.getClassLoader(contextPath));
        }
        this.optimize();
    }

    public LocationMapTreeComponentDocuments(HstSiteMapItem siteMapItem, HstComponentsConfiguration configuration, String mountContentPath, String contextPath) {
        if (configuration == null) {
            return;
        }
        this.add2LocationMap(siteMapItem, configuration, mountContentPath, this.getClassLoader(contextPath));
        this.optimize();
    }

    private void add2LocationMap(HstSiteMapItem siteMapItem, HstComponentsConfiguration configuration, String mountContentPath, ClassLoader classLoader) {
        if (classLoader == null) {
            log.info("ClassLoader null. return without populating location map.");
            return;
        }
        if (siteMapItem.isExcludedForLinkRewriting()) {
            log.debug("'{}' will not be used for link rewriting as it is marked deleted or is configured to be excluded for link rewriting.", (Object)siteMapItem);
            return;
        }
        if (siteMapItem.getComponentConfigurationId() != null && siteMapItem.isExplicitPath()) {
            HstComponentConfiguration cc = configuration.getComponentConfiguration(siteMapItem.getComponentConfigurationId());
            if (cc == null) {
                log.warn("'{}' for site '{}' contains unresolvable hst:componentconfigurationid '{}'.", new Object[]{siteMapItem, siteMapItem.getHstSiteMap().getSite().getName(), siteMapItem.getComponentConfigurationId()});
            } else {
                List documentPaths = DocumentParamsScanner.findDocumentPathsRecursive((HstComponentConfiguration)cc, (ClassLoader)classLoader);
                Properties siteMapItemParameters = new Properties();
                for (Map.Entry param : siteMapItem.getParameters().entrySet()) {
                    if (param.getKey() == null || param.getValue() == null) continue;
                    siteMapItemParameters.put(param.getKey(), param.getValue());
                }
                PropertyParser pp = new PropertyParser(siteMapItemParameters);
                for (String documentPath : documentPaths) {
                    String normalizedParsedDocumentPath;
                    String parsedDocumentPath = (String)pp.resolveProperty("documentPath", documentPath);
                    if (parsedDocumentPath == null) {
                        log.debug("Could not parse '{}' for '{}'. ", (Object)documentPath, (Object)siteMapItem);
                        continue;
                    }
                    if (parsedDocumentPath.startsWith("/")) {
                        if (mountContentPath == null || !parsedDocumentPath.startsWith(mountContentPath)) continue;
                        parsedDocumentPath = parsedDocumentPath.substring(mountContentPath.length());
                    }
                    if (!StringUtils.isNotEmpty((String)(normalizedParsedDocumentPath = PathUtils.normalizePath((String)parsedDocumentPath)))) continue;
                    log.debug("Adding document path '{}' from page to location map for sitemap item '{}'", (Object)normalizedParsedDocumentPath, (Object)siteMapItem.getQualifiedId());
                    this.addSiteMapItem(normalizedParsedDocumentPath.split("/"), siteMapItem);
                }
            }
        }
        for (HstSiteMapItem child : siteMapItem.getChildren()) {
            this.add2LocationMap(child, configuration, mountContentPath, classLoader);
        }
    }

    private void addSiteMapItem(String[] pathFragments, HstSiteMapItem siteMapItem) {
        if (pathFragments.length == 0) {
            return;
        }
        LocationMapTreeItemImpl child = (LocationMapTreeItemImpl)this.getTreeItem(pathFragments[0]);
        if (child == null) {
            child = new LocationMapTreeItemImpl();
            this.children.put(StringPool.get((String)pathFragments[0]), child);
        }
        child.addSiteMapItem(pathFragments, siteMapItem, 1);
    }

    public LocationMapTreeItem getTreeItem(String name) {
        return this.children.get(name);
    }

    private ClassLoader getClassLoader(String contextPath) {
        ServletContext context = ServletContextRegistry.getContext((String)contextPath);
        if (context == null) {
            log.warn("Cannot populate LocationMapTreeComponentDocuments because cannot find a ClassLoader for contextPath '{}'", (Object)contextPath);
            return null;
        }
        return context.getClassLoader();
    }

    private void optimize() {
        this.children = CollectionOptimizer.optimizeHashMap(this.children);
        for (LocationMapTreeItem child : this.children.values()) {
            ((LocationMapTreeItemImpl)child).optimize();
        }
    }
}

