/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItemService;
import org.hippoecm.hst.core.linking.LocationMapTree;
import org.hippoecm.hst.core.linking.LocationMapTreeItem;
import org.hippoecm.hst.core.linking.LocationMapTreeItemImpl;
import org.hippoecm.hst.core.linking.ResolvedLocationMapTreeItem;
import org.hippoecm.hst.core.linking.ResolvedLocationMapTreeItemImpl;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.util.PropertyParser;
import org.hippoecm.hst.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapResolver {
    private static final Logger log = LoggerFactory.getLogger(LocationMapResolver.class);
    private static final String KEY_TO_PROPERTY_PREFIX = "key";
    private final LocationMapTree locationMapTreeSiteMap;
    private final LocationMapTree subLocationMapTreeComponentDocuments;
    private boolean representsDocument;
    private boolean canonical;
    private boolean isSubResolver;
    private ResolvedSiteMapItem resolvedSiteMapItem;
    private Set<LocationMapTreeItem> checkedLocationMapTreeItems = Sets.newIdentityHashSet();

    public LocationMapResolver(LocationMapTree locationMapTreeSiteMap, LocationMapTree subLocationMapTreeComponentDocuments) {
        this.locationMapTreeSiteMap = locationMapTreeSiteMap;
        this.subLocationMapTreeComponentDocuments = subLocationMapTreeComponentDocuments;
    }

    public void setRepresentsDocument(boolean representsDocument) {
        this.representsDocument = representsDocument;
    }

    public void setCanonical(boolean canonical) {
        this.canonical = canonical;
    }

    public void setResolvedSiteMapItem(ResolvedSiteMapItem resolvedSiteMapItem) {
        this.resolvedSiteMapItem = resolvedSiteMapItem;
    }

    public void setSubResolver(boolean isSubResolver) {
        this.isSubResolver = isSubResolver;
    }

    public ResolvedLocationMapTreeItem resolve(String path) {
        LocationMapTree[] locationMapTrees;
        long start = System.nanoTime();
        path = PathUtils.normalizePath((String)path);
        String[] elements = path.split("/");
        LocationMapTreeItem matchedLocationMapTreeItem = null;
        for (LocationMapTree locationMapTree : locationMapTrees = new LocationMapTree[]{this.locationMapTreeSiteMap, this.subLocationMapTreeComponentDocuments}) {
            ResolvedLocationMapTreeItemImpl parent;
            ResolvedLocationMapTreeItem r;
            LocationMapTreeItem newMatched;
            LocationMapTreeItem locationMapTreeItem = locationMapTree.getTreeItem(elements[0]);
            HstSiteMapItem matchingSiteMapItem = null;
            HashMap<String, String> propertyPlaceHolderMap = new HashMap<String, String>();
            if (locationMapTreeItem != null) {
                while (matchingSiteMapItem == null) {
                    propertyPlaceHolderMap.clear();
                    newMatched = this.resolveMatchingLocationMapTreeItem(locationMapTreeItem, 1, elements, propertyPlaceHolderMap);
                    if (newMatched == null || newMatched == matchedLocationMapTreeItem) break;
                    matchedLocationMapTreeItem = newMatched;
                    matchingSiteMapItem = this.resolveToSiteMapItem(matchedLocationMapTreeItem, propertyPlaceHolderMap);
                }
            }
            if (matchingSiteMapItem == null && (locationMapTreeItem = locationMapTree.getTreeItem("_default_")) != null) {
                while (matchingSiteMapItem == null) {
                    propertyPlaceHolderMap.clear();
                    propertyPlaceHolderMap.put(KEY_TO_PROPERTY_PREFIX + String.valueOf(propertyPlaceHolderMap.size() + 1), elements[0]);
                    newMatched = this.resolveMatchingLocationMapTreeItem(locationMapTreeItem, 1, elements, propertyPlaceHolderMap);
                    if (newMatched == null || newMatched == matchedLocationMapTreeItem) break;
                    matchedLocationMapTreeItem = newMatched;
                    matchingSiteMapItem = this.resolveToSiteMapItem(matchedLocationMapTreeItem, propertyPlaceHolderMap);
                }
            }
            if (matchingSiteMapItem == null) {
                propertyPlaceHolderMap.clear();
                locationMapTreeItem = locationMapTree.getTreeItem("_any_");
                if (locationMapTreeItem != null) {
                    propertyPlaceHolderMap.put(KEY_TO_PROPERTY_PREFIX + String.valueOf(propertyPlaceHolderMap.size() + 1), path);
                    matchedLocationMapTreeItem = locationMapTreeItem;
                    matchingSiteMapItem = this.resolveToSiteMapItem(matchedLocationMapTreeItem, propertyPlaceHolderMap);
                }
            }
            if (matchingSiteMapItem == null || (r = this.createResolvedLocationMapTreeItem(path, matchingSiteMapItem, propertyPlaceHolderMap)) == null) continue;
            if ("_index_".equals(r.getSiteMapItem().getValue()) && (parent = this.getResolvedParent(r)) != null) {
                r = parent;
            }
            log.debug("Trying to resolve '{}' took '{}' ms.", (Object)path, (Object)String.valueOf((double)(System.nanoTime() - start) / 1000000.0));
            return r;
        }
        log.debug("Unable to linkrewrite '{}' to any sitemap item", (Object)path);
        return null;
    }

    private ResolvedLocationMapTreeItem createResolvedLocationMapTreeItem(String path, HstSiteMapItem matchingSiteMapItem, Map<String, String> propertyPlaceHolderMap) {
        Properties params = new Properties();
        for (Map.Entry<String, String> entry : propertyPlaceHolderMap.entrySet()) {
            Map<String, String> keyToPropertyPlaceHolderMap = ((HstSiteMapItemService)matchingSiteMapItem).getKeyToPropertyPlaceHolderMap();
            if (keyToPropertyPlaceHolderMap.containsKey(entry.getKey())) {
                String key = keyToPropertyPlaceHolderMap.get(entry.getKey());
                if (key == null || entry.getValue() == null) continue;
                params.put(key, entry.getValue());
                continue;
            }
            if (keyToPropertyPlaceHolderMap.containsValue(entry.getKey()) || entry.getKey() == null || entry.getValue() == null) continue;
            params.put(entry.getKey(), entry.getValue());
        }
        PropertyParser pp = new PropertyParser(params);
        String resolvedPath = (String)pp.resolveProperty("parameterized Path", ((HstSiteMapItemService)matchingSiteMapItem).getParameterizedPath());
        if (resolvedPath == null) {
            if (!this.isSubResolver) {
                log.debug("Unable to resolve parameterized path '{}' for sitemap item '{}' for current context and path '{}'. Return null", new Object[]{((HstSiteMapItemService)matchingSiteMapItem).getParameterizedPath(), matchingSiteMapItem, path});
            }
            return null;
        }
        return new ResolvedLocationMapTreeItemImpl(resolvedPath, matchingSiteMapItem, this.representsDocument);
    }

    public List<ResolvedLocationMapTreeItem> resolveAll(String path) {
        LocationMapTree[] locationMapTrees;
        long start = System.nanoTime();
        String normalizedPath = PathUtils.normalizePath((String)path);
        String[] elements = normalizedPath.split("/");
        ArrayList<ResolvedLocationMapTreeItem> resolvedLocationMapTreeItemList = new ArrayList<ResolvedLocationMapTreeItem>();
        for (LocationMapTree locationMapTree : locationMapTrees = new LocationMapTree[]{this.locationMapTreeSiteMap, this.subLocationMapTreeComponentDocuments}) {
            ResolvedLocationMapTreeItemImpl parent;
            ResolvedLocationMapTreeItem r;
            HstSiteMapItem hstSiteMapItem;
            Iterator iterator;
            LocationMapTreeItem newMatched;
            LocationMapTreeItem matchedLocationMapTreeItem;
            LocationMapTreeItem locationMapTreeItem = locationMapTree.getTreeItem(elements[0]);
            HashMap<String, String> propertyPlaceHolderMap = new HashMap<String, String>();
            if (locationMapTreeItem != null) {
                matchedLocationMapTreeItem = null;
                block1: while (true) {
                    propertyPlaceHolderMap.clear();
                    newMatched = this.resolveMatchingLocationMapTreeItem(locationMapTreeItem, 1, elements, propertyPlaceHolderMap);
                    if (newMatched == null || newMatched == matchedLocationMapTreeItem) break;
                    matchedLocationMapTreeItem = newMatched;
                    iterator = matchedLocationMapTreeItem.getHstSiteMapItems().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block1;
                        hstSiteMapItem = (HstSiteMapItem)iterator.next();
                        r = this.createResolvedLocationMapTreeItem(normalizedPath, hstSiteMapItem, propertyPlaceHolderMap);
                        if (r == null) continue;
                        if ("_index_".equals(r.getSiteMapItem().getValue()) && (parent = this.getResolvedParent(r)) != null) {
                            resolvedLocationMapTreeItemList.add(parent);
                            continue;
                        }
                        resolvedLocationMapTreeItemList.add(r);
                    }
                    break;
                }
            }
            if ((locationMapTreeItem = locationMapTree.getTreeItem("_default_")) != null) {
                matchedLocationMapTreeItem = null;
                block3: while (true) {
                    propertyPlaceHolderMap.clear();
                    propertyPlaceHolderMap.put(KEY_TO_PROPERTY_PREFIX + String.valueOf(propertyPlaceHolderMap.size() + 1), elements[0]);
                    newMatched = this.resolveMatchingLocationMapTreeItem(locationMapTreeItem, 1, elements, propertyPlaceHolderMap);
                    if (newMatched == null || newMatched == matchedLocationMapTreeItem) break;
                    matchedLocationMapTreeItem = newMatched;
                    iterator = matchedLocationMapTreeItem.getHstSiteMapItems().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        hstSiteMapItem = (HstSiteMapItem)iterator.next();
                        r = this.createResolvedLocationMapTreeItem(normalizedPath, hstSiteMapItem, propertyPlaceHolderMap);
                        if (r == null) continue;
                        if ("_index_".equals(r.getSiteMapItem().getValue()) && (parent = this.getResolvedParent(r)) != null) {
                            resolvedLocationMapTreeItemList.add(parent);
                            continue;
                        }
                        resolvedLocationMapTreeItemList.add(r);
                    }
                    break;
                }
            }
            propertyPlaceHolderMap.clear();
            matchedLocationMapTreeItem = locationMapTree.getTreeItem("_any_");
            if (matchedLocationMapTreeItem == null) continue;
            propertyPlaceHolderMap.put(KEY_TO_PROPERTY_PREFIX + String.valueOf(propertyPlaceHolderMap.size() + 1), normalizedPath);
            for (HstSiteMapItem hstSiteMapItem2 : matchedLocationMapTreeItem.getHstSiteMapItems()) {
                ResolvedLocationMapTreeItemImpl parent2;
                ResolvedLocationMapTreeItem r2 = this.createResolvedLocationMapTreeItem(normalizedPath, hstSiteMapItem2, propertyPlaceHolderMap);
                if (r2 == null) continue;
                if ("_index_".equals(r2.getSiteMapItem().getValue()) && (parent2 = this.getResolvedParent(r2)) != null) {
                    resolvedLocationMapTreeItemList.add(parent2);
                    continue;
                }
                resolvedLocationMapTreeItemList.add(r2);
            }
        }
        log.debug("Trying to resolve '{}' took '{}' ms and resulted in '{}' resolved ResolvedLocationMapTreeItems.", new Object[]{normalizedPath, String.valueOf((double)(System.nanoTime() - start) / 1000000.0), resolvedLocationMapTreeItemList.size()});
        return resolvedLocationMapTreeItemList;
    }

    private ResolvedLocationMapTreeItemImpl getResolvedParent(ResolvedLocationMapTreeItem r) {
        if (r.getSiteMapItem().getParentItem() == null || !r.getPath().contains("/")) {
            return null;
        }
        return new ResolvedLocationMapTreeItemImpl(StringUtils.substringBeforeLast((String)r.getPath(), (String)"/"), r.getSiteMapItem().getParentItem(), false);
    }

    private HstSiteMapItem resolveToSiteMapItem(LocationMapTreeItem matchedLocationMapTreeItem, Map<String, String> propertyPlaceHolderMap) {
        HstSiteMapItem hstSiteMapItem;
        block9: {
            HstSiteMapItem item;
            Object item22;
            ArrayList<HstSiteMapItem> fallbackSiteMapItems;
            ArrayList<HstSiteMapItem> typeMatchedSiteMapItems;
            block8: {
                if (matchedLocationMapTreeItem == null || matchedLocationMapTreeItem.getHstSiteMapItems().size() == 0) {
                    return null;
                }
                hstSiteMapItem = null;
                typeMatchedSiteMapItems = new ArrayList<HstSiteMapItem>();
                fallbackSiteMapItems = new ArrayList<HstSiteMapItem>();
                for (Object item22 : matchedLocationMapTreeItem.getHstSiteMapItems()) {
                    HstSiteMapItemService serv = (HstSiteMapItemService)item22;
                    if (this.representsDocument) {
                        if (serv.getExtension() != null) {
                            typeMatchedSiteMapItems.add(serv);
                            continue;
                        }
                        fallbackSiteMapItems.add(serv);
                        continue;
                    }
                    if (serv.getExtension() == null) {
                        typeMatchedSiteMapItems.add(serv);
                        continue;
                    }
                    fallbackSiteMapItems.add(serv);
                }
                if (!this.canonical && this.resolvedSiteMapItem != null) break block8;
                hstSiteMapItem = this.getCanonicalItem(typeMatchedSiteMapItems);
                if (hstSiteMapItem != null) break block9;
                hstSiteMapItem = this.getCanonicalItem(fallbackSiteMapItems);
                break block9;
            }
            List<HstSiteMapItem> contextOrderedMatches = this.orderToBestInContext(typeMatchedSiteMapItems);
            item22 = contextOrderedMatches.iterator();
            while (item22.hasNext() && (hstSiteMapItem = this.contextualize((HstSiteMapItemService)(item = (HstSiteMapItem)item22.next()), propertyPlaceHolderMap)) == null) {
            }
            if (hstSiteMapItem == null) {
                HstSiteMapItem item3;
                List<HstSiteMapItem> contextFallBackOrderedMatches = this.orderToBestInContext(fallbackSiteMapItems);
                Iterator<HstSiteMapItem> iterator = contextFallBackOrderedMatches.iterator();
                while (iterator.hasNext() && (hstSiteMapItem = this.contextualize((HstSiteMapItemService)(item3 = iterator.next()), propertyPlaceHolderMap)) == null) {
                }
            }
        }
        return hstSiteMapItem;
    }

    private HstSiteMapItem getCanonicalItem(List<HstSiteMapItem> matchedHstSiteMapItema) {
        ArrayList<HstSiteMapItemService> canonicals = new ArrayList<HstSiteMapItemService>();
        for (HstSiteMapItem item : matchedHstSiteMapItema) {
            HstSiteMapItemService serviceItem = (HstSiteMapItemService)item;
            if (serviceItem.isUseableInRightContextOnly()) continue;
            canonicals.add(serviceItem);
        }
        if (!canonicals.isEmpty()) {
            Collections.sort(canonicals, new LowestDepthFirstAndThenLexicalComparator());
            return (HstSiteMapItem)canonicals.get(0);
        }
        return null;
    }

    private HstSiteMapItem contextualize(HstSiteMapItemService matchedHstSiteMapItem, Map<String, String> propertyPlaceHolderMap) {
        if (matchedHstSiteMapItem.isUseableInRightContextOnly()) {
            boolean mergeable = this.mergeMatchedItemWithCurrentCtx(matchedHstSiteMapItem, propertyPlaceHolderMap);
            if (!mergeable) {
                log.debug("Cannot contextualize hstSiteMapItem '{}' for current sitemap item '{}'", (Object)matchedHstSiteMapItem.getId(), (Object)this.resolvedSiteMapItem.getHstSiteMapItem().getId());
                return null;
            }
            return matchedHstSiteMapItem;
        }
        return matchedHstSiteMapItem;
    }

    private boolean mergeMatchedItemWithCurrentCtx(HstSiteMapItemService matchedHstSiteMapItem, Map<String, String> propertyPlaceHolderMap) {
        LinkedList<HstSiteMapItemService> matchedAncestorOrSelfWildcardList = new LinkedList<HstSiteMapItemService>();
        for (HstSiteMapItemService matchedAncestorOrSelf = matchedHstSiteMapItem; matchedAncestorOrSelf != null; matchedAncestorOrSelf = (HstSiteMapItemService)matchedAncestorOrSelf.getParentItem()) {
            if (!matchedAncestorOrSelf.isWildCard() && !matchedAncestorOrSelf.containsWildCard() && !matchedAncestorOrSelf.isAny() && !matchedAncestorOrSelf.containsAny()) continue;
            matchedAncestorOrSelfWildcardList.add(0, matchedAncestorOrSelf);
        }
        LinkedList<HstSiteMapItemService> currentCtxAncestorOrSeldWildcardList = new LinkedList<HstSiteMapItemService>();
        for (HstSiteMapItemService currentAncestorOrSelf = (HstSiteMapItemService)this.resolvedSiteMapItem.getHstSiteMapItem(); currentAncestorOrSelf != null; currentAncestorOrSelf = (HstSiteMapItemService)currentAncestorOrSelf.getParentItem()) {
            if (!currentAncestorOrSelf.isWildCard() && !currentAncestorOrSelf.containsWildCard() && !currentAncestorOrSelf.isAny() && !currentAncestorOrSelf.containsAny()) continue;
            currentCtxAncestorOrSeldWildcardList.add(0, currentAncestorOrSelf);
        }
        Properties currentCtxProperties = this.resolvedSiteMapItem.getParameters();
        HashMap<String, String> propertiesToMerge = new HashMap<String, String>();
        for (HstSiteMapItemService matchedAncestorItem : matchedAncestorOrSelfWildcardList) {
            int index = currentCtxAncestorOrSeldWildcardList.indexOf(matchedAncestorItem);
            if (index <= -1 || !currentCtxProperties.containsKey(String.valueOf(index + 1))) continue;
            propertiesToMerge.put(String.valueOf(index + 1), currentCtxProperties.getProperty(String.valueOf(index + 1)));
        }
        if (matchedHstSiteMapItem.getWildCardAnyOccurences() <= propertiesToMerge.size() + propertyPlaceHolderMap.size()) {
            propertyPlaceHolderMap.putAll(propertiesToMerge);
            return true;
        }
        return false;
    }

    private LocationMapTreeItem resolveMatchingLocationMapTreeItem(LocationMapTreeItem locationMapTreeItem, int position, String[] elements, Map<String, String> propertyPlaceHolderMap) {
        return this.traverseInToLocationMapTreeItem(locationMapTreeItem, position, elements, propertyPlaceHolderMap);
    }

    private LocationMapTreeItem traverseInToLocationMapTreeItem(LocationMapTreeItem locationMapTreeItem, int position, String[] elements, Map<String, String> propertyPlaceHolderMap) {
        this.checkedLocationMapTreeItems.add(locationMapTreeItem);
        if (position == elements.length) {
            if (locationMapTreeItem.getHstSiteMapItems().size() > 0) {
                return locationMapTreeItem;
            }
            if (((LocationMapTreeItemImpl)locationMapTreeItem).isWildCard()) {
                propertyPlaceHolderMap.remove(KEY_TO_PROPERTY_PREFIX + propertyPlaceHolderMap.size());
            }
            return this.traverseUp(locationMapTreeItem.getParentItem(), position, elements, propertyPlaceHolderMap);
        }
        if (locationMapTreeItem.getChild(elements[position]) != null && !this.checkedLocationMapTreeItems.contains(locationMapTreeItem.getChild(elements[position]))) {
            return this.traverseInToLocationMapTreeItem(locationMapTreeItem.getChild(elements[position]), ++position, elements, propertyPlaceHolderMap);
        }
        if (locationMapTreeItem.getChild("_default_") != null && !this.checkedLocationMapTreeItems.contains(locationMapTreeItem.getChild("_default_"))) {
            propertyPlaceHolderMap.put(KEY_TO_PROPERTY_PREFIX + (propertyPlaceHolderMap.size() + 1), elements[position]);
            return this.traverseInToLocationMapTreeItem(locationMapTreeItem.getChild("_default_"), ++position, elements, propertyPlaceHolderMap);
        }
        if (locationMapTreeItem.getChild("_any_") != null && !this.checkedLocationMapTreeItems.contains(locationMapTreeItem.getChild("_any_"))) {
            this.checkedLocationMapTreeItems.add(locationMapTreeItem.getChild("_any_"));
            return this.getANYMatchingLocationMapTreeItem(locationMapTreeItem, position, elements, propertyPlaceHolderMap);
        }
        return this.traverseUp(locationMapTreeItem, position, elements, propertyPlaceHolderMap);
    }

    private LocationMapTreeItem traverseUp(LocationMapTreeItem locationMapTreeItem, int position, String[] elements, Map<String, String> propertyPlaceHolderMap) {
        if (locationMapTreeItem == null) {
            return null;
        }
        if (((LocationMapTreeItemImpl)locationMapTreeItem).isWildCard()) {
            if (locationMapTreeItem.getChild("_default_") != null && !this.checkedLocationMapTreeItems.contains(locationMapTreeItem.getChild("_default_"))) {
                return this.traverseInToLocationMapTreeItem(locationMapTreeItem, position, elements, propertyPlaceHolderMap);
            }
            if (locationMapTreeItem.getChild("_any_") != null && !this.checkedLocationMapTreeItems.contains(locationMapTreeItem.getChild("_any_"))) {
                return this.traverseInToLocationMapTreeItem(locationMapTreeItem, position, elements, propertyPlaceHolderMap);
            }
            propertyPlaceHolderMap.remove(KEY_TO_PROPERTY_PREFIX + propertyPlaceHolderMap.size());
            return this.traverseUp(locationMapTreeItem.getParentItem(), --position, elements, propertyPlaceHolderMap);
        }
        if (locationMapTreeItem.getChild("_default_") != null && !this.checkedLocationMapTreeItems.contains(locationMapTreeItem.getChild("_default_"))) {
            return this.traverseInToLocationMapTreeItem(locationMapTreeItem, position, elements, propertyPlaceHolderMap);
        }
        if (locationMapTreeItem.getChild("_any_") != null && !this.checkedLocationMapTreeItems.contains(locationMapTreeItem.getChild("_any_"))) {
            return this.traverseInToLocationMapTreeItem(locationMapTreeItem, position, elements, propertyPlaceHolderMap);
        }
        return this.traverseUp(locationMapTreeItem.getParentItem(), --position, elements, propertyPlaceHolderMap);
    }

    private LocationMapTreeItem getANYMatchingLocationMapTreeItem(LocationMapTreeItem locationMapTreeItem, int position, String[] elements, Map<String, String> propertyPlaceHolderMap) {
        StringBuffer remainder = new StringBuffer(elements[position]);
        while (++position < elements.length) {
            remainder.append("/").append(elements[position]);
        }
        propertyPlaceHolderMap.put(KEY_TO_PROPERTY_PREFIX + (propertyPlaceHolderMap.size() + 1), remainder.toString());
        return locationMapTreeItem.getChild("_any_");
    }

    private List<HstSiteMapItem> orderToBestInContext(List<HstSiteMapItem> matchingSiteMapItems) {
        Object current;
        if (matchingSiteMapItems.size() == 0 || matchingSiteMapItems.size() == 1) {
            return matchingSiteMapItems;
        }
        int bestDepth = Integer.MAX_VALUE;
        HstSiteMapItem bestMatch = null;
        ArrayList<HstSiteMapItem> unsortedItems = new ArrayList<HstSiteMapItem>(matchingSiteMapItems);
        ArrayList<HstSiteMapItem> contextOrderedMatches = new ArrayList<HstSiteMapItem>();
        block0: for (HstSiteMapItem hstSiteMapItem : matchingSiteMapItems) {
            if (hstSiteMapItem == this.resolvedSiteMapItem.getHstSiteMapItem()) {
                contextOrderedMatches.add(hstSiteMapItem);
                unsortedItems.remove(hstSiteMapItem);
                if (unsortedItems.size() == 1) {
                    contextOrderedMatches.add((HstSiteMapItem)unsortedItems.get(0));
                    return contextOrderedMatches;
                }
            }
            int depth = 0;
            current = hstSiteMapItem;
            while (current.getParentItem() != null) {
                current = current.getParentItem();
                ++depth;
                if (current != this.resolvedSiteMapItem.getHstSiteMapItem()) continue;
                if (depth >= bestDepth) continue block0;
                bestMatch = hstSiteMapItem;
                bestDepth = depth;
                continue block0;
            }
        }
        if (bestMatch != null && !contextOrderedMatches.contains(bestMatch)) {
            contextOrderedMatches.add(bestMatch);
            unsortedItems.remove(bestMatch);
            if (unsortedItems.size() == 1) {
                contextOrderedMatches.add((HstSiteMapItem)unsortedItems.get(0));
                return contextOrderedMatches;
            }
        }
        HashMap matchingMapWithParents = new HashMap();
        for (HstSiteMapItem siteMapItem : matchingSiteMapItems) {
            current = siteMapItem;
            ArrayList<HstSiteMapItem> parentList = new ArrayList<HstSiteMapItem>();
            while (current.getParentItem() != null) {
                current = current.getParentItem();
                parentList.add((HstSiteMapItem)current);
            }
            matchingMapWithParents.put(siteMapItem, parentList);
        }
        TreeMap treeMap = new TreeMap();
        HstSiteMapItem checkForCommonAncestor = this.resolvedSiteMapItem.getHstSiteMapItem();
        while (checkForCommonAncestor.getParentItem() != null && treeMap.size() == 0) {
            checkForCommonAncestor = checkForCommonAncestor.getParentItem();
            for (Map.Entry entry : matchingMapWithParents.entrySet()) {
                if (!((List)entry.getValue()).contains(checkForCommonAncestor)) continue;
                ArrayList items = (ArrayList)treeMap.get(((List)entry.getValue()).indexOf(checkForCommonAncestor));
                if (items == null) {
                    items = new ArrayList();
                    items.add(entry.getKey());
                    treeMap.put(((List)entry.getValue()).indexOf(checkForCommonAncestor), items);
                    continue;
                }
                items.add(entry.getKey());
            }
        }
        if (treeMap.size() > 0) {
            for (int i = 0; i <= 25; ++i) {
                if (!treeMap.containsKey(i)) continue;
                for (HstSiteMapItem item : (List)treeMap.get(i)) {
                    if (contextOrderedMatches.contains(item)) continue;
                    contextOrderedMatches.add(item);
                    unsortedItems.remove(item);
                    if (unsortedItems.size() != 1) continue;
                    contextOrderedMatches.add((HstSiteMapItem)unsortedItems.get(0));
                    return contextOrderedMatches;
                }
            }
        }
        if (matchingSiteMapItems.size() > 0) {
            ArrayList<HstSiteMapItemService> remaining = new ArrayList<HstSiteMapItemService>();
            for (HstSiteMapItem item : matchingSiteMapItems) {
                if (contextOrderedMatches.contains(item)) continue;
                remaining.add((HstSiteMapItemService)item);
            }
            Collections.sort(remaining, new LowestDepthFirstAndThenLexicalComparator());
            contextOrderedMatches.addAll(remaining);
        }
        return contextOrderedMatches;
    }

    class LowestDepthFirstAndThenLexicalComparator
    implements Comparator<HstSiteMapItemService> {
        LowestDepthFirstAndThenLexicalComparator() {
        }

        @Override
        public int compare(HstSiteMapItemService item1, HstSiteMapItemService item2) {
            if (item1.getDepth() == item2.getDepth()) {
                return item1.getId().compareTo(item2.getId());
            }
            return item1.getDepth() - item2.getDepth();
        }
    }
}

