/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking;

import java.util.List;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.linking.HstLinkProcessor;

public class HstLinkProcessorChain
implements HstLinkProcessor {
    private List<HstLinkProcessor> processorsInChain;

    public void setProcessorsInChain(List<HstLinkProcessor> processorsInChain) {
        this.processorsInChain = processorsInChain;
    }

    public HstLink postProcess(HstLink link) {
        if (this.processorsInChain == null) {
            return link;
        }
        HstLink linkToBeProcessed = link;
        for (HstLinkProcessor processor : this.processorsInChain) {
            linkToBeProcessed = processor.postProcess(linkToBeProcessed);
        }
        return linkToBeProcessed;
    }

    public HstLink preProcess(HstLink link) {
        if (this.processorsInChain == null) {
            return link;
        }
        HstLink linkToBeProcessed = link;
        for (HstLinkProcessor processor : this.processorsInChain) {
            linkToBeProcessed = processor.preProcess(linkToBeProcessed);
        }
        return linkToBeProcessed;
    }
}

