/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking;

import java.io.UnsupportedEncodingException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.hosting.MatchException;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItemService;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.component.HstComponentException;
import org.hippoecm.hst.core.component.HstURL;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.linking.ResolvedLocationMapTreeItem;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.request.ResolvedVirtualHost;
import org.hippoecm.hst.core.util.PathEncoder;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.site.request.ResolvedMountImpl;
import org.hippoecm.hst.util.HstRequestUtils;
import org.hippoecm.hst.util.HstSiteMapUtils;
import org.hippoecm.hst.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstLinkImpl
implements HstLink {
    private static final Logger log = LoggerFactory.getLogger(HstLinkImpl.class);
    private String path;
    private String subPath;
    private Mount mount;
    private Optional<HstSiteMapItem> siteMapItem;
    private boolean notFound = false;
    private Type type;
    ContentType contentType;

    public HstLinkImpl(String path, Mount mount) {
        this(path, mount, null, Type.UNKNOWN, true);
    }

    public HstLinkImpl(String path, Mount mount, boolean containerResource) {
        this(path, mount, null, containerResource, true);
    }

    public HstLinkImpl(ResolvedLocationMapTreeItem resolvedLocationMapTreeItem, Mount mount, boolean containerResource) {
        this(resolvedLocationMapTreeItem.getPath(), mount, resolvedLocationMapTreeItem.getSiteMapItem(), containerResource, true);
        this.contentType = resolvedLocationMapTreeItem.representsDocument() ? ContentType.DOCUMENT : ContentType.FOLDER;
    }

    public HstLinkImpl(String path, Mount mount, boolean containerResource, boolean rewriteHomePagePath) {
        this(path, mount, null, containerResource, rewriteHomePagePath);
    }

    public HstLinkImpl(String path, Mount mount, HstSiteMapItem siteMapItem, boolean containerResource, boolean rewriteHomePagePath) {
        this(path, mount, siteMapItem, containerResource ? Type.CONTAINER_RESOURCE : Type.MOUNT_RESOURCE, rewriteHomePagePath);
    }

    private HstLinkImpl(String path, Mount mount, HstSiteMapItem siteMapItem, Type type, boolean rewriteHomePagePath) {
        String homePagePath;
        this.path = path != null && path.startsWith("//") ? "//" + PathUtils.normalizePath((String)path) : PathUtils.normalizePath((String)path);
        this.mount = mount;
        if (siteMapItem != null) {
            this.siteMapItem = Optional.of(siteMapItem);
        }
        this.type = type;
        if (type == Type.UNKNOWN && mount != null && mount.getVirtualHost().getVirtualHosts().isHstFilterExcludedPath("/" + path)) {
            this.type = Type.CONTAINER_RESOURCE;
        }
        if (rewriteHomePagePath && this.path != null && mount != null && (path.equals(homePagePath = HstSiteMapUtils.getPath((Mount)mount, (String)mount.getHomePage())) || ("/" + path).equals(homePagePath))) {
            this.path = "";
        }
    }

    public Mount getMount() {
        return this.mount;
    }

    public HstSiteMapItem getHstSiteMapItem() {
        if (this.siteMapItem != null) {
            return this.siteMapItem.orElse(null);
        }
        HstRequestContext requestContext = RequestContextProvider.get();
        if (requestContext == null) {
            return null;
        }
        return this.resolveSiteMapItem(requestContext);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = PathUtils.normalizePath((String)path);
    }

    public String getSubPath() {
        return this.subPath;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    ContentType getContentType() {
        return this.contentType;
    }

    @Deprecated
    public boolean getContainerResource() {
        return this.isContainerResource();
    }

    public boolean isContainerResource() {
        if (Type.UNKNOWN == this.type) {
            HstSiteMapItem hstSiteMapItem;
            this.type = RequestContextProvider.get() == null || this.mount == null ? Type.CONTAINER_RESOURCE : (!this.mount.isMapped() ? Type.MOUNT_RESOURCE : ((hstSiteMapItem = this.resolveSiteMapItem(RequestContextProvider.get())) == null || hstSiteMapItem.isContainerResource() ? Type.CONTAINER_RESOURCE : Type.MOUNT_RESOURCE));
        }
        return Type.CONTAINER_RESOURCE == this.type;
    }

    public void setContainerResource(boolean containerResource) {
        this.type = containerResource ? Type.CONTAINER_RESOURCE : Type.MOUNT_RESOURCE;
    }

    public String[] getPathElements() {
        if (this.path == null) {
            return null;
        }
        return this.path.split("/");
    }

    public String toUrlForm(HstRequestContext requestContext, boolean fullyQualified) {
        String urlString;
        if (this.path == null) {
            log.warn("Unable to rewrite link. Return EVAL_PAGE");
            return null;
        }
        for (String s : PathUtils.FULLY_QUALIFIED_URL_PREFIXES) {
            if (!this.path.startsWith(s)) continue;
            try {
                String encoded = PathEncoder.encode(this.path, requestContext.getBaseURL().getURIEncoding(), PathUtils.FULLY_QUALIFIED_URL_PREFIXES);
                return encoded;
            }
            catch (UnsupportedEncodingException e) {
                throw new HstComponentException((Throwable)e);
            }
        }
        Mount requestMount = requestContext.getResolvedMount().getMount();
        String explicitContextPath = null;
        if (requestContext.isCmsRequest()) {
            explicitContextPath = this.mount != null && this.mount.getContextPath() != null ? this.mount.getContextPath() : requestContext.getServletRequest().getContextPath();
        } else if (this.mount != null && requestMount != this.mount && this.mount.isContextPathInUrl() && this.mount.getContextPath() != null) {
            explicitContextPath = this.mount.getContextPath();
        }
        if (this.isContainerResource()) {
            HstURL hstUrl = requestContext.getURLFactory().createURL("resource", "org.hippoecm.hst.container.reference.namespace", null, requestContext, explicitContextPath);
            hstUrl.setResourceID(this.path);
            urlString = hstUrl.toString();
        } else {
            HstManager mngr = (HstManager)HstServices.getComponentManager().getComponent(HstManager.class.getName());
            String subPathDelimeter = mngr.getPathSuffixDelimiter();
            if (this.subPath != null) {
                this.path = this.path + subPathDelimeter + this.subPath;
            }
            HstContainerURL navURL = requestContext.getContainerURLProvider().createURL(this.mount, requestContext.getBaseURL(), this.path);
            urlString = requestContext.getURLFactory().createURL("render", null, navURL, requestContext, explicitContextPath).toString();
            if (StringUtils.isEmpty((String)this.path) && StringUtils.isEmpty((String)urlString)) {
                urlString = "/";
            }
        }
        String renderHost = null;
        if (this.mount != null) {
            if (requestContext.isCmsRequest() && urlString.equals(requestMount.getContextPath())) {
                urlString = urlString + "/";
            }
            if (requestContext.getRenderHost() != null && requestMount != this.mount) {
                renderHost = this.mount.getVirtualHost().getHostName();
            } else if (!requestContext.isCmsRequest()) {
                HstSiteMapItem siteMapItem;
                if (StringUtils.isNotBlank((String)this.mount.getVirtualHost().getCdnHost()) && (siteMapItem = this.resolveSiteMapItem(requestContext)) != null && siteMapItem.isContainerResource() && this.isCdnSupportedPipeline(siteMapItem.getNamedPipeline())) {
                    log.debug("Using CDN host '{}' for container resource '{}'", (Object)this.mount.getVirtualHost().getCdnHost(), (Object)urlString);
                    return this.mount.getVirtualHost().getCdnHost() + urlString;
                }
                HstLinkImplCharacteristics hstLinkImplCharacteristics = new HstLinkImplCharacteristics(requestContext, fullyQualified);
                if (hstLinkImplCharacteristics.isFullyQualified()) {
                    String scheme = hstLinkImplCharacteristics.getScheme().equals("scheme_agnostic") ? HstRequestUtils.getFarthestRequestScheme((HttpServletRequest)requestContext.getServletRequest()) : hstLinkImplCharacteristics.getScheme();
                    String host = scheme + "://" + this.mount.getVirtualHost().getHostName();
                    if (this.mount.isPortInUrl()) {
                        int port = this.mount.getPort();
                        if (port == 0) {
                            port = requestContext.getBaseURL().getPortNumber();
                        }
                        if (port != 80 && port != 443) {
                            host = host + ":" + port;
                        }
                    }
                    urlString = host + urlString;
                }
            }
        }
        if (renderHost != null && !this.isContainerResource()) {
            urlString = urlString.contains("?") ? urlString + "&" : urlString + "?";
            urlString = urlString + "org.hippoecm.hst.container.render_host=" + renderHost;
        }
        return urlString;
    }

    private boolean isCdnSupportedPipeline(String pipeline) {
        return HstSiteMapItemService.CDN_SUPPORTED_PIPELINES.contains(pipeline);
    }

    public boolean isNotFound() {
        return this.notFound;
    }

    public void setNotFound(boolean notFound) {
        this.notFound = notFound;
    }

    private HstSiteMapItem resolveSiteMapItem(HstRequestContext requestContext) {
        if (this.siteMapItem != null) {
            return this.siteMapItem.orElse(null);
        }
        if (this.mount == null) {
            return null;
        }
        ResolvedSiteMapItem resolved = null;
        try {
            MutableResolvedVirtualHost resolvedHostForLink = new MutableResolvedVirtualHost(){
                private ResolvedMount resolvedMountForLink = null;

                public VirtualHost getVirtualHost() {
                    return HstLinkImpl.this.mount.getVirtualHost();
                }

                public String getResolvedHostName() {
                    return HstLinkImpl.this.mount.getVirtualHost().getHostName();
                }

                public int getPortNumber() {
                    return HstLinkImpl.this.mount.getPort();
                }

                public ResolvedMount matchMount(String contextPath, String requestPath) throws MatchException {
                    return this.resolvedMountForLink;
                }

                @Override
                public void setResolvedMount(ResolvedMount resMount) {
                    this.resolvedMountForLink = resMount;
                }
            };
            ResolvedMountImpl resMount = new ResolvedMountImpl(this.mount, resolvedHostForLink, this.mount.getMountPath(), this.mount.getVirtualHost().getVirtualHosts().getCmsPreviewPrefix(), requestContext.getResolvedMount().getPortNumber());
            resolvedHostForLink.setResolvedMount((ResolvedMount)resMount);
            if ("".equals(this.path) || "/".equals(this.path)) {
                log.debug("siteMapPathInfo is '' or '/'. If there is a homepage path configured, we try to map this path to the sitemap");
                resolved = this.mount.getHstSiteMapMatcher().match(resMount.getMount().getHomePage(), (ResolvedMount)resMount);
            } else {
                resolved = this.mount.getHstSiteMapMatcher().match(this.path, (ResolvedMount)resMount);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.info("Could not match a sitemap item ", (Throwable)e);
            }
            log.info("Could not match a sitemap item ", (Object)e.toString());
        }
        this.siteMapItem = resolved != null ? Optional.of(resolved.getHstSiteMapItem()) : Optional.empty();
        return this.siteMapItem.orElse(null);
    }

    private class HstLinkImplCharacteristics {
        private static final String SCHEME_AGNOSTIC = "scheme_agnostic";
        private final HstRequestContext requestContext;
        private boolean fullyQualified;
        private String scheme;

        public HstLinkImplCharacteristics(HstRequestContext requestContext, boolean explicitlyFullyQualified) {
            this.requestContext = requestContext;
            this.fullyQualified = explicitlyFullyQualified;
        }

        public boolean isFullyQualified() {
            HstSiteMapItem siteMapItem;
            if (this.fullyQualified) {
                return true;
            }
            if (this.requestContext.isFullyQualifiedURLs()) {
                return true;
            }
            if (HstLinkImpl.this.mount == null) {
                return false;
            }
            Mount requestMount = this.requestContext.getResolvedMount().getMount();
            if (requestMount.getVirtualHost() != HstLinkImpl.this.mount.getVirtualHost()) {
                return true;
            }
            if (HstLinkImpl.this.mount.isPortInUrl() && requestMount.getPort() != HstLinkImpl.this.mount.getPort()) {
                return true;
            }
            if (this.requestContext.getServletRequest() == null) {
                return false;
            }
            String farthestRequestScheme = HstRequestUtils.getFarthestRequestScheme((HttpServletRequest)this.requestContext.getServletRequest());
            if (HstLinkImpl.this.siteMapItem != null && HstLinkImpl.this.siteMapItem.isPresent()) {
                if (((HstSiteMapItem)HstLinkImpl.this.siteMapItem.get()).isSchemeAgnostic()) {
                    this.scheme = SCHEME_AGNOSTIC;
                    return false;
                }
                if (!farthestRequestScheme.equals(((HstSiteMapItem)HstLinkImpl.this.siteMapItem.get()).getScheme())) {
                    this.scheme = ((HstSiteMapItem)HstLinkImpl.this.siteMapItem.get()).getScheme();
                    return true;
                }
                return false;
            }
            if (HstLinkImpl.this.mount.isMapped() && (HstLinkImpl.this.mount.containsMultipleSchemes() || requestMount.containsMultipleSchemes() || requestMount.getVirtualHost().isCustomHttpsSupported() && farthestRequestScheme.equals("https")) && (siteMapItem = HstLinkImpl.this.resolveSiteMapItem(this.requestContext)) != null) {
                if (siteMapItem.isSchemeAgnostic()) {
                    this.scheme = SCHEME_AGNOSTIC;
                    return false;
                }
                if (!farthestRequestScheme.equals(siteMapItem.getScheme())) {
                    this.scheme = siteMapItem.getScheme();
                    return true;
                }
            }
            if (HstLinkImpl.this.mount.isSchemeAgnostic()) {
                this.scheme = SCHEME_AGNOSTIC;
                return false;
            }
            if (!(HstLinkImpl.this.mount.containsMultipleSchemes() || requestMount.containsMultipleSchemes() || HstLinkImpl.this.mount.getScheme().equals(requestMount.getScheme()))) {
                this.scheme = HstLinkImpl.this.mount.getScheme();
                return true;
            }
            return false;
        }

        public String getScheme() {
            if (this.scheme != null) {
                return this.scheme;
            }
            if (HstLinkImpl.this.mount == null) {
                this.scheme = this.requestContext.getResolvedMount().getMount().getScheme();
                return this.scheme;
            }
            if (this.schemeCannotBeDifferent()) {
                if (HstLinkImpl.this.mount.isSchemeAgnostic()) {
                    this.scheme = SCHEME_AGNOSTIC;
                    return this.scheme;
                }
                this.scheme = HstLinkImpl.this.mount.getScheme();
                return this.scheme;
            }
            HstSiteMapItem siteMapItem = HstLinkImpl.this.resolveSiteMapItem(this.requestContext);
            if (siteMapItem != null) {
                if (siteMapItem.isSchemeAgnostic()) {
                    this.scheme = SCHEME_AGNOSTIC;
                    return this.scheme;
                }
                this.scheme = siteMapItem.getScheme();
                return this.scheme;
            }
            if (HstLinkImpl.this.mount.isSchemeAgnostic()) {
                this.scheme = SCHEME_AGNOSTIC;
                return this.scheme;
            }
            this.scheme = HstLinkImpl.this.mount.getScheme();
            return this.scheme;
        }

        private boolean schemeCannotBeDifferent() {
            Mount requestMount = this.requestContext.getResolvedMount().getMount();
            return !HstLinkImpl.this.mount.containsMultipleSchemes() && !requestMount.containsMultipleSchemes() && HstLinkImpl.this.mount.getScheme().equals(requestMount.getScheme());
        }
    }

    static interface MutableResolvedVirtualHost
    extends ResolvedVirtualHost {
        public void setResolvedMount(ResolvedMount var1);
    }

    static enum ContentType {
        FOLDER,
        DOCUMENT,
        UNKNOWN;

    }

    static enum Type {
        CONTAINER_RESOURCE,
        MOUNT_RESOURCE,
        UNKNOWN;

    }
}

