/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.linking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.components.HstComponentsConfiguration;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.core.linking.HstLink;
import org.hippoecm.hst.core.linking.HstLinkCreator;
import org.hippoecm.hst.core.linking.HstLinkImpl;
import org.hippoecm.hst.core.linking.HstLinkProcessor;
import org.hippoecm.hst.core.linking.LocationMapResolver;
import org.hippoecm.hst.core.linking.LocationMapTree;
import org.hippoecm.hst.core.linking.LocationMapTreeComponentDocuments;
import org.hippoecm.hst.core.linking.LocationMapTreeSiteMap;
import org.hippoecm.hst.core.linking.LocationResolver;
import org.hippoecm.hst.core.linking.ResolvedLocationMapTreeItem;
import org.hippoecm.hst.core.linking.ResolvedLocationMapTreeItemImpl;
import org.hippoecm.hst.core.linking.ResourceContainer;
import org.hippoecm.hst.core.linking.ResourceLocationResolver;
import org.hippoecm.hst.core.linking.RewriteContext;
import org.hippoecm.hst.core.linking.RewriteContextException;
import org.hippoecm.hst.core.linking.RewriteContextResolver;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.util.HstSiteMapUtils;
import org.hippoecm.hst.util.NodeUtils;
import org.hippoecm.hst.util.PathUtils;
import org.onehippo.cms7.util.WeakIdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHstLinkCreator
implements HstLinkCreator {
    private static final Logger log = LoggerFactory.getLogger(DefaultHstLinkCreator.class);
    private static final String DEFAULT_PAGE_NOT_FOUND_PATH = "pagenotfound";
    public static final String BINARIES_PREFIX = "/binaries";
    public static final String BINARIES_START_PATH = "binaries/";
    private String[] binaryLocations;
    private String pageNotFoundPath = "pagenotfound";
    private WeakIdentityMap<HstSiteMapItem, SubLocationMapTreesHolder> loadedSubLocationMapTreesHolder = WeakIdentityMap.newConcurrentHashMap();
    private HstLinkProcessor linkProcessor;
    private List<LocationResolver> locationResolvers;
    private RewriteContextResolver rewriteContextResolver;

    public void setRewriteContextResolver(RewriteContextResolver rewriteContextResolver) {
        this.rewriteContextResolver = rewriteContextResolver;
    }

    @Deprecated
    public void setBinariesPrefix(String binariesPrefix) {
        if (StringUtils.isNotBlank((String)binariesPrefix)) {
            log.warn("hst-config.properties property 'binaries.prefix.path' is not used any more. Ignoring configured value '{}'. If you configured a cdn host in the binaries prefix, you have to configure that now on a hst:virtualhost or hst:mount configuration node through property '{}'.", (Object)binariesPrefix, (Object)"hst:cdnhost");
        }
    }

    public void setBinaryLocations(String[] binaryLocations) {
        if (binaryLocations == null) {
            this.binaryLocations = null;
        } else {
            this.binaryLocations = new String[binaryLocations.length];
            System.arraycopy(binaryLocations, 0, this.binaryLocations, 0, binaryLocations.length);
        }
    }

    public void setLinkProcessor(HstLinkProcessor linkProcessor) {
        this.linkProcessor = linkProcessor;
    }

    public void setLocationResolvers(List<LocationResolver> locationResolvers) {
        this.locationResolvers = locationResolvers;
    }

    public List<LocationResolver> getLocationResolvers() {
        return this.locationResolvers;
    }

    public void setPageNotFoundPath(String pageNotFoundPath) {
        this.pageNotFoundPath = PathUtils.normalizePath((String)pageNotFoundPath);
    }

    public void clear() {
    }

    public HstLink create(String uuid, Session session, HstRequestContext requestContext) {
        try {
            Node node = session.getNodeByIdentifier(uuid);
            return this.create(node, requestContext);
        }
        catch (ItemNotFoundException e) {
            log.info("Node with uuid '{}' cannot be found. Cannot create a HstLink, return null", (Object)uuid);
        }
        catch (RepositoryException e) {
            log.warn("RepositoryException Cannot create a HstLink, return null", (Object)uuid);
        }
        return null;
    }

    public HstLink create(HippoBean bean, HstRequestContext hstRequestContext) {
        return this.create(bean.getNode(), hstRequestContext);
    }

    public HstLink create(Node node, HstRequestContext hstRequestContext) {
        HstLinkResolver linkResolver = new HstLinkResolver(node, hstRequestContext);
        return linkResolver.resolve();
    }

    public List<HstLink> createAll(Node node, HstRequestContext hstRequestContext, boolean crossMount) {
        Mount mount = hstRequestContext.getResolvedMount().getMount();
        String type = mount.getType();
        String hostGroupName = mount.getVirtualHost().getHostGroupName();
        return this.createAll(node, hstRequestContext, hostGroupName, type, crossMount);
    }

    public List<HstLink> createAll(Node node, HstRequestContext hstRequestContext, String hostGroupName, String type, boolean crossMount) {
        HstLinkResolver linkResolver = new HstLinkResolver(node, hstRequestContext);
        if (!crossMount) {
            linkResolver.resolverProperties.tryOtherMounts = false;
        }
        return linkResolver.resolveAll(type, hostGroupName);
    }

    public HstLink create(Node node, HstRequestContext requestContext, HstSiteMapItem preferredItem, boolean fallback) {
        return this.create(node, requestContext, preferredItem, fallback, false);
    }

    public HstLink create(Node node, HstRequestContext requestContext, HstSiteMapItem preferredItem, boolean fallback, boolean navigationStateful) {
        HstLinkResolver linkResolver = new HstLinkResolver(node, requestContext);
        linkResolver.resolverProperties.preferredItem = preferredItem;
        linkResolver.resolverProperties.fallback = fallback;
        if (!fallback) {
            linkResolver.resolverProperties.tryOtherMounts = false;
        }
        linkResolver.resolverProperties.navigationStateful = navigationStateful;
        return linkResolver.resolve();
    }

    public HstLink createCanonical(Node node, HstRequestContext requestContext) {
        return this.createCanonical(node, requestContext, null);
    }

    public HstLink createCanonical(Node node, HstRequestContext requestContext, HstSiteMapItem preferredItem) {
        HstLinkResolver linkResolver = new HstLinkResolver(node, requestContext);
        linkResolver.resolverProperties.canonicalLink = true;
        linkResolver.resolverProperties.preferredItem = preferredItem;
        linkResolver.resolverProperties.fallback = true;
        return linkResolver.resolve();
    }

    public List<HstLink> createAllAvailableCanonicals(Node node, HstRequestContext requestContext) {
        return this.createAllAvailableCanonicals(node, requestContext, null, null);
    }

    public List<HstLink> createAllAvailableCanonicals(Node node, HstRequestContext requestContext, String type) {
        return this.createAllAvailableCanonicals(node, requestContext, type, null);
    }

    public List<HstLink> createAllAvailableCanonicals(Node node, HstRequestContext requestContext, String type, String hostGroupName) {
        HstLinkResolver linkResolver = new HstLinkResolver(node, requestContext);
        return linkResolver.resolveAllCanonicals(type, hostGroupName);
    }

    public HstLink create(Node node, Mount mount) {
        HstLinkResolver linkResolver = new HstLinkResolver(node, mount);
        linkResolver.resolverProperties.tryOtherMounts = false;
        linkResolver.resolverProperties.canonicalLink = true;
        return linkResolver.resolve();
    }

    public HstLink create(Node node, Mount mount, HstSiteMapItem preferredItem, boolean fallback) {
        HstLinkResolver linkResolver = new HstLinkResolver(node, mount);
        linkResolver.resolverProperties.tryOtherMounts = false;
        linkResolver.resolverProperties.preferredItem = preferredItem;
        linkResolver.resolverProperties.fallback = fallback;
        return linkResolver.resolve();
    }

    public HstLink create(Node node, HstRequestContext requestContext, String mountAlias) {
        Mount targetMount = requestContext.getMount(mountAlias);
        if (targetMount == null) {
            Mount currentMount = requestContext.getResolvedMount().getMount();
            StringBuffer types = new StringBuffer();
            for (String type : currentMount.getTypes()) {
                if (types.length() > 0) {
                    types.append(",");
                }
                types.append(type);
            }
            Object[] messages = new String[]{mountAlias, currentMount.getVirtualHost().getHostGroupName(), types.toString()};
            log.info("Cannot create a link for mountAlias '{}' as it cannot be found in the host group '{}' and one of the types '{}'", messages);
            return null;
        }
        log.debug("Target Mount found for mountAlias '{}'. Create link for target Mount", (Object)mountAlias);
        return this.create(node, targetMount);
    }

    public HstLink create(Node node, HstRequestContext requestContext, String mountAlias, String type) {
        Mount targetMount = requestContext.getMount(mountAlias, type);
        if (targetMount == null) {
            Object[] messages = new String[]{mountAlias, requestContext.getVirtualHost().getHostGroupName(), type};
            log.info("Cannot create a link for mountAlias '{}' as it cannot be found in the host group '{}' for type '{}'", messages);
            return null;
        }
        log.debug("Target Mount found for mountAlias '{}'. Create link for target Mount", (Object)mountAlias);
        return this.create(node, targetMount);
    }

    public HstLink create(String path, Mount mount) {
        String nodePath;
        String normalizedPath = PathUtils.normalizePath((String)path);
        HstLinkImpl hstLink = null;
        if (normalizedPath.startsWith(BINARIES_START_PATH) && this.isBinaryLocation(nodePath = normalizedPath.substring(BINARIES_START_PATH.length() - 1))) {
            hstLink = this.createHstLinkForBinaryLocation(nodePath, mount);
        }
        if (hstLink == null) {
            hstLink = new HstLinkImpl(normalizedPath, mount);
        }
        return this.postProcess(hstLink);
    }

    public HstLink create(String path, Mount mount, boolean containerResource) {
        String nodePath;
        String normalizedPath = PathUtils.normalizePath((String)path);
        HstLinkImpl hstLink = null;
        if (normalizedPath.startsWith(BINARIES_START_PATH) && this.isBinaryLocation(nodePath = normalizedPath.substring(BINARIES_START_PATH.length() - 1))) {
            hstLink = this.createHstLinkForBinaryLocation(nodePath, mount);
        }
        if (hstLink == null) {
            hstLink = new HstLinkImpl(normalizedPath, mount, containerResource);
        }
        return this.postProcess(hstLink);
    }

    private HstLink createHstLinkForBinaryLocation(String nodePath, Mount mount) {
        try {
            Node node = RequestContextProvider.get().getSession().getNode(nodePath);
            Node resourceNode = null;
            Node resourceContainerNode = null;
            if (node.isNodeType("hippo:resource")) {
                resourceNode = node;
            } else if (node.isNodeType("hippo:handle")) {
                resourceContainerNode = node.getNode(node.getName());
            } else if (node.isNodeType("hippo:document") && node.getParent().isNodeType("hippo:handle")) {
                resourceContainerNode = node;
            }
            if (resourceNode == null && resourceContainerNode == null) {
                if (nodePath.startsWith("/")) {
                    return new HstLinkImpl(BINARIES_PREFIX + nodePath, mount, true);
                }
                return new HstLinkImpl("/binaries/" + nodePath, mount, true);
            }
            if (resourceNode != null) {
                for (LocationResolver resolver : this.locationResolvers) {
                    if (!resourceNode.isNodeType(resolver.getNodeType())) continue;
                    HstLink hstLink = resolver.resolve(resourceNode, mount, mount.getHstSite().getLocationMapTree());
                    if (hstLink != null) {
                        log.debug("Location resolved for nodetype '{}' is able to create link for node '{}'.", (Object)resolver.getNodeType(), (Object)nodePath);
                        return hstLink;
                    }
                    log.debug("Location resolved for nodetype '{}' is not able to create link for node '{}'. Try next location resolver", (Object)resolver.getNodeType(), (Object)nodePath);
                }
            } else if (resourceContainerNode != null) {
                for (LocationResolver resolver : this.locationResolvers) {
                    if (!(resolver instanceof ResourceLocationResolver)) continue;
                    for (ResourceContainer container : ((ResourceLocationResolver)resolver).getResourceContainers()) {
                        String pathInfo;
                        if (!resourceContainerNode.isNodeType(container.getNodeType()) || container.getPrimaryItem() == null) continue;
                        if (resourceContainerNode.hasNode(container.getPrimaryItem()) && (pathInfo = container.resolveToPathInfo(resourceContainerNode, resourceNode = resourceContainerNode.getNode(container.getPrimaryItem()), mount)) != null) {
                            log.debug("Resource Container resolved for nodetype '{}' is able to create link for node '{}'.", (Object)container.getNodeType(), (Object)nodePath);
                            if (pathInfo.startsWith("/")) {
                                return new HstLinkImpl(BINARIES_PREFIX + pathInfo, mount, true);
                            }
                            return new HstLinkImpl("/binaries/" + pathInfo, mount, true);
                        }
                        log.debug("resourceContainer for '{}' unable to create a HstLink for path '{}'. Try next", (Object)container.getNodeType(), (Object)nodePath);
                    }
                }
            }
        }
        catch (RepositoryException e) {
            log.debug("Could not find '{}' node for '{}'. Return plain path link.", (Object)"hippo:resource", (Object)nodePath);
        }
        if (nodePath.startsWith("/")) {
            return new HstLinkImpl(BINARIES_PREFIX + nodePath, mount, true);
        }
        return new HstLinkImpl("/binaries/" + nodePath, mount, true);
    }

    public HstLink createPageNotFoundLink(Mount mount) {
        HstLinkImpl link = new HstLinkImpl(this.pageNotFoundPath, mount);
        link.setNotFound(true);
        return link;
    }

    public HstLink create(HstSiteMapItem toHstSiteMapItem, Mount mount) {
        return this.postProcess(new HstLinkImpl(HstSiteMapUtils.getPath((HstSiteMapItem)toHstSiteMapItem), mount));
    }

    public HstLink createByRefId(String siteMapItemRefId, Mount mount) {
        if (mount.getHstSite() == null) {
            log.info("Cannot create a link to a siteMapItemRefId '{}' for a mount '{}' that does not have a HstSiteMap. Return null", (Object)siteMapItemRefId, (Object)mount.getName());
            return null;
        }
        HstSiteMapItem siteMapItem = mount.getHstSite().getSiteMap().getSiteMapItemByRefId(siteMapItemRefId);
        if (siteMapItem == null) {
            log.info("Could not find HstSiteMapItem for siteMapItemRefId '{}' and mount '{}'. Return null", (Object)siteMapItemRefId, (Object)mount.getName());
            return null;
        }
        return this.create(siteMapItem, mount);
    }

    private HstLink postProcess(HstLink link) {
        if (this.linkProcessor != null) {
            link = this.linkProcessor.postProcess(link);
        }
        return link;
    }

    public String getBinariesPrefix() {
        return BINARIES_PREFIX;
    }

    public boolean isBinaryLocation(String path) {
        if (this.binaryLocations == null || path == null) {
            return false;
        }
        for (String prefix : this.binaryLocations) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private RewriteContext createRewriteContext(Node node, Mount mount, ResolverProperties resolverProperties) throws RepositoryException, RewriteContextException {
        RewriteContext rewriteContext;
        if (this.rewriteContextResolver == null) {
            new RewriteContext(node.getPath(), mount, resolverProperties.canonicalLink, resolverProperties.navigationStateful);
        }
        if (log.isDebugEnabled()) {
            long start = System.nanoTime();
            rewriteContext = this.rewriteContextResolver.resolve(node, mount, RequestContextProvider.get(), resolverProperties.canonicalLink, resolverProperties.navigationStateful);
            log.debug("RewriteContextResolver '{}' took '{}' ms to get link rewrite path '{}' for node '{}'", new Object[]{this.rewriteContextResolver.getClass().getName(), String.valueOf((double)(System.nanoTime() - start) / 1000000.0), rewriteContext.getPath(), node.getPath()});
        } else {
            rewriteContext = this.rewriteContextResolver.resolve(node, mount, RequestContextProvider.get(), resolverProperties.canonicalLink, resolverProperties.navigationStateful);
        }
        if (rewriteContext.isCanonical() != resolverProperties.canonicalLink) {
            log.debug("Resetting canonical from resolver properties to '{}' because modified through RewriteContext '{}'", (Object)rewriteContext.isCanonical(), (Object)rewriteContext);
            resolverProperties.canonicalLink = rewriteContext.isCanonical();
        }
        if (rewriteContext.isNavigationStateful() != resolverProperties.navigationStateful) {
            log.debug("Resetting navigationStateful from resolver properties to '{}' because modified through RewriteContext '{}'", (Object)rewriteContext.isNavigationStateful(), (Object)rewriteContext);
            resolverProperties.navigationStateful = rewriteContext.isNavigationStateful();
        }
        return rewriteContext;
    }

    private LocationMapResolver getSubLocationMapResolver(HstSiteMapItem preferredItem, HstComponentsConfiguration componentsConfiguration, String mountContentPath, String contextPath) {
        SubLocationMapTreesHolder subLocationMapTreesHolder = (SubLocationMapTreesHolder)this.loadedSubLocationMapTreesHolder.get((Object)preferredItem);
        if (subLocationMapTreesHolder == null) {
            subLocationMapTreesHolder = new SubLocationMapTreesHolder(new LocationMapTreeSiteMap(preferredItem), new LocationMapTreeComponentDocuments(preferredItem, componentsConfiguration, mountContentPath, contextPath));
            this.loadedSubLocationMapTreesHolder.put((Object)preferredItem, (Object)subLocationMapTreesHolder);
        }
        return new LocationMapResolver(subLocationMapTreesHolder.subLocationMapTreeSiteMap, subLocationMapTreesHolder.subLocationMapTreeComponentDocuments);
    }

    private static class SubLocationMapTreesHolder {
        private LocationMapTree subLocationMapTreeSiteMap;
        private LocationMapTree subLocationMapTreeComponentDocuments;

        public SubLocationMapTreesHolder(LocationMapTreeSiteMap subLocationMapTreeSiteMap, LocationMapTreeComponentDocuments subLocationMapTreeComponentDocuments) {
            this.subLocationMapTreeSiteMap = subLocationMapTreeSiteMap;
            this.subLocationMapTreeComponentDocuments = subLocationMapTreeComponentDocuments;
        }
    }

    static class LowestDepthFirstAndThenLexicalComparator
    implements Comparator<HstLink> {
        LowestDepthFirstAndThenLexicalComparator() {
        }

        @Override
        public int compare(HstLink link1, HstLink link2) {
            int depth2;
            String path1 = link1.getPath();
            String path2 = link2.getPath();
            if (path1 == null) {
                if (path2 == null) {
                    return 0;
                }
                return 1;
            }
            if (path2 == null) {
                return -1;
            }
            int depth1 = path1.split("/").length;
            if (depth1 == (depth2 = path2.split("/").length)) {
                return path1.compareTo(path2);
            }
            return depth1 - depth2;
        }
    }

    static class CandidateMountComparator
    implements Comparator<Mount> {
        Mount referenceMount;

        CandidateMountComparator(Mount referenceMount) {
            this.referenceMount = referenceMount;
        }

        @Override
        public int compare(Mount mount1, Mount mount2) {
            int depth2;
            int nrTypes2;
            int inCommon2;
            boolean equal2;
            boolean equal1 = mount1.getType().equals(this.referenceMount.getType());
            if (equal1 != (equal2 = mount1.getType().equals(this.referenceMount.getType()))) {
                if (equal2) {
                    return 1;
                }
                return -1;
            }
            int inCommon1 = this.countCommon(mount1.getTypes(), this.referenceMount.getTypes());
            if (inCommon1 != (inCommon2 = this.countCommon(mount2.getTypes(), this.referenceMount.getTypes()))) {
                if (inCommon2 > inCommon1) {
                    return 1;
                }
                return -1;
            }
            int nrTypes1 = mount1.getTypes().size();
            if (nrTypes1 != (nrTypes2 = mount2.getTypes().size())) {
                if (nrTypes2 < nrTypes1) {
                    return 1;
                }
                return -1;
            }
            int depth1 = mount1.getContentPath().split("/").length;
            if (depth1 != (depth2 = mount2.getContentPath().split("/").length)) {
                if (depth2 > depth1) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        private int countCommon(List<String> types, List<String> types2) {
            int counter = 0;
            for (String type : types) {
                if (!types2.contains(type)) continue;
                ++counter;
            }
            return counter;
        }
    }

    private static class ResolverProperties {
        ResolvedSiteMapItem resolvedSiteMapItem;
        HstSiteMapItem preferredItem;
        boolean virtual;
        boolean tryOtherMounts = true;
        boolean canonicalLink;
        boolean representsDocument;
        boolean fallback;
        boolean navigationStateful;

        private ResolverProperties() {
        }
    }

    private class HstLinkResolver {
        Node node;
        final String originalNodePath;
        Mount mount;
        ResolverProperties resolverProperties;

        HstLinkResolver(Node node, HstRequestContext requestContext) {
            this.node = node;
            this.originalNodePath = this.getOriginalNodePath(node);
            this.resolverProperties = new ResolverProperties();
            this.resolverProperties.resolvedSiteMapItem = requestContext.getResolvedSiteMapItem();
            this.mount = requestContext.getResolvedMount().getMount();
        }

        HstLinkResolver(Node node, Mount mount) {
            this.node = node;
            this.originalNodePath = this.getOriginalNodePath(node);
            this.mount = mount;
            this.resolverProperties = new ResolverProperties();
        }

        private String getOriginalNodePath(Node node) {
            try {
                return node.getPath();
            }
            catch (RepositoryException e) {
                log.error("Repository exception while fetching node path");
                return "??";
            }
        }

        protected HstLink resolve() {
            if (this.mount == null) {
                log.info("Cannot create link when the mount is null. Return null");
                return null;
            }
            if (this.node == null) {
                log.info("Cannot create link when the jcr node null. Return a page not found link");
                return DefaultHstLinkCreator.this.createPageNotFoundLink(this.mount);
            }
            Node canonicalNode = null;
            if (!this.resolverProperties.navigationStateful) {
                canonicalNode = NodeUtils.getCanonicalNode((Node)this.node);
            }
            HstLink hstLink = null;
            try {
                if (this.node.isNodeType("hippo:resource")) {
                    for (LocationResolver resolver : DefaultHstLinkCreator.this.locationResolvers) {
                        if (!this.node.isNodeType(resolver.getNodeType())) continue;
                        LocationMapTree locationMapTree = this.mount.isMapped() && this.mount.getHstSite() != null ? this.mount.getHstSite().getLocationMapTree() : null;
                        HstLink link = resolver.resolve(this.node, this.mount, locationMapTree);
                        if (link != null) {
                            return link;
                        }
                        log.debug("Location resolved for nodetype '{}' is not able to create link for node '{}'. Try next location resolver", (Object)resolver.getNodeType(), (Object)this.originalNodePath);
                    }
                    log.info("There is no resolver that can handle a resource of type '{}'. Return do not found link", (Object)this.node.getPrimaryNodeType().getName());
                    return DefaultHstLinkCreator.this.createPageNotFoundLink(this.mount);
                }
                if (canonicalNode != null) {
                    this.node = canonicalNode;
                } else {
                    this.resolverProperties.virtual = true;
                }
                if (this.node.isNodeType("hippo:facetselect") || this.node.isNodeType("hippo:mirror")) {
                    this.node = NodeUtils.getDeref((Node)this.node);
                    if (this.node == null) {
                        log.info("Broken content internal link for '{}'. Cannot create a HstLink for it. Return null", (Object)this.originalNodePath);
                        return DefaultHstLinkCreator.this.createPageNotFoundLink(this.mount);
                    }
                }
                if (this.node.isNodeType("hippo:handle")) {
                    this.resolverProperties.representsDocument = true;
                } else if (this.node.isNodeType("hippo:document")) {
                    if (this.node.getParent().isNodeType("hippo:handle")) {
                        this.node = this.node.getParent();
                        this.resolverProperties.representsDocument = true;
                    } else if (this.node.getParent().isNodeType("hippo:facetresult")) {
                        this.resolverProperties.representsDocument = true;
                    }
                }
                RewriteContext rewriteContext = DefaultHstLinkCreator.this.createRewriteContext(this.node, this.mount, this.resolverProperties);
                String rewritePath = rewriteContext.getPath();
                Mount rewriteMount = rewriteContext.getMount();
                hstLink = this.resolveToHstLink(rewritePath, rewriteMount, this.resolverProperties);
                if (hstLink == null && this.resolverProperties.tryOtherMounts) {
                    List<Mount> candidateMounts;
                    log.debug("We cannot create a link for '{}' for the mount '{}' belonging to the current request. Try to create a cross-domain/site/channel link.", (Object)rewritePath, (Object)rewriteMount.getName());
                    if (this.resolverProperties.preferredItem != null) {
                        this.resolverProperties.preferredItem = null;
                        log.info("Trying other mount than current context mount for nodePath '{}'. Cross domain linking cannot be combined with linking to a preferred sitemap item. We'll ignore the preferred item,", (Object)rewritePath);
                    }
                    if ((candidateMounts = this.findAllCandidateMounts(rewriteMount, rewritePath, rewriteMount.getVirtualHost().getHostGroupName(), rewriteMount.getType())).size() == 0) {
                        log.info("There is no Mount available that is suited to linkrewrite '{}'. Return page not found link.", (Object)rewritePath);
                        return DefaultHstLinkCreator.this.createPageNotFoundLink(rewriteMount);
                    }
                    if (candidateMounts.size() == 1) {
                        hstLink = this.resolveToHstLink(rewritePath, candidateMounts.get(0), this.resolverProperties);
                    } else {
                        Mount tryMount;
                        Collections.sort(candidateMounts, new CandidateMountComparator(rewriteMount));
                        Iterator<Mount> iterator = candidateMounts.iterator();
                        while (iterator.hasNext() && (hstLink = this.resolveToHstLink(rewritePath, tryMount = iterator.next(), this.resolverProperties)) == null) {
                        }
                    }
                }
            }
            catch (RewriteContextException e) {
                log.debug("Returning not found link for '{}' :", (Object)this.originalNodePath, (Object)e);
                return DefaultHstLinkCreator.this.createPageNotFoundLink(this.mount);
            }
            catch (RepositoryException e) {
                log.error("Repository Exception during creating link", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Exception during creating link", (Throwable)e);
            }
            if (hstLink == null) {
                log.info("Cannot create a link for node with path '{}'. Return a page not found link", (Object)this.originalNodePath);
                return DefaultHstLinkCreator.this.createPageNotFoundLink(this.mount);
            }
            return DefaultHstLinkCreator.this.postProcess(hstLink);
        }

        List<HstLink> resolveAllCanonicals(String type, String hostGroupName) {
            this.resolverProperties.canonicalLink = true;
            if (this.resolverProperties.preferredItem != null) {
                log.info("preferredItem is not supported in combination with 'all available canonical links'. It will be ignored");
            }
            if (this.resolverProperties.navigationStateful) {
                log.info("navigationStateful is not supported in combination with 'all available canonical links'. It will be ignored");
            }
            if (this.mount == null) {
                log.info("Cannot create link when the mount is null. Return empty list for canonicalLinks.");
                return Collections.emptyList();
            }
            if (this.node == null) {
                log.info("Cannot create link when the jcr node is null. Return empty list for canonicalLinks.");
                return Collections.emptyList();
            }
            Node canonicalNode = NodeUtils.getCanonicalNode((Node)this.node);
            ArrayList<HstLink> hstLinkList = new ArrayList<HstLink>();
            try {
                if (this.node.isNodeType("hippo:resource")) {
                    log.info("For binary resources the HST has no support to return all available canonical links");
                    return Collections.emptyList();
                }
                if (canonicalNode == null) {
                    log.debug("The HST has no support to return all available canonical links for virtual only nodes");
                    return Collections.emptyList();
                }
                if (this.node.isNodeType("hippo:facetselect") || this.node.isNodeType("hippo:mirror")) {
                    this.node = NodeUtils.getDeref((Node)this.node);
                    if (this.node == null) {
                        log.debug("Broken content internal link for '{}'. Cannot create a HstLink for it. Return an empty list for canonical links.", (Object)this.originalNodePath);
                        return Collections.emptyList();
                    }
                }
                if (this.node.isNodeType("hippo:handle")) {
                    this.resolverProperties.representsDocument = true;
                } else if (this.node.isNodeType("hippo:document") && this.node.getParent().isNodeType("hippo:handle")) {
                    this.node = this.node.getParent();
                    this.resolverProperties.representsDocument = true;
                }
                RewriteContext rewriteContext = DefaultHstLinkCreator.this.createRewriteContext(this.node, this.mount, this.resolverProperties);
                String rewritePath = rewriteContext.getPath();
                Mount rewriteMount = rewriteContext.getMount();
                if (type == null) {
                    type = rewriteMount.getType();
                }
                ArrayList<Mount> candidateMounts = new ArrayList<Mount>();
                if (hostGroupName == null) {
                    candidateMounts.addAll(this.findAllCandidateMounts(rewriteMount, rewritePath, rewriteMount.getVirtualHost().getHostGroupName(), type));
                } else {
                    candidateMounts.addAll(this.findAllCandidateMounts(rewriteMount, rewritePath, hostGroupName, type));
                }
                if (candidateMounts.size() == 0) {
                    log.info("There is no Mount available that is suited to linkrewrite '{}'. Return empty list for canonicalLinks..", (Object)rewritePath);
                    return Collections.emptyList();
                }
                for (Mount tryMount : candidateMounts) {
                    HstLink hstLink = this.resolveToHstLink(rewritePath, tryMount, this.resolverProperties);
                    if (hstLink == null) continue;
                    hstLinkList.add(DefaultHstLinkCreator.this.postProcess(hstLink));
                }
            }
            catch (RewriteContextException e) {
                log.debug("LinkPathNotFoundException for '{}'. Return empty list", (Object)this.originalNodePath, (Object)e);
                return Collections.emptyList();
            }
            catch (RepositoryException e) {
                log.warn("Repository Exception during creating link", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Exception during creating link", (Throwable)e);
            }
            if (hstLinkList.isEmpty()) {
                log.debug("Cannot create any link for node with path '{}'. Return empty list for canonicalLinks.", (Object)this.originalNodePath);
                return Collections.emptyList();
            }
            return hstLinkList;
        }

        List<HstLink> resolveAll(String type, String hostGroupName) {
            if (this.resolverProperties.preferredItem != null) {
                log.warn("preferredItem is not supported in combination with 'all links'. It will be ignored");
            }
            if (this.resolverProperties.navigationStateful) {
                log.warn("navigationStateful is not supported in combination with 'all links'. It will be ignored");
            }
            if (this.mount == null) {
                log.info("Cannot create link when the mount is null. Return empty list for canonicalLinks.");
                return Collections.emptyList();
            }
            if (this.node == null) {
                log.info("Cannot create link when the jcr node is null. Return empty list for canonicalLinks.");
                return Collections.emptyList();
            }
            ArrayList<HstLink> hstLinkList = new ArrayList<HstLink>();
            try {
                if (this.node.isNodeType("hippo:resource")) {
                    log.info("For binary resources the HST has no support to return all available canonical links");
                    return Collections.emptyList();
                }
                if (this.node.isNodeType("hippo:facetselect") || this.node.isNodeType("hippo:mirror")) {
                    this.node = NodeUtils.getDeref((Node)this.node);
                    if (this.node == null) {
                        log.debug("Broken content internal link for '{}'. Cannot create a HstLink for it. Return an empty list for canonical links.", (Object)this.originalNodePath);
                        return Collections.emptyList();
                    }
                }
                if (this.node.isNodeType("hippo:handle")) {
                    this.resolverProperties.representsDocument = true;
                } else if (this.node.isNodeType("hippo:document") && this.node.getParent().isNodeType("hippo:handle")) {
                    this.node = this.node.getParent();
                    this.resolverProperties.representsDocument = true;
                }
                RewriteContext rewriteContext = DefaultHstLinkCreator.this.createRewriteContext(this.node, this.mount, this.resolverProperties);
                String rewritePath = rewriteContext.getPath();
                Mount rewriteMount = rewriteContext.getMount();
                if (type == null) {
                    type = rewriteMount.getType();
                }
                ArrayList<Mount> candidateMounts = new ArrayList<Mount>();
                if (this.resolverProperties.tryOtherMounts) {
                    candidateMounts.addAll(this.findAllCandidateMounts(rewriteMount, rewritePath, hostGroupName, type));
                } else {
                    candidateMounts.add(rewriteMount);
                }
                if (candidateMounts.size() == 0) {
                    log.info("There is no Mount available that is suited to linkrewrite '{}'. Return empty list.", (Object)rewritePath);
                    return Collections.emptyList();
                }
                for (Mount tryMount : candidateMounts) {
                    List<HstLinkImpl> hstLinkListForMount = this.resolveToHstLinkList(rewritePath, tryMount, this.resolverProperties);
                    HashMap<String, HstLinkImpl> collapsedLinks = new HashMap<String, HstLinkImpl>();
                    for (HstLinkImpl hstLink : hstLinkListForMount) {
                        String path = hstLink.getPath();
                        if (path == null) continue;
                        int index = path.indexOf(".");
                        if (index > -1) {
                            String pathBeforeExt = path.substring(0, index);
                            if (collapsedLinks.containsKey(pathBeforeExt)) {
                                if (hstLink.getContentType() != HstLinkImpl.ContentType.DOCUMENT) continue;
                                collapsedLinks.put(pathBeforeExt, hstLink);
                                continue;
                            }
                            collapsedLinks.put(path, hstLink);
                            continue;
                        }
                        if (collapsedLinks.containsKey(path)) {
                            if (hstLink.getContentType() != HstLinkImpl.ContentType.FOLDER) continue;
                            collapsedLinks.put(path, hstLink);
                            continue;
                        }
                        collapsedLinks.put(path, hstLink);
                    }
                    for (HstLinkImpl hstLink : collapsedLinks.values()) {
                        hstLinkList.add(DefaultHstLinkCreator.this.postProcess(hstLink));
                    }
                }
            }
            catch (RewriteContextException e) {
                log.debug("LinkPathNotFoundException for '{}'. Return empty list", (Object)this.originalNodePath, (Object)e);
                return Collections.emptyList();
            }
            catch (RepositoryException e) {
                log.warn("Repository Exception during creating link", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Exception during creating link", (Throwable)e);
            }
            if (hstLinkList.isEmpty()) {
                log.debug("Cannot create any link for node with path '{}'. Return empty list for canonicalLinks.", (Object)this.originalNodePath);
                return Collections.emptyList();
            }
            Collections.sort(hstLinkList, new LowestDepthFirstAndThenLexicalComparator());
            return hstLinkList;
        }

        private List<Mount> findAllCandidateMounts(Mount rewriteMount, String rewritePath, String hostGroupName, String type) {
            List mountsForHostGroup;
            ArrayList<Mount> candidateMounts = new ArrayList<Mount>();
            if (hostGroupName == null) {
                mountsForHostGroup = rewriteMount.getVirtualHost().getVirtualHosts().getMountsByHostGroup(rewriteMount.getVirtualHost().getHostGroupName());
            } else {
                mountsForHostGroup = rewriteMount.getVirtualHost().getVirtualHosts().getMountsByHostGroup(hostGroupName);
                if (mountsForHostGroup == null || mountsForHostGroup.isEmpty()) {
                    log.debug("Did not find any Mount for hostGroupName '{}'. Return empty list for canonicalLinks.");
                    return Collections.emptyList();
                }
            }
            for (Mount candidateMount : mountsForHostGroup) {
                if (!candidateMount.isMapped() || !rewritePath.startsWith(candidateMount.getContentPath() + "/") && !rewritePath.equals(candidateMount.getContentPath())) continue;
                if (type != null) {
                    if (candidateMount.getTypes().contains(type)) {
                        candidateMounts.add(candidateMount);
                        continue;
                    }
                    log.debug("Mount '{}' has the correct canonical content path to link rewrite '{}', but it does not have at least one type equal to '{}' hence cannot be used. Try next one", new Object[]{candidateMount, rewritePath, type});
                    continue;
                }
                if (Collections.disjoint(candidateMount.getTypes(), rewriteMount.getTypes())) {
                    log.debug("Mount '{}' has the correct canonical content path to link rewrite '{}', but it does not have at least one type in common with the current request Mount '{}'. Try next one", new Object[]{candidateMount, rewritePath, rewriteMount});
                    continue;
                }
                log.debug("Found a Mount '{}' where the nodePath '{}' belongs to. Add this Mount to the list of possible suited mounts", (Object)candidateMount, (Object)rewritePath);
                candidateMounts.add(candidateMount);
            }
            return candidateMounts;
        }

        private List<HstLinkImpl> resolveToHstLinkList(String nodePath, Mount tryMount, ResolverProperties resolverProperties) {
            ArrayList<HstLinkImpl> hstLinkList = new ArrayList<HstLinkImpl>();
            if (!resolverProperties.virtual && nodePath.equals(tryMount.getContentPath())) {
                String pathInfo = HstSiteMapUtils.getPath((Mount)tryMount, (String)tryMount.getHomePage());
                if (pathInfo != null) {
                    hstLinkList.add(new HstLinkImpl(pathInfo, tryMount, false));
                }
            } else if (!resolverProperties.virtual && nodePath.startsWith(tryMount.getContentPath() + "/")) {
                String relPath = nodePath.substring(tryMount.getContentPath().length());
                List<ResolvedLocationMapTreeItem> resolvedLocations = this.resolveToAllLocationMapTreeItem(relPath, tryMount, resolverProperties);
                for (ResolvedLocationMapTreeItem resolvedLocation : resolvedLocations) {
                    if (resolvedLocation.getPath() == null) continue;
                    hstLinkList.add(new HstLinkImpl(resolvedLocation, tryMount, false));
                }
            } else if (resolverProperties.virtual && nodePath.equals(tryMount.getContentPath())) {
                String pathInfo = HstSiteMapUtils.getPath((Mount)tryMount, (String)tryMount.getHomePage());
                if (pathInfo != null) {
                    hstLinkList.add(new HstLinkImpl(pathInfo, tryMount, false));
                }
            } else if (resolverProperties.virtual && nodePath.startsWith(tryMount.getContentPath() + "/")) {
                String relPath = nodePath.substring(tryMount.getContentPath().length());
                List<ResolvedLocationMapTreeItem> resolvedLocations = this.resolveToAllLocationMapTreeItem(relPath, tryMount, resolverProperties);
                for (ResolvedLocationMapTreeItem resolvedLocation : resolvedLocations) {
                    if (resolvedLocation.getPath() == null) continue;
                    hstLinkList.add(new HstLinkImpl(resolvedLocation, tryMount, false));
                }
            } else if (DefaultHstLinkCreator.this.isBinaryLocation(nodePath)) {
                log.debug("Binary path, return hstLink prefixing this path with '{}'", (Object)DefaultHstLinkCreator.BINARIES_PREFIX);
                HstLink hstLinkForBinaryLocation = DefaultHstLinkCreator.this.createHstLinkForBinaryLocation(nodePath, tryMount);
                if (hstLinkForBinaryLocation != null) {
                    hstLinkList.add((HstLinkImpl)hstLinkForBinaryLocation);
                } else {
                    String pathInfo = DefaultHstLinkCreator.BINARIES_PREFIX + nodePath;
                    if (pathInfo != null) {
                        hstLinkList.add(new HstLinkImpl(pathInfo, tryMount, true));
                    }
                }
            }
            return hstLinkList;
        }

        private List<ResolvedLocationMapTreeItem> resolveToAllLocationMapTreeItem(String path, Mount tryMount, ResolverProperties resolverProperties) {
            ArrayList<ResolvedLocationMapTreeItem> resolvedLocations = new ArrayList<ResolvedLocationMapTreeItem>();
            if (tryMount.isMapped() && tryMount.getHstSite() != null) {
                LocationMapResolver resolver = new LocationMapResolver(tryMount.getHstSite().getLocationMapTree(), tryMount.getHstSite().getLocationMapTreeComponentDocuments());
                resolver.setRepresentsDocument(resolverProperties.representsDocument);
                resolver.setCanonical(resolverProperties.canonicalLink);
                resolver.setResolvedSiteMapItem(resolverProperties.resolvedSiteMapItem);
                resolvedLocations.addAll(resolver.resolveAll(path));
            } else {
                resolvedLocations.add(new ResolvedLocationMapTreeItemImpl(path, null, resolverProperties.representsDocument));
            }
            if (log.isDebugEnabled()) {
                if (resolvedLocations.isEmpty()) {
                    log.debug("Could not resolve path '{}' to a sitemap item for mount '{}'. Other mounts will be tried if available.", (Object)path, (Object)tryMount);
                } else {
                    for (ResolvedLocationMapTreeItem resolvedLocation : resolvedLocations) {
                        log.debug("Successful resolved path '{}' to '{}' for mount '{}'", new Object[]{path, resolvedLocation, tryMount});
                    }
                }
            }
            return resolvedLocations;
        }

        private HstLink resolveToHstLink(String nodePath, Mount tryMount, ResolverProperties resolverProperties) {
            if (!resolverProperties.virtual && nodePath.equals(tryMount.getContentPath())) {
                String pathInfo = HstSiteMapUtils.getPath((Mount)tryMount, (String)tryMount.getHomePage());
                return pathInfo == null ? null : new HstLinkImpl(pathInfo, tryMount, false);
            }
            if (!resolverProperties.virtual && nodePath.startsWith(tryMount.getContentPath() + "/")) {
                String relPath = nodePath.substring(tryMount.getContentPath().length());
                ResolvedLocationMapTreeItem resolvedLocation = this.resolveToLocationMapTreeItem(relPath, tryMount, resolverProperties);
                if (resolvedLocation == null || resolvedLocation.getPath() == null) {
                    return null;
                }
                return new HstLinkImpl(resolvedLocation, tryMount, false);
            }
            if (resolverProperties.virtual && nodePath.equals(tryMount.getContentPath())) {
                String pathInfo = HstSiteMapUtils.getPath((Mount)tryMount, (String)tryMount.getHomePage());
                return pathInfo == null ? null : new HstLinkImpl(pathInfo, tryMount, false);
            }
            if (resolverProperties.virtual && nodePath.startsWith(tryMount.getContentPath() + "/")) {
                String relPath = nodePath.substring(tryMount.getContentPath().length());
                ResolvedLocationMapTreeItem resolvedLocation = this.resolveToLocationMapTreeItem(relPath, tryMount, resolverProperties);
                if (resolvedLocation == null || resolvedLocation.getPath() == null) {
                    return null;
                }
                return new HstLinkImpl(resolvedLocation, tryMount, false);
            }
            if (DefaultHstLinkCreator.this.isBinaryLocation(nodePath)) {
                HstLink hstLinkForBinaryLocation = DefaultHstLinkCreator.this.createHstLinkForBinaryLocation(nodePath, tryMount);
                if (hstLinkForBinaryLocation != null) {
                    return hstLinkForBinaryLocation;
                }
                log.debug("Binary path, return hstLink prefixing this path with '{}'", (Object)DefaultHstLinkCreator.BINARIES_PREFIX);
                String pathInfo = DefaultHstLinkCreator.BINARIES_PREFIX + nodePath;
                return new HstLinkImpl(pathInfo, tryMount, true);
            }
            return null;
        }

        private ResolvedLocationMapTreeItem resolveToLocationMapTreeItem(String path, Mount tryMount, ResolverProperties resolverProperties) {
            ResolvedLocationMapTreeItem resolvedLocation = null;
            if (tryMount.isMapped() && tryMount.getHstSite() != null) {
                if (resolverProperties.preferredItem != null) {
                    LocationMapResolver subResolver = DefaultHstLinkCreator.this.getSubLocationMapResolver(resolverProperties.preferredItem, tryMount.getHstSite().getComponentsConfiguration(), tryMount.getContentPath(), tryMount.getContextPath());
                    subResolver.setRepresentsDocument(resolverProperties.representsDocument);
                    subResolver.setResolvedSiteMapItem(resolverProperties.resolvedSiteMapItem);
                    subResolver.setCanonical(resolverProperties.canonicalLink);
                    subResolver.setSubResolver(true);
                    resolvedLocation = subResolver.resolve(path);
                    if (!(resolvedLocation != null && resolvedLocation.getPath() != null || resolverProperties.fallback)) {
                        log.debug("Could not resolve path '{}' for preferredItem '{}' for mount '{}'. Fallback is false. Other mounts will be tried if available.", new Object[]{path, resolverProperties.preferredItem.getId(), tryMount});
                        return null;
                    }
                }
                if (resolvedLocation == null) {
                    LocationMapResolver resolver = new LocationMapResolver(tryMount.getHstSite().getLocationMapTree(), tryMount.getHstSite().getLocationMapTreeComponentDocuments());
                    resolver.setRepresentsDocument(resolverProperties.representsDocument);
                    resolver.setCanonical(resolverProperties.canonicalLink);
                    resolver.setResolvedSiteMapItem(resolverProperties.resolvedSiteMapItem);
                    resolvedLocation = resolver.resolve(path);
                }
                if (resolvedLocation != null && resolvedLocation.getPath() != null) {
                    log.debug("Successful resolved path '{}' to '{}' for mount '{}'", new Object[]{path, resolvedLocation, tryMount});
                    return resolvedLocation;
                }
                log.debug("Could not resolve path '{}' to a sitemap item for mount '{}'. Other mounts will be tried if available.", (Object)path, (Object)tryMount);
                return null;
            }
            ResolvedLocationMapTreeItemImpl r = new ResolvedLocationMapTreeItemImpl(path, null, resolverProperties.representsDocument);
            log.debug("Mount '{}' does not have a sitemap. Return unmapped resolved location '{}'", (Object)tryMount, (Object)r);
            return r;
        }
    }
}

