/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.jcr;

import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.hippoecm.hst.core.jcr.LazySessionDelegatingRepository;
import org.hippoecm.hst.security.HstSubject;

public class SubjectBasedRepository
extends LazySessionDelegatingRepository {
    public SubjectBasedRepository(Repository delegatee) {
        super(delegatee);
    }

    @Override
    public Session login() throws LoginException, RepositoryException {
        Session session = this.loginBySubject(null);
        if (session != null) {
            return session;
        }
        return super.login();
    }

    @Override
    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        Session session = this.loginBySubject(null);
        if (session != null) {
            return session;
        }
        return super.login(credentials);
    }

    @Override
    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Session session = this.loginBySubject(workspaceName);
        if (session != null) {
            return session;
        }
        return super.login(workspaceName);
    }

    @Override
    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Session session = this.loginBySubject(workspaceName);
        if (session != null) {
            return session;
        }
        return super.login(credentials, workspaceName);
    }

    protected Session loginBySubject(String workspaceName) throws LoginException, RepositoryException {
        Subject subject = HstSubject.getSubject(null);
        if (subject != null) {
            Set<Credentials> repoCredsSet = subject.getPrivateCredentials(Credentials.class);
            if (!repoCredsSet.isEmpty()) {
                Credentials repoCreds = repoCredsSet.iterator().next();
                if (workspaceName == null) {
                    return super.login(repoCreds);
                }
                return super.login(repoCreds, workspaceName);
            }
            throw new LoginException("Repository credentials for the subject is not found.");
        }
        throw new LoginException("Subject is not found. Authentication required.");
    }
}

