/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.jcr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.jcr.SessionSecurityDelegation;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.repository.api.HippoSession;
import org.onehippo.repository.security.domain.DomainRuleExtension;
import org.onehippo.repository.security.domain.FacetRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSecurityDelegationImpl
implements SessionSecurityDelegation {
    private static final Logger log = LoggerFactory.getLogger(SessionSecurityDelegationImpl.class);
    private static final String SESSIONS_KEY_MAP_ATTR_NAME = SessionSecurityDelegationImpl.class.getName() + ".sessions.map";
    private static final String SESSIONS_KEY_LIST_ATTR_NAME = SessionSecurityDelegationImpl.class.getName() + ".sessions.list";
    private Repository repository;
    private Credentials previewCredentials;
    private Credentials liveCredentials;
    private boolean securityDelegationEnabled;

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setPreviewCredentials(Credentials credentials) {
        this.previewCredentials = credentials;
    }

    public void setLiveCredentials(Credentials credentials) {
        this.liveCredentials = credentials;
    }

    public void setSecurityDelegationEnabled(boolean securityDelegationEnabled) {
        this.securityDelegationEnabled = securityDelegationEnabled;
    }

    public boolean sessionSecurityDelegationEnabled() {
        return this.securityDelegationEnabled;
    }

    public void cleanupSessionDelegates(HstRequestContext requestContext) {
        Map<DelegateSessionKey, Session> sessionMap;
        List<Session> sessionList = this.getSessionList(requestContext);
        if (sessionList != null) {
            for (Session session : sessionList) {
                if (!session.isLive()) continue;
                session.logout();
            }
            sessionList.clear();
        }
        if ((sessionMap = this.getSessionMap(requestContext)) != null) {
            for (Session session : sessionMap.values()) {
                if (!session.isLive()) continue;
                session.logout();
            }
            sessionMap.clear();
        }
    }

    public Session getDelegatedSession(Credentials creds) throws RepositoryException {
        return this.repository.login(creds);
    }

    public Session getOrCreateLiveSecurityDelegate(Credentials delegate, String key) throws RepositoryException, IllegalStateException {
        return this.createLiveSecurityDelegate(delegate, key, true);
    }

    public Session createLiveSecurityDelegate(Credentials delegate, boolean autoLogout) throws RepositoryException, IllegalStateException {
        return this.createLiveSecurityDelegate(delegate, null, autoLogout);
    }

    private Session createLiveSecurityDelegate(Credentials delegate, String key, boolean autoLogout) throws RepositoryException, IllegalStateException {
        FacetRule facetRule = new FacetRule("hippo:availability", "live", true, true, 1);
        DomainRuleExtension dre = new DomainRuleExtension("*", "*", Arrays.asList(facetRule));
        return this.createSecurityDelegate(this.liveCredentials, delegate, key, autoLogout, dre);
    }

    public Session getOrCreatePreviewSecurityDelegate(Credentials delegate, String key) throws RepositoryException, IllegalStateException {
        return this.createPreviewSecurityDelegate(delegate, key, true);
    }

    public Session createPreviewSecurityDelegate(Credentials delegate, boolean autoLogout) throws RepositoryException, IllegalStateException {
        return this.createPreviewSecurityDelegate(delegate, null, autoLogout);
    }

    private Session createPreviewSecurityDelegate(Credentials delegate, String key, boolean autoLogout) throws RepositoryException, IllegalStateException {
        FacetRule facetRule = new FacetRule("hippo:availability", "preview", true, true, 1);
        DomainRuleExtension dre = new DomainRuleExtension("*", "*", Arrays.asList(facetRule));
        return this.createSecurityDelegate(this.previewCredentials, delegate, key, autoLogout, dre);
    }

    public Session createSecurityDelegate(Credentials cred1, Credentials cred2, boolean autoLogout, DomainRuleExtension ... domainExtensions) throws RepositoryException, IllegalStateException {
        return this.createSecurityDelegate(cred1, cred2, null, autoLogout, domainExtensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSecurityDelegate(Credentials cred1, Credentials cred2, String key, boolean autoLogout, DomainRuleExtension ... domainExtensions) throws RepositoryException, IllegalStateException {
        if (!this.securityDelegationEnabled) {
            throw new IllegalStateException("Security delegation is not enabled");
        }
        HstRequestContext requestContext = RequestContextProvider.get();
        if (autoLogout && key != null) {
            DelegateSessionKey dsk;
            Session existing;
            if (requestContext == null) {
                throw new IllegalStateException("Cannot automatically logout jcr session since there is no HstRequestContext");
            }
            Map<DelegateSessionKey, Session> sessionMap = this.getSessionMap(requestContext);
            if (sessionMap != null && (existing = sessionMap.get(dsk = new DelegateSessionKey(cred1, cred2, key, domainExtensions))) != null) {
                return existing;
            }
        }
        long start = System.currentTimeMillis();
        Session jcrSession = null;
        Session session1 = null;
        try {
            session1 = this.repository.login(cred1);
        }
        catch (LoginException e) {
            this.logWarningAndRethrow(cred1, e);
        }
        if (!(session1 instanceof HippoSession)) {
            session1.logout();
            throw new IllegalStateException("Repository returned Session is not a HippoSession.");
        }
        Session session2 = null;
        try {
            try {
                session2 = this.repository.login(cred2);
            }
            catch (LoginException e) {
                this.logWarningAndRethrow(cred2, e);
            }
            jcrSession = ((HippoSession)session1).createSecurityDelegate(session2, domainExtensions);
        }
        finally {
            if (session1 != null) {
                session1.logout();
            }
            if (session2 != null) {
                session2.logout();
            }
        }
        log.debug("Acquiring security delegate session took '{}' ms.", (Object)(System.currentTimeMillis() - start));
        if (autoLogout) {
            if (requestContext == null) {
                throw new IllegalStateException("Cannot automatically logout jcr session since there is no HstRequestContext");
            }
            if (key == null) {
                this.storeInList(jcrSession, requestContext);
            } else {
                DelegateSessionKey dsk = new DelegateSessionKey(cred1, cred2, key, domainExtensions);
                this.storeInMap(jcrSession, dsk, requestContext);
            }
        }
        return jcrSession;
    }

    private void logWarningAndRethrow(Credentials cred, LoginException e) throws LoginException {
        if (cred == this.previewCredentials) {
            log.error("Cannot create security delegate due to LoginException due to invalid preview credentials : {}", (Object)e.toString());
        } else if (cred == this.liveCredentials) {
            log.error("Cannot create security delegate due to LoginException due to invalid live credentials : {}", (Object)e.toString());
        } else {
            log.info("Cannot create security delegate due to LoginException : {}", (Object)e.toString());
        }
        throw e;
    }

    private void storeInList(Session jcrSession, HstRequestContext requestContext) {
        List<Session> sessionList = this.getSessionList(requestContext);
        if (sessionList == null) {
            sessionList = new ArrayList<Session>();
            requestContext.setAttribute(SESSIONS_KEY_LIST_ATTR_NAME, sessionList);
        }
        sessionList.add(jcrSession);
    }

    private void storeInMap(Session jcrSession, DelegateSessionKey key, HstRequestContext requestContext) {
        Map<DelegateSessionKey, Session> sessionMap = this.getSessionMap(requestContext);
        if (sessionMap == null) {
            sessionMap = new HashMap<DelegateSessionKey, Session>();
            requestContext.setAttribute(SESSIONS_KEY_MAP_ATTR_NAME, sessionMap);
        }
        sessionMap.put(key, jcrSession);
    }

    private Map<DelegateSessionKey, Session> getSessionMap(HstRequestContext requestContext) {
        return (Map)requestContext.getAttribute(SESSIONS_KEY_MAP_ATTR_NAME);
    }

    private List<Session> getSessionList(HstRequestContext requestContext) {
        return (List)requestContext.getAttribute(SESSIONS_KEY_LIST_ATTR_NAME);
    }

    private class DelegateSessionKey
    implements Serializable {
        final Credentials cred1;
        final Credentials cred2;
        final String key;
        final DomainRuleExtension[] domainExtensions;

        DelegateSessionKey(Credentials cred1, Credentials cred2, String key, DomainRuleExtension ... domainExtensions) {
            this.cred1 = cred1;
            this.cred2 = cred2;
            this.key = key;
            this.domainExtensions = domainExtensions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DelegateSessionKey)) {
                return false;
            }
            DelegateSessionKey that = (DelegateSessionKey)o;
            if (!this.credentialsEqual(this.cred1, that.cred1)) {
                return false;
            }
            if (!this.credentialsEqual(this.cred2, that.cred2)) {
                return false;
            }
            if (!Arrays.equals(this.domainExtensions, that.domainExtensions)) {
                return false;
            }
            return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
        }

        private boolean credentialsEqual(Credentials cred, Credentials compare) {
            if (cred instanceof SimpleCredentials && compare instanceof SimpleCredentials) {
                SimpleCredentials sc = (SimpleCredentials)cred;
                if (!sc.getUserID().equals(((SimpleCredentials)compare).getUserID())) {
                    return false;
                }
                return Arrays.equals(sc.getPassword(), ((SimpleCredentials)compare).getPassword());
            }
            return cred == compare;
        }

        public int hashCode() {
            int result = this.domainExtensions != null ? Arrays.hashCode(this.domainExtensions) : 0;
            result = 31 * result + this.getCredentialsHashCode(this.cred1);
            result = 31 * result + this.getCredentialsHashCode(this.cred2);
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        private int getCredentialsHashCode(Credentials cred) {
            if (cred instanceof SimpleCredentials) {
                SimpleCredentials sc = (SimpleCredentials)cred;
                return sc.getUserID().hashCode() * 31 + Arrays.hashCode(sc.getPassword());
            }
            return cred != null ? cred.hashCode() : 0;
        }
    }
}

