/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.core.jcr;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.hippoecm.hst.core.jcr.GenericEventListener;
import org.hippoecm.hst.core.jcr.LazySessionDelegatingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazySessionDelegatingRepositorySessionsRefreshEventListener
extends GenericEventListener {
    static Logger log = LoggerFactory.getLogger(LazySessionDelegatingRepositorySessionsRefreshEventListener.class);
    protected List<LazySessionDelegatingRepository> lazySessionDelegatingRepositories;

    public void setLazySessionDelegatingRepositories(List<LazySessionDelegatingRepository> lazySessionDelegatingRepositories) {
        this.lazySessionDelegatingRepositories = lazySessionDelegatingRepositories;
    }

    public void onEvent(EventIterator events) {
        boolean refreshSessions = false;
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                if (this.isEventOnSkippedPath(event)) continue;
                if (this.eventIgnorable(event)) {
                }
            }
            catch (RepositoryException e) {}
            continue;
            refreshSessions = true;
            break;
        }
        if (refreshSessions) {
            log.debug("Event received. Refreshing sessions.");
            this.doRefreshing();
        }
    }

    private void doRefreshing() {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lazySessionDelegatingRepositories != null && !this.lazySessionDelegatingRepositories.isEmpty()) {
            for (LazySessionDelegatingRepository lazySessionDelegatingRepository : this.lazySessionDelegatingRepositories) {
                lazySessionDelegatingRepository.setSessionsRefreshPendingAfter(currentTimeMillis);
            }
        }
    }
}

